/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.hikari.util;

import java.util.concurrent.TimeUnit;

public interface ClockSource {
    public static final ClockSource CLOCK = Factory.a();
    public static final TimeUnit[] TIMEUNITS_DESCENDING = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    public static final String[] TIMEUNIT_DISPLAY_VALUES = new String[]{"ns", "\u00b5s", "ms", "s", "m", "h", "d"};

    public static long currentTime() {
        return CLOCK.currentTime0();
    }

    public long currentTime0();

    public static long toMillis(long time) {
        long l;
        return CLOCK.toMillis0(l);
    }

    public long toMillis0(long var1);

    public static long toNanos(long time) {
        long l;
        return CLOCK.toNanos0(l);
    }

    public long toNanos0(long var1);

    public static long elapsedMillis(long startTime) {
        long l;
        return CLOCK.elapsedMillis0(l);
    }

    public long elapsedMillis0(long var1);

    /*
     * WARNING - void declaration
     */
    public static long elapsedMillis(long startTime, long endTime) {
        void var2_1;
        long l;
        return CLOCK.elapsedMillis0(l, (long)var2_1);
    }

    public long elapsedMillis0(long var1, long var3);

    public static long elapsedNanos(long startTime) {
        long l;
        return CLOCK.elapsedNanos0(l);
    }

    public long elapsedNanos0(long var1);

    /*
     * WARNING - void declaration
     */
    public static long elapsedNanos(long startTime, long endTime) {
        void var2_1;
        long l;
        return CLOCK.elapsedNanos0(l, (long)var2_1);
    }

    public long elapsedNanos0(long var1, long var3);

    /*
     * WARNING - void declaration
     */
    public static long plusMillis(long time, long millis) {
        void var2_1;
        long l;
        return CLOCK.plusMillis0(l, (long)var2_1);
    }

    public long plusMillis0(long var1, long var3);

    public static TimeUnit getSourceTimeUnit() {
        return CLOCK.getSourceTimeUnit0();
    }

    public TimeUnit getSourceTimeUnit0();

    /*
     * WARNING - void declaration
     */
    public static String elapsedDisplayString(long startTime, long endTime) {
        void var2_1;
        long l;
        return CLOCK.elapsedDisplayString0(l, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    default public String elapsedDisplayString0(long startTime, long endTime) {
        void var1_2;
        void var3_3;
        long elapsedNanos = this.elapsedNanos0(startTime, (long)var3_3);
        StringBuilder sb = new StringBuilder(elapsedNanos < 0L ? "-" : "");
        elapsedNanos = Math.abs(elapsedNanos);
        TimeUnit[] timeUnitArray = TIMEUNITS_DESCENDING;
        int n = TIMEUNITS_DESCENDING.length;
        for (int i = 0; i < n; ++i) {
            TimeUnit unit = timeUnitArray[i];
            long converted = unit.convert(elapsedNanos, TimeUnit.NANOSECONDS);
            if (converted <= 0L) continue;
            sb.append(converted).append(TIMEUNIT_DISPLAY_VALUES[unit.ordinal()]);
            elapsedNanos -= TimeUnit.NANOSECONDS.convert(converted, unit);
        }
        return var1_2.toString();
    }

    public static class NanosecondClockSource
    implements ClockSource {
        @Override
        public long currentTime0() {
            return System.nanoTime();
        }

        @Override
        public long toMillis0(long l) {
            return TimeUnit.NANOSECONDS.toMillis(l);
        }

        @Override
        public long toNanos0(long l) {
            return l;
        }

        @Override
        public long elapsedMillis0(long l) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
        }

        @Override
        public long elapsedMillis0(long l, long l2) {
            return TimeUnit.NANOSECONDS.toMillis(l2 - l);
        }

        @Override
        public long elapsedNanos0(long l) {
            return System.nanoTime() - l;
        }

        @Override
        public long elapsedNanos0(long l, long l2) {
            return l2 - l;
        }

        @Override
        public long plusMillis0(long l, long l2) {
            return l + TimeUnit.MILLISECONDS.toNanos(l2);
        }

        @Override
        public TimeUnit getSourceTimeUnit0() {
            return TimeUnit.NANOSECONDS;
        }
    }

    public static final class MillisecondClockSource
    implements ClockSource {
        @Override
        public final long currentTime0() {
            return System.currentTimeMillis();
        }

        @Override
        public final long elapsedMillis0(long l) {
            return System.currentTimeMillis() - l;
        }

        @Override
        public final long elapsedMillis0(long l, long l2) {
            return l2 - l;
        }

        @Override
        public final long elapsedNanos0(long l) {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - l);
        }

        @Override
        public final long elapsedNanos0(long l, long l2) {
            return TimeUnit.MILLISECONDS.toNanos(l2 - l);
        }

        @Override
        public final long toMillis0(long l) {
            return l;
        }

        @Override
        public final long toNanos0(long l) {
            return TimeUnit.MILLISECONDS.toNanos(l);
        }

        @Override
        public final long plusMillis0(long l, long l2) {
            return l + l2;
        }

        @Override
        public final TimeUnit getSourceTimeUnit0() {
            return TimeUnit.MILLISECONDS;
        }
    }

    public static class Factory {
        private static ClockSource b() {
            String string = System.getProperty("os.name");
            if ("Mac OS X".equals(string)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }

        static /* synthetic */ ClockSource a() {
            String string = System.getProperty("os.name");
            if ("Mac OS X".equals(string)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }
    }
}

