/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.Button;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.ButtonAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.InventoryAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.ItemAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.OutSideAction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.actions.SlotAction;

public interface InteractiveInventory {
    public Set<Button> getButtons();

    public Set<InventoryAction> getActions();

    /*
     * WARNING - void declaration
     */
    default public void addButton(Button button) {
        void var1_1;
        this.getButtons().add((Button)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void addAction(InventoryAction action) {
        void var1_1;
        this.getActions().add((InventoryAction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Button<?> getButtonByName(String name) {
        for (Button button : this.getButtons()) {
            void var3_3;
            if (!button.getName().equals(name)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    default public Button<?> getButton(ItemStack item) {
        for (Button button : this.getButtons()) {
            void var3_3;
            Object currentItem = button.getCurrentItem();
            if (currentItem == null || !currentItem.getItemStack().isSimilar(item)) continue;
            return var3_3;
        }
        return null;
    }

    default public ButtonAction getButtonAction(Button<?> button, ClickType type) {
        for (InventoryAction action : this.getActions()) {
            ButtonAction buttonAction;
            if (!(action instanceof ButtonAction) || !(buttonAction = (ButtonAction)action).getButton().equals(button) || buttonAction.getClickType() != type) continue;
            return buttonAction;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    default public SlotAction getSlotAction(int slot, ClickType type) {
        void var3_3;
        InventoryAction result = null;
        for (InventoryAction action : this.getActions()) {
            SlotAction slotAction;
            if (!(action instanceof SlotAction) || slot != (slotAction = (SlotAction)action).getSlot() || action.getClickType() != type || result != null && result.getPriority() >= slotAction.getPriority()) continue;
            result = slotAction;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    default public List<InventoryAction> getSlotActions(int slot, ClickType type) {
        void var2_2;
        void var1_1;
        return this.getActions().stream().sorted(Comparator.comparing(InventoryAction::getPriority)).filter(arg_0 -> InteractiveInventory.a((int)var1_1, (ClickType)var2_2, arg_0)).collect(Collectors.toList());
    }

    default public ItemAction getItemAction(ItemStack stack, ClickType type) {
        for (InventoryAction action : this.getActions()) {
            ItemAction itemAction;
            if (!(action instanceof ItemAction) || !(itemAction = (ItemAction)action).getStack().isSimilar(stack) || action.getClickType() != type) continue;
            return itemAction;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    default public OutSideAction getOutSideAction(ClickType clickType) {
        for (InventoryAction action : this.getActions()) {
            void var3_3;
            OutSideAction outSideAction;
            if (!(action instanceof OutSideAction) || !(outSideAction = (OutSideAction)action).getClickType().equals((Object)clickType)) continue;
            return var3_3;
        }
        return null;
    }

    default public void closeForViewers() {
        if (this.getBukkitInventory() == null) {
            return;
        }
        List viewers = this.getBukkitInventory().getViewers();
        for (int i = 0; i < viewers.size(); ++i) {
            ((HumanEntity)viewers.get(i)).closeInventory();
        }
    }

    public void handleInventoryInteraction(InventoryClickEvent var1);

    default public void handleInventoryDragging(InventoryDragEvent event) {
    }

    public Inventory getBukkitInventory();

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean a(int slot, ClickType type, InventoryAction action) {
        if (action instanceof SlotAction) {
            void var1_1;
            void var2_2;
            int n;
            SlotAction slotAction = (SlotAction)action;
            return slotAction.getSlot() == n && var2_2.getClickType() == var1_1;
        }
        return false;
    }
}

