/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.ItemPlaceHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.Button;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.inventory.items.ButtonItem;

public class BaseButtonItem<T extends Button<? extends ButtonItem>>
implements ButtonItem {
    protected final T button;
    protected final String name;
    protected final ItemStack itemStack;
    protected final Set<ItemPlaceHolder> placeholders;
    protected final ItemMeta originalMeta;
    private Optional<String> a;
    private List<String> b;
    protected boolean initiallyRefreshed;

    public BaseButtonItem(T t, String string, ItemStack itemStack) {
        this.button = t;
        this.name = string;
        this.itemStack = itemStack;
        this.placeholders = new HashSet<ItemPlaceHolder>();
        this.originalMeta = itemStack.getItemMeta().clone();
        this.initiallyRefreshed = false;
    }

    @Override
    public void addPlaceholder(ItemPlaceHolder itemPlaceHolder) {
        this.placeholders.add(itemPlaceHolder);
    }

    protected void updateName(ItemMeta itemMeta) {
        String string = this.getOriginalMetaName();
        if (string == null) {
            return;
        }
        if ((string = string).isEmpty()) {
            return;
        }
        for (ItemPlaceHolder itemPlaceHolder : this.placeholders) {
            String string2 = itemPlaceHolder.getSequence();
            String string3 = itemPlaceHolder.getReplacement();
            if (!itemPlaceHolder.isApplicableForName() || string3 == null || !string.contains(string2)) continue;
            string = string.replaceAll(string2, ChatColor.translateAlternateColorCodes((char)'&', (String)string3));
        }
        itemMeta.setDisplayName(string);
    }

    protected void updateLore(ItemMeta itemMeta) {
        List<String> list = this.getOriginalMetaLore();
        if (list == null) {
            return;
        }
        if ((list = new ArrayList<String>(list)).isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            for (ItemPlaceHolder itemPlaceHolder : this.placeholders) {
                String string2 = itemPlaceHolder.getSequence();
                String string3 = itemPlaceHolder.getReplacement();
                if (!itemPlaceHolder.isApplicableForLore() || !string.contains(string2)) continue;
                if (string3 == null) {
                    list.remove(i);
                    --i;
                    continue;
                }
                String[] stringArray = string3.split("\n");
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j != 0) {
                        list.add(++i, ChatColor.translateAlternateColorCodes((char)'&', (String)stringArray[j]));
                        continue;
                    }
                    list.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)string.replaceAll(string2, stringArray[j])));
                }
            }
        }
        itemMeta.setLore(list);
    }

    protected String getOriginalMetaName() {
        if (this.a == null) {
            this.a = Optional.ofNullable(this.originalMeta.getDisplayName());
        }
        return this.a.orElse(null);
    }

    protected List<String> getOriginalMetaLore() {
        if (this.b == null) {
            this.b = this.originalMeta.getLore();
        }
        return this.b;
    }

    public T getButton() {
        return this.button;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public Set<ItemPlaceHolder> getPlaceholders() {
        return this.placeholders;
    }
}

