/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.Arrays;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.BlobOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;

public class MariaDbBlob
implements Serializable,
Blob {
    private static final long a = -4736603161284649490L;
    protected byte[] data;
    protected transient int offset;
    protected transient int length;

    public MariaDbBlob() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public MariaDbBlob(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("byte array is null");
        }
        this.data = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public MariaDbBlob(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("byte array is null");
        }
        this.data = byArray;
        this.offset = n;
        this.length = Math.min(byArray.length - n, n2);
    }

    private void a(ObjectOutputStream objectOutputStream) {
        if (this.offset != 0 || this.data.length != this.length) {
            this.data = Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
            this.offset = 0;
            this.length = 0;
        }
        objectOutputStream.defaultWriteObject();
    }

    private void a(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.offset = 0;
        this.length = this.data.length;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes(long l, int n) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", l));
        }
        int n2 = this.offset + (int)(l - 1L);
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, n2, byArray, 0, Math.min(this.length - (int)(l - 1L), n));
        return byArray;
    }

    @Override
    public InputStream getBinaryStream() {
        return this.getBinaryStream(1L, this.length);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position should be > 0)");
        }
        if (l - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position > stream size)");
        }
        if (l + l2 - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position + length - 1 > streamSize)");
        }
        return new ByteArrayInputStream(this.data, this.offset + (int)l - 1, (int)l2);
    }

    @Override
    public long position(byte[] byArray, long l) {
        if (byArray.length == 0) {
            return 0L;
        }
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", l));
        }
        if (l > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (start > stream size)");
        }
        block0: for (int i = (int)((long)this.offset + l - 1L); i <= this.offset + this.length - byArray.length; ++i) {
            for (int j = 0; j < byArray.length; ++j) {
                if (this.data[i + j] != byArray[j]) continue block0;
            }
            return i + 1 - this.offset;
        }
        return -1L;
    }

    @Override
    public long position(Blob object, long l) {
        object = object.getBytes(1L, (int)object.length());
        return this.position((byte[])object, l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        int n = (int)l - 1;
        if (this.length > n + byArray.length) {
            System.arraycopy(byArray, 0, this.data, this.offset + n, byArray.length);
        } else {
            byte[] byArray2 = new byte[n + byArray.length];
            if (Math.min(n, this.length) > 0) {
                System.arraycopy(this.data, this.offset, byArray2, 0, Math.min(n, this.length));
            }
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
            this.data = byArray2;
            this.length = n + byArray.length;
            this.offset = 0;
        }
        return byArray.length;
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        int n3 = (int)l - 1;
        int n4 = Math.min(byArray.length - n, n2);
        if (this.length > n3 + n4) {
            System.arraycopy(byArray, n, this.data, this.offset + n3, n4);
        } else {
            byte[] byArray2 = new byte[n3 + n4];
            if (Math.min(n3, this.length) > 0) {
                System.arraycopy(this.data, this.offset, byArray2, 0, Math.min(n3, this.length));
            }
            System.arraycopy(byArray, n, byArray2, n3, n4);
            this.data = byArray2;
            this.length = n3 + n4;
            this.offset = 0;
        }
        return n4;
    }

    @Override
    public OutputStream setBinaryStream(long l) {
        if (l < 1L) {
            throw ExceptionFactory.INSTANCE.create("Invalid position in blob");
        }
        if (this.offset > 0) {
            byte[] byArray = new byte[this.length];
            System.arraycopy(this.data, this.offset, byArray, 0, this.length);
            this.data = byArray;
            this.offset = 0;
        }
        return new BlobOutputStream(this, (int)(l - 1L) + this.offset);
    }

    @Override
    public void truncate(long l) {
        if (l >= 0L && l < (long)this.length) {
            this.length = (int)l;
        }
    }

    @Override
    public void free() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }
}

