/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.net.SocketException;
import java.security.Permission;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLPermission;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.ClientSidePreparedStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbBlob;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbClob;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbDatabaseMetaData;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbFunctionStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbPooledConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbProcedureStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbSavepoint;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.ServerSidePreparedStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.CallableStatementCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.CallableStatementCacheKey;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.CloneableCallableStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.Pools;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class MariaDbConnection
implements Connection {
    private static final Logger a = LoggerFactory.getLogger(MariaDbConnection.class);
    private static final Pattern b = Pattern.compile("^(\\s*\\{)?\\s*((\\?\\s*=)?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*call(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*((((`[^`]+`)|([^`\\}]+))\\.)?((`[^`]+`)|([^`\\}\\(]+)))\\s*(\\(.*\\))?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(#.*)?)\\s*(\\}\\s*)?$", 34);
    private static final Pattern c = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);
    public final ReentrantLock lock;
    private final Protocol d;
    private final Options e;
    public MariaDbPooledConnection pooledConnection;
    protected boolean nullCatalogMeansCurrent;
    private CallableStatementCache f;
    private volatile int g = -1;
    private boolean h;
    private boolean i;
    private int j = 0;
    private int k = 0;
    private ExceptionFactory l;
    private boolean m;

    public MariaDbConnection(Protocol protocol) {
        this.d = protocol;
        this.e = protocol.getOptions();
        this.h = protocol.versionGreaterOrEqual(10, 1, 2);
        this.i = protocol.sessionStateAware();
        this.nullCatalogMeansCurrent = this.e.nullCatalogMeansCurrent;
        if (this.e.cacheCallableStmts) {
            this.f = CallableStatementCache.newInstance(this.e.callableStmtCacheSize);
        }
        this.lock = protocol.getLock();
        this.l = ExceptionFactory.of(this.getServerThreadId(), this.e);
    }

    public static MariaDbConnection newConnection(UrlParser object, GlobalStateInfo globalStateInfo) {
        if (((UrlParser)object).getOptions().pool) {
            return Pools.retrievePool((UrlParser)object).getConnection();
        }
        object = Utils.retrieveProxy((UrlParser)object, globalStateInfo);
        return new MariaDbConnection((Protocol)object);
    }

    public static String quoteIdentifier(String string) {
        return "`" + string.replaceAll("`", "``") + "`";
    }

    @Deprecated
    public static String unquoteIdentifier(String string) {
        if (string != null && string.startsWith("`") && string.endsWith("`") && string.length() >= 2) {
            return string.substring(1, string.length() - 1).replace("``", "`");
        }
        return string;
    }

    protected Protocol getProtocol() {
        return this.d;
    }

    @Override
    public Statement createStatement() {
        this.a();
        return new MariaDbStatement(this, 1003, 1007, this.l);
    }

    @Override
    public Statement createStatement(int n, int n2) {
        return new MariaDbStatement(this, n, n2, this.l);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) {
        return new MariaDbStatement(this, n, n2, this.l);
    }

    private void a() {
        if (this.d.isExplicitClosed()) {
            throw this.l.create("createStatement() is called on closed connection", "08000");
        }
        if (this.d.isClosed() && this.d.getProxy() != null) {
            this.lock.lock();
            try {
                this.d.getProxy().reconnect();
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public ClientSidePreparedStatement clientPrepareStatement(String string) {
        return new ClientSidePreparedStatement(this, string, 1003, 1007, 1, this.l);
    }

    public ServerSidePreparedStatement serverPrepareStatement(String string) {
        return new ServerSidePreparedStatement(this, string, 1003, 1007, 1, this.l);
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        return this.a(string, 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) {
        return this.a(string, n, n2, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) {
        return this.a(string, n, n2, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) {
        return this.a(string, 1003, 1007, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        return this.prepareStatement(string, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        return this.prepareStatement(string, 1);
    }

    private PreparedStatement a(String object, int n, int n2, int n3) {
        if (object != null) {
            object = Utils.nativeSql((String)object, this.d);
            if (this.e.useServerPrepStmts && c.matcher((CharSequence)object).find()) {
                this.a();
                try {
                    return new ServerSidePreparedStatement(this, (String)object, n, n2, n3, this.l);
                }
                catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
                    object = sQLNonTransientConnectionException;
                    throw sQLNonTransientConnectionException;
                }
                catch (SQLException sQLException) {}
            }
            return new ClientSidePreparedStatement(this, (String)object, n, n2, n3, this.l);
        }
        throw new SQLException("SQL value can not be NULL");
    }

    @Override
    public CallableStatement prepareCall(String string) {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) {
        this.a();
        Object object = b.matcher(string);
        if (!((Matcher)object).matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax. must be like {[?=]call <procedure/function name>[(?,?, ...)]}\n but was : " + string);
        }
        string = Utils.nativeSql(((Matcher)object).group(2), this.d);
        boolean bl = ((Matcher)object).group(3) != null;
        String string2 = ((Matcher)object).group(8);
        String string3 = ((Matcher)object).group(10);
        String string4 = ((Matcher)object).group(13);
        object = ((Matcher)object).group(16);
        if (string3 == null && this.i) {
            string3 = this.d.getDatabase();
        }
        if (string3 != null && this.e.cacheCallableStmts) {
            Object object2;
            if (this.f.containsKey(new CallableStatementCacheKey(string3, string))) {
                try {
                    object2 = (CallableStatement)this.f.get(new CallableStatementCacheKey(string3, string));
                    if (object2 != null) {
                        return ((CloneableCallableStatement)object2).clone(this);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    object2 = cloneNotSupportedException;
                    cloneNotSupportedException.printStackTrace();
                }
            }
            object2 = this.a(string, string4, bl, string2, string3, (String)object, n, n2, this.l);
            this.f.put(new CallableStatementCacheKey(string3, string), object2);
            return object2;
        }
        return this.a(string, string4, bl, string2, string3, (String)object, n, n2, this.l);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) {
        return this.prepareCall(string);
    }

    private CallableStatement a(String string, String string2, boolean bl, String string3, String string4, String string5, int n, int n2, ExceptionFactory exceptionFactory) {
        if (bl) {
            return new MariaDbFunctionStatement(this, string4, string3, string5 == null ? "()" : string5, n, n2, exceptionFactory);
        }
        return new MariaDbProcedureStatement(string, this, string2, string4, n, n2, exceptionFactory);
    }

    @Override
    public String nativeSQL(String string) {
        return Utils.nativeSql(string, this.d);
    }

    @Override
    public boolean getAutoCommit() {
        return this.d.getAutocommit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setAutoCommit(boolean bl) {
        Statement statement;
        block10: {
            if (bl == this.getAutoCommit()) {
                return;
            }
            statement = this.createStatement();
            Throwable throwable = null;
            try {
                this.j |= 8;
                statement.executeUpdate("set autocommit=" + (bl ? "1" : "0"));
                if (statement == null) return;
                if (throwable == null) break block10;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (statement == null) throw throwable5;
                    if (throwable == null) {
                        statement.close();
                        throw throwable5;
                    }
                    try {
                        statement.close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                statement.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        statement.close();
    }

    @Override
    public void commit() {
        this.lock.lock();
        try {
            if (this.d.inTransaction()) {
                Throwable throwable = null;
                try (Statement statement = this.createStatement();){
                    statement.execute("COMMIT");
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void rollback() {
        this.lock.lock();
        try {
            if (this.d.inTransaction()) {
                Throwable throwable = null;
                try (Statement statement = this.createStatement();){
                    statement.execute("ROLLBACK");
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback(Savepoint object) {
        Statement statement;
        block9: {
            statement = this.createStatement();
            Throwable throwable = null;
            try {
                statement.execute("ROLLBACK TO SAVEPOINT `" + object.getSavepointName() + "`");
                if (statement == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable4) {
                    if (statement == null) throw throwable4;
                    if (throwable == null) {
                        statement.close();
                        throw throwable4;
                    }
                    try {
                        statement.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                statement.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        statement.close();
    }

    @Override
    public void close() {
        if (this.pooledConnection != null) {
            this.rollback();
            this.pooledConnection.fireConnectionClosed();
            return;
        }
        this.d.closeExplicit();
    }

    @Override
    public boolean isClosed() {
        return this.d.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        MariaDbConnection mariaDbConnection = this;
        return new MariaDbDatabaseMetaData(mariaDbConnection, mariaDbConnection.d.getUrlParser());
    }

    @Override
    public boolean isReadOnly() {
        return this.d.getReadonly();
    }

    @Override
    public void setReadOnly(boolean bl) {
        try {
            a.debug("conn={}({}) - set read-only to value {} {}", this.d.getServerThreadId(), this.d.isMasterConnection() ? "M" : "S", bl);
            this.j |= 4;
            this.d.setReadonly(bl);
            return;
        }
        catch (SQLException sQLException) {
            throw this.l.create(sQLException);
        }
    }

    @Override
    public String getCatalog() {
        return this.d.getCatalog();
    }

    @Override
    public void setCatalog(String string) {
        if (string == null) {
            throw new SQLException("The catalog name may not be null", "XAE05");
        }
        try {
            this.j |= 2;
            this.d.setCatalog(string);
            return;
        }
        catch (SQLException sQLException) {
            throw this.l.create(sQLException);
        }
    }

    public boolean isServerMariaDb() {
        return this.d.isServerMariaDb();
    }

    public boolean versionGreaterOrEqual(int n, int n2, int n3) {
        return this.d.versionGreaterOrEqual(n, n2, n3);
    }

    @Override
    public int getTransactionIsolation() {
        Object object = this.createStatement();
        String string = "SELECT @@tx_isolation";
        if (!this.d.isServerMariaDb() && (this.d.getMajorServerVersion() >= 8 && this.d.versionGreaterOrEqual(8, 0, 3) || this.d.getMajorServerVersion() < 8 && this.d.versionGreaterOrEqual(5, 7, 20))) {
            string = "SELECT @@transaction_isolation";
        }
        if ((object = object.executeQuery(string)).next()) {
            object = object.getString(1);
            switch (object) {
                case "REPEATABLE-READ": {
                    return 4;
                }
                case "READ-UNCOMMITTED": {
                    return 1;
                }
                case "READ-COMMITTED": {
                    return 2;
                }
                case "SERIALIZABLE": {
                    return 8;
                }
            }
            throw this.l.create(String.format("Could not get transaction isolation level: Invalid value \"%s\"", object));
        }
        throw this.l.create("Failed to retrieve transaction isolation");
    }

    @Override
    public void setTransactionIsolation(int n) {
        try {
            this.j |= 0x10;
            this.d.setTransactionIsolation(n);
            return;
        }
        catch (SQLException sQLException) {
            throw this.l.create(sQLException);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        if (this.m || this.isClosed() || !this.d.hasWarnings()) {
            return null;
        }
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            Throwable throwable2 = null;
            try (ResultSet resultSet = statement.executeQuery("show warnings");){
                while (resultSet.next()) {
                    int n = resultSet.getInt(2);
                    String string = resultSet.getString(3);
                    SQLWarning sQLWarning3 = new SQLWarning(string, null, n);
                    if (sQLWarning2 == null) {
                        sQLWarning2 = sQLWarning3;
                        sQLWarning = sQLWarning3;
                        continue;
                    }
                    sQLWarning.setNextWarning(sQLWarning3);
                    sQLWarning = sQLWarning3;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throwable2 = throwable3;
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throwable = throwable5;
            throw throwable6;
        }
        return sQLWarning2;
    }

    @Override
    public void clearWarnings() {
        if (this.isClosed()) {
            throw this.l.create("Connection.clearWarnings cannot be called on a closed connection");
        }
        this.m = true;
    }

    public void reenableWarnings() {
        this.m = false;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        throw this.l.notSupported("TypeMap are not supported");
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public void setHoldability(int n) {
    }

    @Override
    public Savepoint setSavepoint() {
        String string = UUID.randomUUID().toString();
        return this.setSavepoint(string);
    }

    @Override
    public Savepoint setSavepoint(String object) {
        object = new MariaDbSavepoint((String)object);
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            statement.execute("SAVEPOINT `" + object.getSavepointName() + "`");
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void releaseSavepoint(Savepoint object) {
        Statement statement;
        block9: {
            statement = this.createStatement();
            Throwable throwable = null;
            try {
                statement.execute("RELEASE SAVEPOINT `" + object.getSavepointName() + "`");
                if (statement == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable4) {
                    if (statement == null) throw throwable4;
                    if (throwable == null) {
                        statement.close();
                        throw throwable4;
                    }
                    try {
                        statement.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                statement.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        statement.close();
    }

    @Override
    public Clob createClob() {
        return new MariaDbClob();
    }

    @Override
    public Blob createBlob() {
        return new MariaDbBlob();
    }

    @Override
    public NClob createNClob() {
        return new MariaDbClob();
    }

    @Override
    public SQLXML createSQLXML() {
        throw this.l.notSupported("SQLXML type is not supported");
    }

    @Override
    public boolean isValid(int n) {
        if (n < 0) {
            throw new SQLException("the value supplied for timeout is negative");
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.d.isValid(n * 1000);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private void a(String string) {
        if (this.d.isExplicitClosed()) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("setClientInfo() is called on closed connection", hashMap);
        }
    }

    private void b(String string) {
        if (this.d.isClosed() && this.d.getProxy() != null) {
            this.lock.lock();
            try {
                this.d.getProxy().reconnect();
                return;
            }
            catch (SQLException sQLException) {
                HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
                hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException("Connection closed", hashMap, (Throwable)sQLException);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static void c(String string) {
        if (string == null || !"ApplicationName".equals(string) && !"ClientUser".equals(string) && !"ClientHostname".equals(string)) {
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException("setClientInfo() parameters can only be \"ApplicationName\",\"ClientUser\" or \"ClientHostname\", but was : " + string, hashMap);
        }
    }

    private String a(String charSequence, String string) {
        charSequence = new StringBuilder("SET @").append((String)charSequence).append("=");
        if (string == null) {
            ((StringBuilder)charSequence).append("null");
        } else {
            int n;
            ((StringBuilder)charSequence).append("'");
            int n2 = string.length();
            if (this.d.noBackslashEscapes()) {
                for (n = 0; n < n2; ++n) {
                    char c = string.charAt(n);
                    if (c == '\'') {
                        ((StringBuilder)charSequence).append('\'');
                    }
                    ((StringBuilder)charSequence).append(c);
                }
            } else {
                while (n < n2) {
                    char c = string.charAt(n);
                    if (c == '\'' || c == '\\' || c == '\"' || c == '\u0000') {
                        ((StringBuilder)charSequence).append('\\');
                    }
                    ((StringBuilder)charSequence).append(c);
                    ++n;
                }
            }
            ((StringBuilder)charSequence).append("'");
        }
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public void setClientInfo(String hashMap, String hashMap2) {
        String string = hashMap;
        Object object = this;
        if (((MariaDbConnection)object).d.isExplicitClosed()) {
            hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("setClientInfo() is called on closed connection", (Map<String, ClientInfoStatus>)hashMap);
        }
        string = hashMap;
        object = this;
        if (((MariaDbConnection)object).d.isClosed() && ((MariaDbConnection)object).d.getProxy() != null) {
            ((MariaDbConnection)object).lock.lock();
            try {
                ((MariaDbConnection)object).d.getProxy().reconnect();
            }
            catch (SQLException sQLException) {
                hashMap2 = new HashMap<String, ClientInfoStatus>();
                hashMap2.put(string, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException("Connection closed", hashMap2, (Throwable)sQLException);
            }
            finally {
                ((MariaDbConnection)object).lock.unlock();
            }
        }
        if ((object = hashMap) == null || !"ApplicationName".equals(object) && !"ClientUser".equals(object) && !"ClientHostname".equals(object)) {
            hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put((String)object, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException("setClientInfo() parameters can only be \"ApplicationName\",\"ClientUser\" or \"ClientHostname\", but was : " + (String)object, hashMap);
        }
        try {
            object = this.createStatement();
            object.execute(this.a((String)((Object)hashMap), (String)((Object)hashMap2)));
            return;
        }
        catch (SQLException sQLException) {
            hashMap2 = new HashMap<String, ClientInfoStatus>();
            hashMap2.put((String)((Object)hashMap), ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("unexpected error during setClientInfo", hashMap2, (Throwable)sQLException);
        }
    }

    @Override
    public Properties getClientInfo() {
        Object object;
        this.a();
        Properties properties = new Properties();
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            object = statement.executeQuery("SELECT @ApplicationName, @ClientUser, @ClientHostname");
            Throwable throwable2 = null;
            try {
                if (object.next()) {
                    if (object.getString(1) != null) {
                        properties.setProperty("ApplicationName", object.getString(1));
                    }
                    if (object.getString(2) != null) {
                        properties.setProperty("ClientUser", object.getString(2));
                    }
                    if (object.getString(3) != null) {
                        properties.setProperty("ClientHostname", object.getString(3));
                    }
                    Properties properties2 = properties;
                    return properties2;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throwable2 = throwable3;
                throw throwable4;
            }
            finally {
                if (object != null) {
                    if (throwable2 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            object = throwable6;
            throwable = throwable6;
            throw object;
        }
        properties.setProperty("ApplicationName", null);
        properties.setProperty("ClientUser", null);
        properties.setProperty("ClientHostname", null);
        return properties;
    }

    @Override
    public void setClientInfo(Properties properties) {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        Object object = new String[]{"ApplicationName", "ClientUser", "ClientHostname"};
        for (int i = 0; i < 3; ++i) {
            String string = object[i];
            try {
                this.setClientInfo(string, properties.getProperty(string));
                continue;
            }
            catch (SQLClientInfoException sQLClientInfoException) {
                hashMap.putAll(sQLClientInfoException.getFailedProperties());
            }
        }
        if (!hashMap.isEmpty()) {
            object = "setClientInfo errors : the following properties where not set : " + hashMap.keySet();
            throw new SQLClientInfoException((String)object, hashMap);
        }
    }

    @Override
    public String getClientInfo(String object) {
        this.a();
        if (!("ApplicationName".equals(object) || "ClientUser".equals(object) || "ClientHostname".equals(object))) {
            throw new SQLException("name must be \"ApplicationName\", \"ClientUser\" or \"ClientHostname\", but was \"" + (String)object + "\"");
        }
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            object = statement.executeQuery("SELECT @" + (String)object);
            Throwable throwable2 = null;
            try {
                if (object.next()) {
                    String string = object.getString(1);
                    return string;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throwable2 = throwable3;
                throw throwable4;
            }
            finally {
                if (object != null) {
                    if (throwable2 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            object = throwable6;
            throwable = throwable6;
            throw object;
        }
        return null;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) {
        throw this.l.notSupported("Array type is not supported");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        throw this.l.notSupported("Struct type is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        try {
            if (this.isWrapperFor(clazz)) {
                return clazz.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + clazz.getName());
        }
        catch (Exception exception) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Deprecated
    public String getUsername() {
        return this.d.getUsername();
    }

    @Deprecated
    public String getHostname() {
        return this.d.getHost();
    }

    @Deprecated
    public int getPort() {
        return this.d.getPort();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return this.d.getPinGlobalTxToPhysicalConnection();
    }

    public void setHostFailed() {
        if (this.d.getProxy() == null) {
            this.d.setHostFailedWithoutProxy();
        }
    }

    public int getLowercaseTableNames() {
        if (this.g == -1) {
            Throwable throwable = null;
            try (Statement statement = this.createStatement();){
                Throwable throwable2 = null;
                try (ResultSet resultSet = statement.executeQuery("select @@lower_case_table_names");){
                    resultSet.next();
                    this.g = resultSet.getInt(1);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throwable = throwable5;
                throw throwable6;
            }
        }
        return this.g;
    }

    @Override
    public void abort(Executor executor) {
        if (this.isClosed()) {
            return;
        }
        SQLPermission sQLPermission = new SQLPermission("callAbort");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sQLPermission);
        }
        if (executor == null) {
            throw this.l.create("Cannot abort the connection: null executor passed");
        }
        executor.execute(this.d::abort);
    }

    @Override
    public int getNetworkTimeout() {
        return this.d.getTimeout();
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public void setSchema(String string) {
    }

    @Override
    public void setNetworkTimeout(Executor object, int n) {
        if (this.isClosed()) {
            throw this.l.create("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (n < 0) {
            throw this.l.create("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        object = new SQLPermission("setNetworkTimeout");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)object);
        }
        try {
            this.j |= 1;
            this.d.setTimeout(n);
            return;
        }
        catch (SocketException socketException) {
            throw this.l.create("Cannot set the network timeout", socketException);
        }
    }

    public long getServerThreadId() {
        return this.d.getServerThreadId();
    }

    public boolean canUseServerTimeout() {
        return this.h;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.k = n;
    }

    public void reset() {
        boolean bl = this.e.useResetConnection && this.d.isServerMariaDb() && (this.d.versionGreaterOrEqual(10, 3, 13) || this.d.getMajorServerVersion() == 10 && this.d.getMinorServerVersion() == 2 && this.d.versionGreaterOrEqual(10, 2, 22));
        if (bl) {
            this.d.reset();
        }
        if (this.j != 0) {
            try {
                if ((this.j & 1) != 0) {
                    this.setNetworkTimeout(null, this.e.socketTimeout);
                }
                if ((this.j & 8) != 0) {
                    MariaDbConnection mariaDbConnection = this;
                    mariaDbConnection.setAutoCommit(mariaDbConnection.e.autocommit);
                }
                if ((this.j & 2) != 0) {
                    this.d.resetDatabase();
                }
                if ((this.j & 4) != 0) {
                    this.setReadOnly(false);
                }
                if (!bl && (this.j & 0x10) != 0) {
                    MariaDbConnection mariaDbConnection = this;
                    mariaDbConnection.setTransactionIsolation(mariaDbConnection.k);
                }
                this.j = 0;
            }
            catch (SQLException sQLException) {
                throw this.l.create("error resetting connection");
            }
        }
        this.m = true;
    }

    public boolean includeDeadLockInfo() {
        return this.e.includeInnodbStatusInDeadlockExceptions;
    }

    public boolean includeThreadsTraces() {
        return this.e.includeThreadDumpInDeadlockExceptions;
    }
}

