/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.CredentialPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.CredentialPluginLoader;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.DefaultOptions;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class UrlParser
implements Cloneable {
    private static final String a = "disableMariaDbDriver";
    private static final Pattern b = Pattern.compile("(\\/([^\\?]*))?(\\?(.+))*", 32);
    private static final Pattern c = Pattern.compile("(.+)\\.([a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private String d;
    private Options e = null;
    private List<HostAddress> f;
    private HaMode g;
    private String h;
    private boolean i;
    private CredentialPlugin j;

    private UrlParser() {
    }

    public UrlParser(String iterator, List<HostAddress> object, Options options, HaMode haMode) {
        this.e = options;
        this.d = iterator;
        this.f = object;
        this.g = haMode;
        if (haMode == HaMode.AURORA) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                iterator.next().type = null;
            }
        } else {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((HostAddress)object).type != null) continue;
                ((HostAddress)object).type = "master";
            }
        }
        this.j = CredentialPluginLoader.get(options.credentialType);
        DefaultOptions.postOptionProcess(options, this.j);
        this.a();
        this.b();
    }

    public static boolean acceptsUrl(String string) {
        return string != null && (string.startsWith("jdbc:mariadb:") || string.startsWith("jdbc:mysql:") && !string.contains(a));
    }

    public static UrlParser parse(String string) {
        return UrlParser.parse(string, new Properties());
    }

    public static UrlParser parse(String string, Properties properties) {
        if (string != null && (string.startsWith("jdbc:mariadb:") || string.startsWith("jdbc:mysql:") && !string.contains(a))) {
            UrlParser urlParser = new UrlParser();
            UrlParser.a(urlParser, string, properties == null ? new Properties() : properties);
            return urlParser;
        }
        return null;
    }

    private static void a(UrlParser urlParser, String string, Properties properties) {
        try {
            String string2;
            int n;
            urlParser.h = string;
            int n2 = string.indexOf("//");
            if (n2 == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + string);
            }
            urlParser.g = UrlParser.a(string, n2);
            if ((n2 = (string = string.substring(n2 + 2)).indexOf("/")) < (n = string.indexOf("?")) && n2 < 0 || n2 > n && n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n);
            } else if (n2 < n && n2 >= 0 || n2 > n && n < 0) {
                string2 = string.substring(0, n2);
                string = string.substring(n2);
            } else {
                string2 = string;
                string = null;
            }
            UrlParser.a(urlParser, properties, string2, string);
            UrlParser.a(urlParser);
            urlParser.b();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("error parsing url : " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    private static void a(UrlParser urlParser, Properties properties, String string, String object) {
        if (object != null) {
            object = b.matcher((CharSequence)object);
            ((Matcher)object).find();
            urlParser.d = ((Matcher)object).group(2);
            urlParser.e = DefaultOptions.parse(urlParser.g, ((Matcher)object).group(4), properties, urlParser.e);
            if (urlParser.d != null && urlParser.d.isEmpty()) {
                urlParser.d = null;
            }
        } else {
            urlParser.d = null;
            urlParser.e = DefaultOptions.parse(urlParser.g, "", properties, urlParser.e);
        }
        urlParser.j = CredentialPluginLoader.get(urlParser.e.credentialType);
        DefaultOptions.postOptionProcess(urlParser.e, urlParser.j);
        LoggerFactory.init(urlParser.e.log || urlParser.e.profileSql || urlParser.e.slowQueryThresholdNanos != null);
        urlParser.f = HostAddress.parse(string, urlParser.g);
    }

    private static HaMode a(String string, int n) {
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(58, (n2 = string.indexOf(58, n2 + 1)) + 1);
        if (n3 > n || n3 == -1) {
            if (n2 == n - 1) {
                return HaMode.NONE;
            }
            n3 = n;
        }
        try {
            String string2 = string.substring(n2 + 1, n3).toUpperCase(Locale.ROOT);
            if ("FAILOVER".equals(string2)) {
                string2 = "LOADBALANCE";
            }
            return HaMode.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("wrong failover parameter format in connection String " + string);
        }
    }

    private static void a(UrlParser iterator) {
        if (((UrlParser)((Object)iterator)).g == HaMode.AURORA) {
            for (HostAddress hostAddress : ((UrlParser)((Object)iterator)).f) {
                iterator.next().type = null;
            }
            return;
        }
        for (HostAddress hostAddress : ((UrlParser)((Object)iterator)).f) {
            if (hostAddress.type != null) continue;
            hostAddress.type = "master";
        }
    }

    private void a() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("jdbc:mariadb:");
        if (this.g != HaMode.NONE) {
            stringBuilder.append(this.g.toString().toLowerCase(Locale.ROOT)).append(":");
        }
        stringBuilder.append("//");
        for (int i = 0; i < this.f.size(); ++i) {
            HostAddress hostAddress = this.f.get(i);
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("address=(host=").append(hostAddress.host).append(")(port=").append(hostAddress.port).append(")");
            if (hostAddress.type == null) continue;
            stringBuilder.append("(type=").append(hostAddress.type).append(")");
        }
        stringBuilder.append("/");
        if (this.d != null) {
            stringBuilder.append(this.d);
        }
        DefaultOptions.propertyString(this.e, this.g, stringBuilder);
        this.h = stringBuilder.toString();
    }

    public UrlParser auroraPipelineQuirks() {
        boolean bl = this.isAurora();
        if (this.e.useBatchMultiSend == null) {
            Boolean bl2 = this.e.useBatchMultiSend = bl ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.e.usePipelineAuth == null) {
            this.e.usePipelineAuth = bl ? Boolean.FALSE : Boolean.TRUE;
        }
        return this;
    }

    public boolean isAurora() {
        if (this.g == HaMode.AURORA) {
            return true;
        }
        if (this.f != null) {
            for (HostAddress hostAddress : this.f) {
                Matcher object = c.matcher(hostAddress.host);
                if (!object.find()) continue;
                return true;
            }
        }
        return false;
    }

    public void parseUrl(String string) {
        if (UrlParser.acceptsUrl(string)) {
            UrlParser.a(this, string, new Properties());
        }
    }

    public String getUsername() {
        return this.e.user;
    }

    public void setUsername(String string) {
        this.e.user = string;
    }

    public String getPassword() {
        return this.e.password;
    }

    public void setPassword(String string) {
        this.e.password = string;
    }

    public String getDatabase() {
        return this.d;
    }

    public void setDatabase(String string) {
        this.d = string;
    }

    public List<HostAddress> getHostAddresses() {
        return this.f;
    }

    public Options getOptions() {
        return this.e;
    }

    protected void setProperties(String string) {
        DefaultOptions.parse(this.g, string, this.e);
        this.a();
    }

    public CredentialPlugin getCredentialPlugin() {
        return this.j;
    }

    public String toString() {
        return this.h;
    }

    public String getInitialUrl() {
        return this.h;
    }

    public HaMode getHaMode() {
        return this.g;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UrlParser)) {
            return false;
        }
        object = (UrlParser)object;
        return (this.h != null ? this.h.equals(((UrlParser)object).getInitialUrl()) : ((UrlParser)object).getInitialUrl() == null) && (this.getUsername() != null ? this.getUsername().equals(((UrlParser)object).getUsername()) : ((UrlParser)object).getUsername() == null) && (this.getPassword() != null ? this.getPassword().equals(((UrlParser)object).getPassword()) : ((UrlParser)object).getPassword() == null);
    }

    public int hashCode() {
        int n = this.e.password != null ? this.e.password.hashCode() : 0;
        n = n * 31 + (this.e.user != null ? this.e.user.hashCode() : 0);
        n = n * 31 + this.h.hashCode();
        return n;
    }

    private void b() {
        if (this.g == HaMode.SEQUENTIAL || this.g == HaMode.REPLICATION || this.g == HaMode.LOADBALANCE) {
            boolean bl = false;
            for (HostAddress hostAddress : this.f) {
                if (!hostAddress.type.equals("master")) continue;
                if (bl) {
                    this.i = true;
                    return;
                }
                bl = true;
            }
        }
        this.i = false;
    }

    public boolean isMultiMaster() {
        return this.i;
    }

    public Object clone() {
        UrlParser urlParser = (UrlParser)super.clone();
        ((UrlParser)super.clone()).e = (Options)this.e.clone();
        urlParser.f = new ArrayList<HostAddress>();
        urlParser.f.addAll(this.f);
        return urlParser;
    }
}

