/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.aws;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.Credential;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.CredentialPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.aws.AwsCredentialGenerator;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class AwsIamCredentialPlugin
implements CredentialPlugin {
    private static final int a = 10;
    private static Map<KeyCache, IdentityExpire> b = new ConcurrentHashMap<KeyCache, IdentityExpire>();
    private AwsCredentialGenerator c;
    private KeyCache d;

    @Override
    public String type() {
        return "AWS-IAM";
    }

    @Override
    public String name() {
        return "AWS IAM Authentication plugin";
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public CredentialPlugin initialize(Options options, String string, HostAddress hostAddress) {
        try {
            Class.forName("com.amazonaws.auth.BasicAWSCredentials");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Identity plugin 'AWS-IAM' is used without having AWS SDK in classpath. Please add 'com.amazonaws:aws-java-sdk-rds' to classpath");
        }
        this.c = new AwsCredentialGenerator(options.nonMappedOptions, string, hostAddress);
        this.d = new KeyCache(options, string, hostAddress);
        return this;
    }

    @Override
    public Credential get() {
        Object object = b.get(this.d);
        if (object != null && ((IdentityExpire)object).isValid()) {
            return ((IdentityExpire)object).getCredential();
        }
        object = this.c.getToken();
        b.put(this.d, new IdentityExpire((Credential)object));
        return object;
    }

    private class KeyCache {
        private Options a;
        private String b;
        private HostAddress c;

        public KeyCache(Options options, String string, HostAddress hostAddress) {
            this.a = options;
            this.b = string;
            this.c = hostAddress;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (KeyCache)object;
            return this.a.equals(((KeyCache)object).a) && Objects.equals(this.b, ((KeyCache)object).b) && this.c.equals(((KeyCache)object).c);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.c);
        }
    }

    private class IdentityExpire {
        private LocalDateTime a;
        private Credential b;

        public IdentityExpire(Credential credential) {
            this.b = credential;
            this.a = LocalDateTime.now().plusMinutes(10L);
        }

        public boolean isValid() {
            return this.a.isAfter(LocalDateTime.now());
        }

        public Credential getCredential() {
            return this.b;
        }
    }
}

