/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.ColumnDefinition;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.resultset.rowprotocol.RowProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class BinaryRowProtocol
extends RowProtocol {
    private final ColumnDefinition[] a;
    private final int b;

    public BinaryRowProtocol(ColumnDefinition[] columnDefinitionArray, int n, int n2, Options options) {
        super(n2, options);
        this.a = columnDefinitionArray;
        this.b = n;
    }

    @Override
    public void setPosition(int n) {
        if ((this.buf[1 + (n + 2) / 8] & 1 << (n + 2) % 8) != 0) {
            this.lastValueNull = 1;
            return;
        }
        if (this.index != n) {
            int n2 = this.pos;
            if (this.index == -1 || this.index > n) {
                this.index = 0;
                n2 = 1 + (this.b + 9) / 8;
            } else {
                ++this.index;
                n2 += this.length;
            }
            while (this.index <= n) {
                if ((this.buf[1 + (this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                    int n3;
                    if (this.index != n) {
                        block0 : switch (this.a[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                n2 += 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                n2 += 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                n2 += 2;
                                break;
                            }
                            case TINYINT: {
                                ++n2;
                                break;
                            }
                            default: {
                                n3 = this.buf[n2++] & 0xFF;
                                switch (n3) {
                                    case 251: {
                                        break block0;
                                    }
                                    case 252: {
                                        n2 += 2 + (0xFFFF & (this.buf[n2] & 0xFF) + ((this.buf[n2 + 1] & 0xFF) << 8));
                                        break block0;
                                    }
                                    case 253: {
                                        n2 += 3 + (0xFFFFFF & (this.buf[n2] & 0xFF) + ((this.buf[n2 + 1] & 0xFF) << 8) + ((this.buf[n2 + 2] & 0xFF) << 16));
                                        break block0;
                                    }
                                    case 254: {
                                        n2 = (int)((long)n2 + (8L + ((long)(this.buf[n2] & 0xFF) + ((long)(this.buf[n2 + 1] & 0xFF) << 8) + ((long)(this.buf[n2 + 2] & 0xFF) << 16) + ((long)(this.buf[n2 + 3] & 0xFF) << 24) + ((long)(this.buf[n2 + 4] & 0xFF) << 32) + ((long)(this.buf[n2 + 5] & 0xFF) << 40) + ((long)(this.buf[n2 + 6] & 0xFF) << 48) + ((long)(this.buf[n2 + 7] & 0xFF) << 56))));
                                        break block0;
                                    }
                                }
                                n2 += n3;
                                break;
                            }
                        }
                    } else {
                        switch (this.a[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.pos = n2;
                                this.length = 8;
                                this.lastValueNull = 0;
                                return;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                this.pos = n2;
                                this.length = 4;
                                this.lastValueNull = 0;
                                return;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.pos = n2;
                                this.length = 2;
                                this.lastValueNull = 0;
                                return;
                            }
                            case TINYINT: {
                                this.pos = n2;
                                this.length = 1;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        n3 = this.buf[n2++] & 0xFF;
                        switch (n3) {
                            case 251: {
                                throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
                            }
                            case 252: {
                                this.length = 0xFFFF & (this.buf[n2++] & 0xFF) + ((this.buf[n2++] & 0xFF) << 8);
                                this.pos = n2;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 253: {
                                this.length = 0xFFFFFF & (this.buf[n2++] & 0xFF) + ((this.buf[n2++] & 0xFF) << 8) + ((this.buf[n2++] & 0xFF) << 16);
                                this.pos = n2;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 254: {
                                this.length = (int)((long)(this.buf[n2++] & 0xFF) + ((long)(this.buf[n2++] & 0xFF) << 8) + ((long)(this.buf[n2++] & 0xFF) << 16) + ((long)(this.buf[n2++] & 0xFF) << 24) + ((long)(this.buf[n2++] & 0xFF) << 32) + ((long)(this.buf[n2++] & 0xFF) << 40) + ((long)(this.buf[n2++] & 0xFF) << 48) + ((long)(this.buf[n2++] & 0xFF) << 56));
                                this.pos = n2;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        this.length = n3;
                        this.pos = n2;
                        this.lastValueNull = 0;
                        return;
                    }
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnDefinition object, Calendar comparable, TimeZone timeZone) {
        if ((this.lastValueNull & 1) != 0) {
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case STRING: {
                if (this.getMaxFieldSize() > 0) {
                    return new String(this.buf, this.pos, Math.min(this.getMaxFieldSize() * 3, this.length), StandardCharsets.UTF_8).substring(0, Math.min(this.getMaxFieldSize(), this.length));
                }
                return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            }
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case TINYINT: {
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalTinyInt((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case SMALLINT: {
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalSmallInt((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case INTEGER: 
            case MEDIUMINT: {
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalMediumInt((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case BIGINT: {
                if (!((ColumnDefinition)object).isSigned()) {
                    BinaryRowProtocol binaryRowProtocol = this;
                    return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalBigInteger((ColumnDefinition)object)), (ColumnDefinition)object);
                }
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalLong((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case DOUBLE: {
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalDouble((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case FLOAT: {
                BinaryRowProtocol binaryRowProtocol = this;
                return binaryRowProtocol.zeroFillingIfNeeded(String.valueOf(binaryRowProtocol.getInternalFloat((ColumnDefinition)object)), (ColumnDefinition)object);
            }
            case TIME: {
                return this.getInternalTimeString((ColumnDefinition)object);
            }
            case DATE: {
                object = this.getInternalDate((ColumnDefinition)object, (Calendar)comparable, timeZone);
                if (object == null) {
                    return null;
                }
                return ((Date)object).toString();
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    if ((object = this.getInternalDate((ColumnDefinition)object, (Calendar)comparable, timeZone)) == null) {
                        return null;
                    }
                    return ((Date)object).toString();
                }
                return String.valueOf(this.getInternalSmallInt((ColumnDefinition)object));
            }
            case TIMESTAMP: 
            case DATETIME: {
                object = this.getInternalTimestamp((ColumnDefinition)object, (Calendar)comparable, timeZone);
                if (object == null) {
                    return null;
                }
                return ((Timestamp)object).toString();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                comparable = this.getInternalBigDecimal((ColumnDefinition)object);
                if (comparable == null) {
                    return null;
                }
                return this.zeroFillingIfNeeded(((BigDecimal)comparable).toString(), (ColumnDefinition)object);
            }
            case GEOMETRY: {
                return new String(this.buf, this.pos, this.length);
            }
            case NULL: {
                return null;
            }
        }
        if (this.getMaxFieldSize() > 0) {
            return new String(this.buf, this.pos, Math.min(this.getMaxFieldSize() * 3, this.length), StandardCharsets.UTF_8).substring(0, Math.min(this.getMaxFieldSize(), this.length));
        }
        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public int getInternalInt(ColumnDefinition columnDefinition) {
        long l;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                l = this.parseBit();
                break;
            }
            case TINYINT: {
                l = this.getInternalTinyInt(columnDefinition);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                l = this.getInternalSmallInt(columnDefinition);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                l = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                if (columnDefinition.isSigned()) {
                    return (int)l;
                }
                if (l >= 0L) break;
                l &= 0xFFFFFFFFL;
                break;
            }
            case BIGINT: {
                l = this.getInternalLong(columnDefinition);
                break;
            }
            case FLOAT: {
                l = (long)this.getInternalFloat(columnDefinition);
                break;
            }
            case DOUBLE: {
                l = (long)this.getInternalDouble(columnDefinition);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnDefinition);
                this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, bigDecimal, columnDefinition);
                return bigDecimal.intValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                l = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getInt not available for data field type " + columnDefinition.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, l, columnDefinition);
        return (int)l;
    }

    @Override
    public long getInternalLong(ColumnDefinition columnDefinition) {
        long l;
        if (this.lastValueWasNull()) {
            return 0L;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                l = this.getInternalTinyInt(columnDefinition);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                l = this.getInternalSmallInt(columnDefinition);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                l = this.getInternalMediumInt(columnDefinition);
                break;
            }
            case BIGINT: {
                long l2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnDefinition.isSigned()) {
                    return l2;
                }
                BigInteger bigInteger = new BigInteger(1, new byte[]{(byte)(l2 >> 56), (byte)(l2 >> 48), (byte)(l2 >> 40), (byte)(l2 >> 32), (byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2});
                if (bigInteger.compareTo(new BigInteger("9223372036854775807")) > 0) {
                    throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + bigInteger + " is not in Long range", "22003", 1264);
                }
                return bigInteger.longValue();
            }
            case FLOAT: {
                Float f = Float.valueOf(this.getInternalFloat(columnDefinition));
                if (f.compareTo(Float.valueOf(9.223372E18f)) > 0) {
                    throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + f + " is not in Long range", "22003", 1264);
                }
                return f.longValue();
            }
            case DOUBLE: {
                Double d = this.getInternalDouble(columnDefinition);
                if (d.compareTo(9.223372036854776E18) > 0) {
                    throw new SQLException("Out of range value for column '" + columnDefinition.getName() + "' : value " + d + " is not in Long range", "22003", 1264);
                }
                return d.longValue();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnDefinition);
                this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, bigDecimal, columnDefinition);
                return bigDecimal.longValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                return Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
            }
            default: {
                throw new SQLException("getLong not available for data field type " + columnDefinition.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, l, columnDefinition);
        return l;
    }

    @Override
    public float getInternalFloat(ColumnDefinition object) {
        long l;
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                l = this.getInternalTinyInt((ColumnDefinition)object);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                l = this.getInternalSmallInt((ColumnDefinition)object);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                l = this.getInternalMediumInt((ColumnDefinition)object);
                break;
            }
            case BIGINT: {
                long l2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (((ColumnDefinition)object).isSigned()) {
                    return l2;
                }
                BigInteger bigInteger = new BigInteger(1, new byte[]{(byte)(l2 >> 56), (byte)(l2 >> 48), (byte)(l2 >> 40), (byte)(l2 >> 32), (byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2});
                return bigInteger.floatValue();
            }
            case FLOAT: {
                int n = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return Float.intBitsToFloat(n);
            }
            case DOUBLE: {
                return (float)this.getInternalDouble((ColumnDefinition)object);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8)).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    object = new SQLException("Incorrect format for getFloat for data field with type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName(), "22003", 1264, numberFormatException);
                    throw object;
                }
            }
            default: {
                throw new SQLException("getFloat not available for data field type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName());
            }
        }
        try {
            return Float.valueOf(String.valueOf(l)).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            object = new SQLException("Incorrect format for getFloat for data field with type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName(), "22003", 1264, numberFormatException);
            throw object;
        }
    }

    @Override
    public double getInternalDouble(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                return this.getInternalTinyInt((ColumnDefinition)object);
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt((ColumnDefinition)object);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt((ColumnDefinition)object);
            }
            case BIGINT: {
                long l = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (((ColumnDefinition)object).isSigned()) {
                    return l;
                }
                return new BigInteger(1, new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l}).doubleValue();
            }
            case FLOAT: {
                return this.getInternalFloat((ColumnDefinition)object);
            }
            case DOUBLE: {
                long l = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                return Double.longBitsToDouble(l);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException numberFormatException) {
                    object = new SQLException("Incorrect format for getDouble for data field with type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName(), "22003", 1264);
                    ((Throwable)object).initCause(numberFormatException);
                    throw object;
                }
            }
        }
        throw new SQLException("getDouble not available for data field type " + ((ColumnDefinition)object).getColumnType().getJavaTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                return BigDecimal.valueOf(this.parseBit());
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getInternalTinyInt(columnDefinition));
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getInternalSmallInt(columnDefinition));
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getInternalMediumInt(columnDefinition));
            }
            case BIGINT: {
                long l = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnDefinition.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(l))).setScale(columnDefinition.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l}))).setScale(columnDefinition.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(this.getInternalFloat(columnDefinition));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.getInternalDouble(columnDefinition));
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                return new BigDecimal(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
            }
        }
        throw new SQLException("getBigDecimal not available for data field type " + columnDefinition.getColumnType().getJavaTypeName());
    }

    @Override
    public Date getInternalDate(ColumnDefinition columnDefinition, Calendar object, TimeZone serializable) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        byte by = 1;
        byte by2 = 1;
        switch (columnDefinition.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                int n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                by = this.buf[this.pos + 2];
                by2 = this.buf[this.pos + 3];
                byte by3 = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.length > 4) {
                    by3 = this.buf[this.pos + 4];
                    n2 = this.buf[this.pos + 5];
                    n3 = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        n4 = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                if (n == 0 && by == 0 && by2 == 0) {
                    this.lastValueNull |= 1;
                    return null;
                }
                if (serializable == null) {
                    Object object2 = object != null ? object : Calendar.getInstance();
                    Object object3 = object2;
                    synchronized (object2) {
                        ((Calendar)object2).clear();
                        ((Calendar)object2).set(1, n);
                        ((Calendar)object2).set(2, by - 1);
                        ((Calendar)object2).set(5, by2);
                        ((Calendar)object2).set(11, 0);
                        ((Calendar)object2).set(12, 0);
                        ((Calendar)object2).set(13, 0);
                        ((Calendar)object2).set(14, 0);
                        // ** MonitorExit[var7_14] (shouldn't be in output)
                        return new Date(((Calendar)object2).getTimeInMillis());
                    }
                }
                LocalDateTime localDateTime = LocalDateTime.of(n, by, (int)by2, (int)by3, n2, n3, n4 * 1000);
                serializable = localDateTime.atZone(((TimeZone)serializable).toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
                Object object4 = object != null ? object : Calendar.getInstance();
                object = object4;
                synchronized (object4) {
                    ((Calendar)object4).clear();
                    ((Calendar)object4).set(1, ((ZonedDateTime)serializable).getYear());
                    ((Calendar)object4).set(2, ((ZonedDateTime)serializable).getMonthValue() - 1);
                    ((Calendar)object4).set(5, ((ZonedDateTime)serializable).getDayOfMonth());
                    ((Calendar)object4).set(11, 0);
                    ((Calendar)object4).set(12, 0);
                    ((Calendar)object4).set(13, 0);
                    ((Calendar)object4).set(14, 0);
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                    return new Date(((Calendar)object4).getTimeInMillis());
                }
            }
            case TIME: {
                throw new SQLException("Cannot read Date using a Types.TIME field");
            }
            case STRING: {
                object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if ("0000-00-00".equals(object)) {
                    this.lastValueNull |= 2;
                    return null;
                }
                return new Date(Integer.parseInt(((String)object).substring(0, 4)) - 1900, Integer.parseInt(((String)object).substring(5, 7)) - 1, Integer.parseInt(((String)object).substring(8, 10)));
            }
        }
        int n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
        if (this.length == 2 && columnDefinition.getLength() == 2L) {
            n = n <= 69 ? (n += 2000) : (n += 1900);
        }
        if (this.length >= 4) {
            by = this.buf[this.pos + 2];
            by2 = this.buf[this.pos + 3];
        }
        return new Date(n - 1900, by - 1, by2);
    }

    @Override
    public Time getInternalTime(ColumnDefinition object, Calendar calendar, TimeZone serializable) {
        if (this.lastValueWasNull()) {
            return null;
        }
        int n = 0;
        byte by = 0;
        byte by2 = 0;
        int n2 = 0;
        int n3 = 0;
        switch (((ColumnDefinition)object).getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                if (this.length == 0) {
                    this.lastValueNull |= 1;
                    return null;
                }
                int n4 = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte by3 = this.buf[this.pos + 2];
                n = this.buf[this.pos + 3];
                if (this.length > 4) {
                    by = this.buf[this.pos + 4];
                    by2 = this.buf[this.pos + 5];
                    n2 = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        n3 = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                if (serializable == null) {
                    Calendar calendar2 = calendar != null ? calendar : Calendar.getInstance();
                    Calendar calendar3 = calendar2;
                    synchronized (calendar2) {
                        calendar2.clear();
                        calendar2.set(1, 1970);
                        calendar2.set(2, 0);
                        calendar2.set(5, 1);
                        calendar2.set(11, by);
                        calendar2.set(12, by2);
                        calendar2.set(13, n2);
                        calendar2.set(14, n3 / 1000);
                        // ** MonitorExit[var4_12] (shouldn't be in output)
                        return new Time(calendar2.getTimeInMillis());
                    }
                }
                LocalDateTime localDateTime = LocalDateTime.of(n4, by3, n, (int)by, (int)by2, n2, n3 * 1000);
                serializable = localDateTime.atZone(((TimeZone)serializable).toZoneId()).withZoneSameInstant(TimeZone.getDefault().toZoneId());
                Calendar calendar4 = calendar != null ? calendar : Calendar.getInstance();
                calendar = calendar4;
                synchronized (calendar4) {
                    calendar4.clear();
                    calendar4.set(1, 1970);
                    calendar4.set(2, 0);
                    calendar4.set(5, 1);
                    calendar4.set(11, ((ZonedDateTime)serializable).getHour());
                    calendar4.set(12, ((ZonedDateTime)serializable).getMinute());
                    calendar4.set(13, ((ZonedDateTime)serializable).getSecond());
                    calendar4.set(14, ((ZonedDateTime)serializable).getNano() / 1000000);
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return new Time(calendar4.getTimeInMillis());
                }
            }
            case DATE: {
                throw new SQLException("Cannot read Time using a Types.DATE field");
            }
        }
        object = calendar != null ? calendar : Calendar.getInstance();
        ((Calendar)object).clear();
        boolean bl = false;
        if (this.length > 0) {
            boolean bl2 = bl = (this.buf[this.pos] & 0xFF) == 1;
        }
        if (this.length > 4) {
            n = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
        }
        if (this.length > 7) {
            by = this.buf[this.pos + 5];
            by2 = this.buf[this.pos + 6];
            n2 = this.buf[this.pos + 7];
        }
        ((Calendar)object).set(1970, 0, (bl ? -1 : 1) * n + 1, (bl ? -1 : 1) * by, by2, n2);
        int n5 = 0;
        if (this.length > 8) {
            n5 = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
        }
        ((Calendar)object).set(14, n5 / 1000);
        return new Time(((Calendar)object).getTimeInMillis());
    }

    @Override
    public Timestamp getInternalTimestamp(ColumnDefinition object, Calendar calendar, TimeZone timeZone) {
        Timestamp timestamp;
        Object object2;
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        int n = 1970;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (((ColumnDefinition)object).getColumnType()) {
            case TIME: {
                object = calendar != null ? calendar : Calendar.getInstance();
                boolean bl = false;
                if (this.length > 0) {
                    boolean bl2 = bl = (this.buf[this.pos] & 0xFF) == 1;
                }
                if (this.length > 4) {
                    n3 = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                }
                if (this.length > 7) {
                    n4 = this.buf[this.pos + 5];
                    n5 = this.buf[this.pos + 6];
                    n6 = this.buf[this.pos + 7];
                }
                if (this.length > 8) {
                    n7 = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                }
                n = 1970;
                n2 = 1;
                n3 = (bl ? -1 : 1) * n3 + 1;
                n4 = (bl ? -1 : 1) * n4;
                break;
            }
            case STRING: 
            case VARSTRING: {
                object2 = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if (((String)object2).startsWith("0000-00-00 00:00:00")) {
                    this.lastValueNull |= 2;
                    return null;
                }
                if (((String)object2).length() >= 4) {
                    n = Integer.parseInt(((String)object2).substring(0, 4));
                    if (((String)object2).length() >= 7) {
                        n2 = Integer.parseInt(((String)object2).substring(5, 7));
                        if (((String)object2).length() >= 10) {
                            n3 = Integer.parseInt(((String)object2).substring(8, 10));
                            if (((String)object2).length() >= 19) {
                                n4 = Integer.parseInt(((String)object2).substring(11, 13));
                                n5 = Integer.parseInt(((String)object2).substring(14, 16));
                                n6 = Integer.parseInt(((String)object2).substring(17, 19));
                            }
                            n7 = this.extractNanos((String)object2) / 1000000;
                        }
                    }
                }
                if (calendar != null) {
                    object = calendar;
                    break;
                }
                if (timeZone != null) {
                    object = Calendar.getInstance(timeZone);
                    break;
                }
                object = Calendar.getInstance();
                break;
            }
            default: {
                n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                n2 = this.buf[this.pos + 2];
                n3 = this.buf[this.pos + 3];
                if (this.length > 4) {
                    n4 = this.buf[this.pos + 4];
                    n5 = this.buf[this.pos + 5];
                    n6 = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        n7 = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                object = calendar != null ? calendar : (timeZone != null && ((ColumnDefinition)object).getColumnType() != ColumnType.DATE ? Calendar.getInstance(timeZone) : Calendar.getInstance());
            }
        }
        object2 = object;
        synchronized (object2) {
            ((Calendar)object).clear();
            ((Calendar)object).set(n, n2 - 1, n3, n4, n5, n6);
            timestamp = new Timestamp(((Calendar)object).getTimeInMillis());
        }
        timestamp.setNanos(n7 * 1000);
        return timestamp;
    }

    @Override
    public Object getInternalObject(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                if (((ColumnDefinition)object).getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                object = new byte[this.length];
                System.arraycopy(this.buf, this.pos, object, 0, this.length);
                return object;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && ((ColumnDefinition)object).getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                return this.getInternalInt((ColumnDefinition)object);
            }
            case INTEGER: {
                if (!((ColumnDefinition)object).isSigned()) {
                    return this.getInternalLong((ColumnDefinition)object);
                }
                return this.getInternalInt((ColumnDefinition)object);
            }
            case BIGINT: {
                if (!((ColumnDefinition)object).isSigned()) {
                    return this.getInternalBigInteger((ColumnDefinition)object);
                }
                return this.getInternalLong((ColumnDefinition)object);
            }
            case DOUBLE: {
                return this.getInternalDouble((ColumnDefinition)object);
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                if (((ColumnDefinition)object).isBinary()) {
                    object = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, object, 0, this.getLengthMaxFieldSize());
                    return object;
                }
                return this.getInternalString((ColumnDefinition)object, null, timeZone);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getInternalTimestamp((ColumnDefinition)object, null, timeZone);
            }
            case DATE: {
                return this.getInternalDate((ColumnDefinition)object, null, timeZone);
            }
            case DECIMAL: {
                return this.getInternalBigDecimal((ColumnDefinition)object);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                object = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, object, 0, this.getLengthMaxFieldSize());
                return object;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return this.getInternalDate((ColumnDefinition)object, null, timeZone);
                }
                return this.getInternalShort((ColumnDefinition)object);
            }
            case MEDIUMINT: 
            case SMALLINT: {
                return this.getInternalInt((ColumnDefinition)object);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat((ColumnDefinition)object));
            }
            case TIME: {
                return this.getInternalTime((ColumnDefinition)object, null, timeZone);
            }
            case OLDDECIMAL: 
            case JSON: {
                return this.getInternalString((ColumnDefinition)object, null, timeZone);
            }
            case GEOMETRY: {
                object = new byte[this.length];
                System.arraycopy(this.buf, this.pos, object, 0, this.length);
                return object;
            }
        }
        throw ExceptionFactory.INSTANCE.notSupported(String.format("Type '%s' is not supported", ((ColumnDefinition)object).getColumnType().getTypeName()));
    }

    @Override
    public boolean getInternalBoolean(ColumnDefinition object) {
        if (this.lastValueWasNull()) {
            return false;
        }
        switch (((ColumnDefinition)object).getColumnType()) {
            case BIT: {
                return this.parseBit() != 0L;
            }
            case TINYINT: {
                return this.getInternalTinyInt((ColumnDefinition)object) != 0;
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt((ColumnDefinition)object) != 0;
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt((ColumnDefinition)object) != 0L;
            }
            case BIGINT: {
                return this.getInternalLong((ColumnDefinition)object) != 0L;
            }
            case FLOAT: {
                return this.getInternalFloat((ColumnDefinition)object) != 0.0f;
            }
            case DOUBLE: {
                return this.getInternalDouble((ColumnDefinition)object) != 0.0;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                return this.getInternalBigDecimal((ColumnDefinition)object).longValue() != 0L;
            }
        }
        object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        return !"false".equals(object) && !"0".equals(object);
    }

    @Override
    public byte getInternalByte(ColumnDefinition columnDefinition) {
        long l;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                l = this.parseBit();
                break;
            }
            case TINYINT: {
                l = this.getInternalTinyInt(columnDefinition);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                l = this.getInternalSmallInt(columnDefinition);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                l = this.getInternalMediumInt(columnDefinition);
                break;
            }
            case BIGINT: {
                l = this.getInternalLong(columnDefinition);
                break;
            }
            case FLOAT: {
                l = (long)this.getInternalFloat(columnDefinition);
                break;
            }
            case DOUBLE: {
                l = (long)this.getInternalDouble(columnDefinition);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnDefinition);
                this.rangeCheck(Byte.class, -128L, 127L, bigDecimal, columnDefinition);
                return bigDecimal.byteValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                l = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getByte not available for data field type " + columnDefinition.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Byte.class, -128L, 127L, l, columnDefinition);
        return (byte)l;
    }

    @Override
    public short getInternalShort(ColumnDefinition columnDefinition) {
        long l;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                l = this.parseBit();
                break;
            }
            case TINYINT: {
                l = this.getInternalTinyInt(columnDefinition);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                l = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
                if (columnDefinition.isSigned()) {
                    return (short)l;
                }
                l &= 0xFFFFL;
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                l = this.getInternalMediumInt(columnDefinition);
                break;
            }
            case BIGINT: {
                l = this.getInternalLong(columnDefinition);
                break;
            }
            case FLOAT: {
                l = (long)this.getInternalFloat(columnDefinition);
                break;
            }
            case DOUBLE: {
                l = (long)this.getInternalDouble(columnDefinition);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnDefinition);
                this.rangeCheck(Short.class, -32768L, 32767L, bigDecimal, columnDefinition);
                return bigDecimal.shortValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                l = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getShort not available for data field type " + columnDefinition.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Short.class, -32768L, 32767L, l, columnDefinition);
        return (short)l;
    }

    @Override
    public String getInternalTimeString(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            if (columnDefinition.getDecimals() == 0) {
                return "00:00:00";
            }
            StringBuilder stringBuilder = new StringBuilder("00:00:00.");
            int n = columnDefinition.getDecimals();
            while (n-- > 0) {
                stringBuilder.append("0");
            }
            return stringBuilder.toString();
        }
        String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(string)) {
            return null;
        }
        int n = this.buf[this.pos + 1] & 0xFF | (this.buf[this.pos + 2] & 0xFF) << 8 | (this.buf[this.pos + 3] & 0xFF) << 16 | (this.buf[this.pos + 4] & 0xFF) << 24;
        byte by = this.buf[this.pos + 5];
        String string2 = (n = by + n * 24) < 10 ? "0" + n : Integer.toString(n);
        by = this.buf[this.pos + 6];
        String string3 = by < 10 ? "0" + by : Integer.toString(by);
        byte by2 = this.buf[this.pos + 7];
        String string4 = by2 < 10 ? "0" + by2 : Integer.toString(by2);
        int n2 = 0;
        if (this.length > 8) {
            n2 = this.buf[this.pos + 8] & 0xFF | (this.buf[this.pos + 9] & 0xFF) << 8 | (this.buf[this.pos + 10] & 0xFF) << 16 | (this.buf[this.pos + 11] & 0xFF) << 24;
        }
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(n2));
        while (stringBuilder.length() < 6) {
            stringBuilder.insert(0, "0");
        }
        boolean bl = this.buf[this.pos] == 1;
        return (bl ? "-" : "") + string2 + ":" + string3 + ":" + string4 + "." + stringBuilder;
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnDefinition columnDefinition) {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnDefinition.getColumnType()) {
            case BIT: {
                return BigInteger.valueOf(this.buf[this.pos]);
            }
            case TINYINT: {
                return BigInteger.valueOf(columnDefinition.isSigned() ? (long)this.buf[this.pos] : (long)(this.buf[this.pos] & 0xFF));
            }
            case SMALLINT: 
            case YEAR: {
                short s = (short)(this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8);
                return BigInteger.valueOf(columnDefinition.isSigned() ? (long)s : (long)(s & 0xFFFF));
            }
            case INTEGER: 
            case MEDIUMINT: {
                int n = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return BigInteger.valueOf(columnDefinition.isSigned() ? (long)n : (n >= 0 ? (long)n : (long)n & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long l = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnDefinition.isSigned()) {
                    return BigInteger.valueOf(l);
                }
                return new BigInteger(1, new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getInternalFloat(columnDefinition));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getInternalDouble(columnDefinition));
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                return BigInteger.valueOf(this.getInternalBigDecimal(columnDefinition).longValue());
            }
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnDefinition object, Class clazz, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case 93: {
                int n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte by = this.buf[this.pos + 2];
                byte by2 = this.buf[this.pos + 3];
                byte by3 = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.length > 4) {
                    by3 = this.buf[this.pos + 4];
                    n2 = this.buf[this.pos + 5];
                    n3 = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        n4 = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                return ZonedDateTime.of(n, by, by2, by3, n2, n3, n4 * 1000, timeZone == null ? ZoneId.systemDefault() : timeZone.toZoneId());
            }
            case -1: 
            case 1: 
            case 12: {
                object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if (((String)object).startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse((CharSequence)object, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException((String)object + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnDefinition columnDefinition, TimeZone object) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if ((object = object == null ? ZoneId.systemDefault().normalized() : ((TimeZone)object).toZoneId().normalized()) instanceof ZoneOffset) {
            object = (ZoneOffset)object;
            int n = 0;
            byte by = 0;
            byte by2 = 0;
            int n2 = 0;
            int n3 = 0;
            switch (columnDefinition.getColumnType().getSqlType()) {
                case 93: {
                    int n4 = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    byte by3 = this.buf[this.pos + 2];
                    n = this.buf[this.pos + 3];
                    if (this.length > 4) {
                        by = this.buf[this.pos + 4];
                        by2 = this.buf[this.pos + 5];
                        n2 = this.buf[this.pos + 6];
                        if (this.length > 7) {
                            n3 = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                        }
                    }
                    return ZonedDateTime.of(n4, by3, n, by, by2, n2, n3 * 1000, (ZoneId)object).toOffsetDateTime().toOffsetTime();
                }
                case 92: {
                    boolean bl;
                    boolean bl2 = bl = (this.buf[this.pos] & 0xFF) == 1;
                    if (this.length > 4) {
                        n = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                    }
                    if (this.length > 7) {
                        by = this.buf[this.pos + 5];
                        by2 = this.buf[this.pos + 6];
                        n2 = this.buf[this.pos + 7];
                    }
                    if (this.length > 8) {
                        n3 = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                    }
                    return OffsetTime.of((bl ? -1 : 1) * (n * 24 + by), by2, n2, n3 * 1000, (ZoneOffset)object);
                }
                case -1: 
                case 1: 
                case 12: {
                    object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    try {
                        return OffsetTime.parse((CharSequence)object, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        throw new SQLException((String)object + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnDefinition.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnDefinition.getColumnType().getJavaTypeName() + " field");
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + object + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + object + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case 92: {
                boolean bl;
                int n = 0;
                byte by = 0;
                byte by2 = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl2 = bl = (this.buf[this.pos] & 0xFF) == 1;
                if (this.length > 4) {
                    n = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                }
                if (this.length > 7) {
                    by = this.buf[this.pos + 5];
                    by2 = this.buf[this.pos + 6];
                    n2 = this.buf[this.pos + 7];
                }
                if (this.length > 8) {
                    n3 = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                }
                return LocalTime.of((bl ? -1 : 1) * (n * 24 + by), by2, n2, n3 * 1000);
            }
            case -1: 
            case 1: 
            case 12: {
                String string = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                try {
                    if (timeZone == null) {
                        return LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME);
                    }
                    return LocalTime.parse(string, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException(string + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)((ColumnDefinition)object).getColumnType()) + "\")");
                }
            }
            case 93: {
                object = this.getInternalZonedDateTime((ColumnDefinition)object, LocalTime.class, timeZone);
                if (object == null) {
                    return null;
                }
                return ((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnDefinition object, TimeZone timeZone) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (((ColumnDefinition)object).getColumnType().getSqlType()) {
            case 91: {
                int n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte by = this.buf[this.pos + 2];
                byte by2 = this.buf[this.pos + 3];
                return LocalDate.of(n, by, (int)by2);
            }
            case 93: {
                object = this.getInternalZonedDateTime((ColumnDefinition)object, LocalDate.class, timeZone);
                if (object == null) {
                    return null;
                }
                return ((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
            case -1: 
            case 1: 
            case 12: {
                object = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if (((String)object).startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    if (timeZone == null) {
                        return LocalDate.parse((CharSequence)object, DateTimeFormatter.ISO_LOCAL_DATE);
                    }
                    return LocalDate.parse((CharSequence)object, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateTimeParseException) {
                    throw new SQLException((String)object + " cannot be parse as LocalDate. time must have \"yyyy-MM-dd\" format");
                }
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + ((ColumnDefinition)object).getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public boolean isBinaryEncoded() {
        return true;
    }
}

