/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.authentication.AuthenticationPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.Buffer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.Sha256PasswordPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.PacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class CachingSha2PasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "caching_sha2_password";
    private String a;
    private byte[] b;
    private Options c;

    public static byte[] sha256encryptPassword(String object, byte[] byArray, String object2) {
        if (object == null || ((String)object).isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        object = object2 != null && !((String)object2).isEmpty() ? (Object)((String)object).getBytes((String)object2) : (Object)((String)object).getBytes();
        object = messageDigest.digest((byte[])object);
        messageDigest.reset();
        object2 = messageDigest.digest((byte[])object);
        messageDigest.reset();
        messageDigest.update((byte[])object2);
        messageDigest.update(byArray);
        byArray = messageDigest.digest();
        object2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            object2[i] = (byte)(object[i] ^ byArray[i]);
        }
        return object2;
    }

    @Override
    public String name() {
        return "caching sha2 password";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String string, byte[] byArray, Options options) {
        this.b = byArray;
        this.a = string;
        this.c = options;
    }

    @Override
    public Buffer process(PacketOutputStream packetOutputStream, PacketInputStream packetInputStream, AtomicInteger atomicInteger) {
        Object object;
        if (this.a == null || this.a.isEmpty()) {
            packetOutputStream.writeEmptyPacket(atomicInteger.incrementAndGet());
        } else {
            try {
                packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                object = this.b.length > 0 ? (Object)Arrays.copyOfRange(this.b, 0, this.b.length - 1) : (Object)new byte[0];
                packetOutputStream.write(CachingSha2PasswordPlugin.sha256encryptPassword(this.a, (byte[])object, this.c.passwordCharacterEncoding));
                packetOutputStream.flush();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Could not use SHA-256, failing", noSuchAlgorithmException);
            }
        }
        object = packetInputStream.getPacket(true);
        atomicInteger.set(packetInputStream.getLastPacketSeq());
        switch (((Buffer)object).getByteAt(0)) {
            case -1: 
            case 0: {
                return object;
            }
        }
        byte[] byArray = ((Buffer)object).getLengthEncodedBytes();
        object = byArray;
        switch (byArray[0]) {
            case 3: {
                object = packetInputStream.getPacket(true);
                atomicInteger.set(packetInputStream.getLastPacketSeq());
                return object;
            }
            case 4: {
                if (Boolean.TRUE.equals(this.c.useSsl)) {
                    packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                    object = this.c.passwordCharacterEncoding != null && !this.c.passwordCharacterEncoding.isEmpty() ? (Object)this.a.getBytes(this.c.passwordCharacterEncoding) : (Object)this.a.getBytes();
                    packetOutputStream.write((byte[])object);
                    packetOutputStream.write(0);
                    packetOutputStream.flush();
                } else {
                    if (this.c.serverRsaPublicKeyFile != null && !this.c.serverRsaPublicKeyFile.isEmpty()) {
                        object = Sha256PasswordPlugin.readPublicKeyFromFile(this.c.serverRsaPublicKeyFile);
                    } else {
                        if (!this.c.allowPublicKeyRetrieval) {
                            throw new SQLException("RSA public key is not available client side (option serverRsaPublicKeyFile not set)", "S1009");
                        }
                        packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                        packetOutputStream.write(2);
                        packetOutputStream.flush();
                        object = Sha256PasswordPlugin.readPublicKeyFromSocket(packetInputStream, atomicInteger);
                    }
                    try {
                        object = Sha256PasswordPlugin.encrypt((PublicKey)object, this.a, this.b, this.c.passwordCharacterEncoding);
                        packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                        packetOutputStream.write((byte[])object);
                        packetOutputStream.flush();
                    }
                    catch (Exception exception) {
                        throw new SQLException("Could not connect using SHA256 plugin : " + exception.getMessage(), "S1009", exception);
                    }
                }
                object = packetInputStream.getPacket(true);
                atomicInteger.set(packetInputStream.getLastPacketSeq());
                return object;
            }
        }
        throw new SQLException("Protocol exchange error. Expect login success or RSA login request message", "S1009");
    }
}

