/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.authentication.AuthenticationPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.Buffer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.ErrorPacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.PacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class Sha256PasswordPlugin
implements AuthenticationPlugin {
    private String a;
    private Options b;
    private byte[] c;

    public static PublicKey readPublicKeyFromFile(String string) {
        byte[] byArray;
        try {
            byArray = Files.readAllBytes(Paths.get(string, new String[0]));
        }
        catch (IOException iOException) {
            throw new SQLException("Could not read server RSA public key from file : serverRsaPublicKeyFile=" + string, "S1009", iOException);
        }
        return Sha256PasswordPlugin.generatePublicKey(byArray);
    }

    public static PublicKey readPublicKeyFromSocket(PacketInputStream object, AtomicInteger object2) {
        Buffer buffer = object.getPacket(true);
        ((AtomicInteger)object2).set(object.getLastPacketSeq());
        switch (buffer.getByteAt(0)) {
            case -1: {
                object = new ErrorPacket(buffer);
                object2 = ((ErrorPacket)object).getMessage();
                throw new SQLException("Could not connect: " + (String)object2, ((ErrorPacket)object).getSqlState(), ((ErrorPacket)object).getErrorCode());
            }
            case -2: {
                throw new SQLException("Could not connect: receive AuthSwitchRequest in place of RSA public key. Did user has the rights to connect to database ?");
            }
        }
        buffer.skipByte();
        Buffer buffer2 = buffer;
        return Sha256PasswordPlugin.generatePublicKey(buffer2.readRawBytes(buffer2.remaining()));
    }

    public static PublicKey generatePublicKey(byte[] object) {
        try {
            object = new String((byte[])object).replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|\\n?-+END PUBLIC KEY-+\\r?\\n?)", "");
            object = Base64.getMimeDecoder().decode((String)object);
            object = new X509EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            throw new SQLException("Could read server RSA public key: " + exception.getMessage(), "S1009", exception);
        }
    }

    public static byte[] encrypt(PublicKey publicKey, String object, byte[] byArray, String object2) {
        byArray = byArray.length > 0 ? Arrays.copyOfRange(byArray, 0, byArray.length - 1) : new byte[]{};
        object = object2 != null && !((String)object2).isEmpty() ? (Object)((String)object).getBytes((String)object2) : (Object)((String)object).getBytes();
        Object object3 = object;
        byte[] byArray2 = Arrays.copyOf((byte[])object3, ((Object)object3).length + 1);
        object = byArray2;
        object2 = new byte[byArray2.length];
        int n = byArray.length;
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = (byte)(object[i] ^ byArray[i % n]);
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal((byte[])object2);
        }
        catch (Exception exception) {
            throw new SQLException("Could not connect using SHA256 plugin : " + exception.getMessage(), "S1009", exception);
        }
    }

    @Override
    public String name() {
        return "Sha256 authentication plugin";
    }

    @Override
    public String type() {
        return "sha256_password";
    }

    @Override
    public void initialize(String string, byte[] byArray, Options options) {
        this.c = byArray;
        this.a = string;
        this.b = options;
    }

    @Override
    public Buffer process(PacketOutputStream packetOutputStream, PacketInputStream packetInputStream, AtomicInteger atomicInteger) {
        Object object;
        if (this.a == null || this.a.isEmpty()) {
            packetOutputStream.writeEmptyPacket(atomicInteger.incrementAndGet());
        } else if (Boolean.TRUE.equals(this.b.useSsl)) {
            packetOutputStream.startPacket(atomicInteger.incrementAndGet());
            object = this.b.passwordCharacterEncoding != null && !this.b.passwordCharacterEncoding.isEmpty() ? (Object)this.a.getBytes(this.b.passwordCharacterEncoding) : (Object)this.a.getBytes();
            packetOutputStream.write((byte[])object);
            packetOutputStream.write(0);
            packetOutputStream.flush();
        } else {
            if (this.b.serverRsaPublicKeyFile != null && !this.b.serverRsaPublicKeyFile.isEmpty()) {
                object = Sha256PasswordPlugin.readPublicKeyFromFile(this.b.serverRsaPublicKeyFile);
            } else {
                if (!this.b.allowPublicKeyRetrieval) {
                    throw new SQLException("RSA public key is not available client side (option serverRsaPublicKeyFile)", "S1009");
                }
                packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                packetOutputStream.write(1);
                packetOutputStream.flush();
                object = Sha256PasswordPlugin.readPublicKeyFromSocket(packetInputStream, atomicInteger);
            }
            try {
                object = Sha256PasswordPlugin.encrypt((PublicKey)object, this.a, this.c, this.b.passwordCharacterEncoding);
                packetOutputStream.startPacket(atomicInteger.incrementAndGet());
                packetOutputStream.write((byte[])object);
                packetOutputStream.flush();
            }
            catch (Exception exception) {
                throw new SQLException("Could not connect using SHA256 plugin : " + exception.getMessage(), "S1009", exception);
            }
        }
        object = packetInputStream.getPacket(true);
        atomicInteger.set(packetInputStream.getLastPacketSeq());
        return object;
    }
}

