/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math;

import java.io.Serializable;
import java.util.Arrays;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math.Curve;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math.FieldElement;

public class GroupElement
implements Serializable {
    private static final long a = 2395879087349587L;
    final Curve curve;
    final Representation repr;
    final FieldElement X;
    final FieldElement Y;
    final FieldElement Z;
    final FieldElement T;
    GroupElement[][] precmp;
    GroupElement[] dblPrecmp;

    public GroupElement(Curve curve, Representation representation, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        this.curve = curve;
        this.repr = representation;
        this.X = fieldElement;
        this.Y = fieldElement2;
        this.Z = fieldElement3;
        this.T = fieldElement4;
    }

    public GroupElement(Curve curve, byte[] byArray) {
        FieldElement fieldElement = curve.getField().fromByteArray(byArray);
        FieldElement fieldElement2 = fieldElement.square();
        FieldElement fieldElement3 = fieldElement2.subtractOne();
        FieldElement fieldElement4 = fieldElement2.multiply(curve.getD()).addOne();
        FieldElement fieldElement5 = fieldElement4.square().multiply(fieldElement4);
        fieldElement2 = fieldElement5.square().multiply(fieldElement4).multiply(fieldElement3);
        fieldElement2 = fieldElement2.pow22523();
        fieldElement2 = fieldElement5.multiply(fieldElement3).multiply(fieldElement2);
        fieldElement4 = fieldElement2.square().multiply(fieldElement4);
        fieldElement5 = fieldElement4.subtract(fieldElement3);
        if (fieldElement5.isNonZero()) {
            fieldElement5 = fieldElement4.add(fieldElement3);
            if (fieldElement5.isNonZero()) {
                throw new IllegalArgumentException("not a valid GroupElement");
            }
            fieldElement2 = fieldElement2.multiply(curve.getI());
        }
        if ((fieldElement2.isNegative() ? 1 : 0) != Utils.bit(byArray, curve.getField().getb() - 1)) {
            fieldElement2 = fieldElement2.negate();
        }
        this.curve = curve;
        this.repr = Representation.P3;
        this.X = fieldElement2;
        this.Y = fieldElement;
        this.Z = curve.getField().ONE;
        this.T = this.X.multiply(this.Y);
    }

    public static GroupElement p2(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, Representation.P2, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement p3(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.P3, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public static GroupElement p1p1(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.P1P1, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    public static GroupElement precomp(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3) {
        return new GroupElement(curve, Representation.PRECOMP, fieldElement, fieldElement2, fieldElement3, null);
    }

    public static GroupElement cached(Curve curve, FieldElement fieldElement, FieldElement fieldElement2, FieldElement fieldElement3, FieldElement fieldElement4) {
        return new GroupElement(curve, Representation.CACHED, fieldElement, fieldElement2, fieldElement3, fieldElement4);
    }

    static byte[] toRadix16(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[64];
        for (n = 0; n < 32; ++n) {
            byArray2[2 * n] = (byte)(byArray[n] & 0xF);
            byArray2[2 * n + 1] = (byte)(byArray[n] >> 4 & 0xF);
        }
        int n2 = 0;
        n = 0;
        while (n < 63) {
            int n3 = n;
            byArray2[n3] = (byte)(byArray2[n3] + n2);
            n2 = byArray2[n] + 8;
            int n4 = n++;
            byArray2[n4] = (byte)(byArray2[n4] - ((n2 >>= 4) << 4));
        }
        byArray2[63] = (byte)(byArray2[63] + n2);
        return byArray2;
    }

    static byte[] slide(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray2[n] = (byte)(1 & byArray[n >> 3] >> (n & 7));
        }
        block1: for (n = 0; n < 256; ++n) {
            if (byArray2[n] == 0) continue;
            block2: for (int i = 1; i <= 6 && n + i < 256; ++i) {
                if (byArray2[n + i] == 0) continue;
                if (byArray2[n] + (byArray2[n + i] << i) <= 15) {
                    int n2 = n;
                    byArray2[n2] = (byte)(byArray2[n2] + (byArray2[n + i] << i));
                    byArray2[n + i] = 0;
                    continue;
                }
                if (byArray2[n] - (byArray2[n + i] << i) < -15) continue block1;
                int n3 = n;
                byArray2[n3] = (byte)(byArray2[n3] - (byArray2[n + i] << i));
                for (int j = n + i; j < 256; ++j) {
                    if (byArray2[j] == 0) {
                        byArray2[j] = 1;
                        continue block2;
                    }
                    byArray2[j] = 0;
                }
            }
        }
        return byArray2;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Representation getRepresentation() {
        return this.repr;
    }

    public FieldElement getX() {
        return this.X;
    }

    public FieldElement getY() {
        return this.Y;
    }

    public FieldElement getZ() {
        return this.Z;
    }

    public FieldElement getT() {
        return this.T;
    }

    public byte[] toByteArray() {
        switch (this.repr) {
            case P2: 
            case P3: {
                Object object = this.Z.invert();
                FieldElement fieldElement = this.X.multiply((FieldElement)object);
                object = this.Y.multiply((FieldElement)object);
                byte[] byArray = ((FieldElement)object).toByteArray();
                object = byArray;
                int n = ((Object)object).length - 1;
                byArray[n] = (byte)(byArray[n] | (fieldElement.isNegative() ? -128 : 0));
                return object;
            }
        }
        return this.toP2().toByteArray();
    }

    public GroupElement toP2() {
        return this.a(Representation.P2);
    }

    public GroupElement toP3() {
        return this.a(Representation.P3);
    }

    public GroupElement toCached() {
        return this.a(Representation.CACHED);
    }

    private GroupElement a(Representation representation) {
        switch (this.repr) {
            case P2: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X, this.Y, this.Z);
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.Y.add(this.X), this.Y.subtract(this.X), this.Z, this.T.multiply(this.curve.get2D()));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1P1: {
                switch (representation) {
                    case P2: {
                        return GroupElement.p2(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T));
                    }
                    case P3: {
                        return GroupElement.p3(this.curve, this.X.multiply(this.T), this.Y.multiply(this.Z), this.Z.multiply(this.T), this.X.multiply(this.Y));
                    }
                    case P1P1: {
                        return GroupElement.p1p1(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMP: {
                switch (representation) {
                    case PRECOMP: {
                        return GroupElement.precomp(this.curve, this.X, this.Y, this.Z);
                    }
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                switch (representation) {
                    case CACHED: {
                        return GroupElement.cached(this.curve, this.X, this.Y, this.Z, this.T);
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void precompute(boolean bl) {
        FieldElement fieldElement;
        Serializable serializable;
        int n;
        if (bl && this.precmp == null) {
            this.precmp = new GroupElement[32][8];
            GroupElement groupElement = this;
            for (n = 0; n < 32; ++n) {
                int n2;
                serializable = groupElement;
                for (n2 = 0; n2 < 8; ++n2) {
                    fieldElement = ((GroupElement)serializable).Z.invert();
                    FieldElement fieldElement2 = ((GroupElement)serializable).X.multiply(fieldElement);
                    fieldElement = ((GroupElement)serializable).Y.multiply(fieldElement);
                    this.precmp[n][n2] = GroupElement.precomp(this.curve, fieldElement.add(fieldElement2), fieldElement.subtract(fieldElement2), fieldElement2.multiply(fieldElement).multiply(this.curve.get2D()));
                    serializable = ((GroupElement)serializable).add(groupElement.toCached()).toP3();
                }
                for (n2 = 0; n2 < 8; ++n2) {
                    GroupElement groupElement2 = groupElement;
                    groupElement = groupElement2.add(groupElement2.toCached()).toP3();
                }
            }
        }
        if (this.dblPrecmp != null) {
            return;
        }
        this.dblPrecmp = new GroupElement[8];
        GroupElement groupElement = this;
        for (n = 0; n < 8; ++n) {
            serializable = groupElement.Z.invert();
            FieldElement fieldElement3 = groupElement.X.multiply((FieldElement)serializable);
            fieldElement = groupElement.Y.multiply((FieldElement)serializable);
            this.dblPrecmp[n] = GroupElement.precomp(this.curve, fieldElement.add(fieldElement3), fieldElement.subtract(fieldElement3), fieldElement3.multiply(fieldElement).multiply(this.curve.get2D()));
            GroupElement groupElement3 = this;
            groupElement = groupElement3.add(groupElement3.add(groupElement.toCached()).toP3().toCached()).toP3();
        }
    }

    public GroupElement dbl() {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.X.square();
                FieldElement fieldElement2 = this.Y.square();
                FieldElement fieldElement3 = this.Z.squareAndDouble();
                FieldElement fieldElement4 = this.X.add(this.Y);
                fieldElement4 = fieldElement4.square();
                FieldElement fieldElement5 = fieldElement2.add(fieldElement);
                fieldElement = fieldElement2.subtract(fieldElement);
                return GroupElement.p1p1(this.curve, fieldElement4.subtract(fieldElement5), fieldElement5, fieldElement, fieldElement3.subtract(fieldElement));
            }
        }
        throw new UnsupportedOperationException();
    }

    private GroupElement a(GroupElement serializable) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (serializable.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        fieldElement = fieldElement.multiply(serializable.X);
        fieldElement2 = fieldElement2.multiply(serializable.Y);
        serializable = serializable.Z.multiply(this.T);
        FieldElement fieldElement3 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement.subtract(fieldElement2), fieldElement.add(fieldElement2), fieldElement3.add((FieldElement)serializable), fieldElement3.subtract((FieldElement)serializable));
    }

    private GroupElement b(GroupElement serializable) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (serializable.repr != Representation.PRECOMP) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        fieldElement = fieldElement.multiply(serializable.Y);
        fieldElement2 = fieldElement2.multiply(serializable.X);
        serializable = serializable.Z.multiply(this.T);
        FieldElement fieldElement3 = this.Z.add(this.Z);
        return GroupElement.p1p1(this.curve, fieldElement.subtract(fieldElement2), fieldElement.add(fieldElement2), fieldElement3.subtract((FieldElement)serializable), fieldElement3.add((FieldElement)serializable));
    }

    public GroupElement add(GroupElement serializable) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (((GroupElement)serializable).repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        fieldElement = fieldElement.multiply(((GroupElement)serializable).X);
        fieldElement2 = fieldElement2.multiply(((GroupElement)serializable).Y);
        FieldElement fieldElement3 = ((GroupElement)serializable).T.multiply(this.T);
        serializable = this.Z.multiply(((GroupElement)serializable).Z);
        serializable = ((FieldElement)serializable).add((FieldElement)serializable);
        return GroupElement.p1p1(this.curve, fieldElement.subtract(fieldElement2), fieldElement.add(fieldElement2), ((FieldElement)serializable).add(fieldElement3), ((FieldElement)serializable).subtract(fieldElement3));
    }

    public GroupElement sub(GroupElement serializable) {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        if (((GroupElement)serializable).repr != Representation.CACHED) {
            throw new IllegalArgumentException();
        }
        FieldElement fieldElement = this.Y.add(this.X);
        FieldElement fieldElement2 = this.Y.subtract(this.X);
        fieldElement = fieldElement.multiply(((GroupElement)serializable).Y);
        fieldElement2 = fieldElement2.multiply(((GroupElement)serializable).X);
        FieldElement fieldElement3 = ((GroupElement)serializable).T.multiply(this.T);
        serializable = this.Z.multiply(((GroupElement)serializable).Z);
        serializable = ((FieldElement)serializable).add((FieldElement)serializable);
        return GroupElement.p1p1(this.curve, fieldElement.subtract(fieldElement2), fieldElement.add(fieldElement2), ((FieldElement)serializable).subtract(fieldElement3), ((FieldElement)serializable).add(fieldElement3));
    }

    public GroupElement negate() {
        if (this.repr != Representation.P3) {
            throw new UnsupportedOperationException();
        }
        return this.curve.getZero(Representation.P3).sub(this.toCached()).toP3();
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GroupElement)) {
            return false;
        }
        object = (GroupElement)object;
        if (!this.repr.equals((Object)((GroupElement)object).repr)) {
            try {
                object = super.a(this.repr);
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        switch (this.repr) {
            case P2: 
            case P3: {
                if (this.Z.equals(((GroupElement)object).Z)) {
                    return this.X.equals(((GroupElement)object).X) && this.Y.equals(((GroupElement)object).Y);
                }
                FieldElement fieldElement = this.X.multiply(((GroupElement)object).Z);
                FieldElement fieldElement2 = this.Y.multiply(((GroupElement)object).Z);
                FieldElement fieldElement3 = ((GroupElement)object).X.multiply(this.Z);
                object = ((GroupElement)object).Y.multiply(this.Z);
                return fieldElement.equals(fieldElement3) && fieldElement2.equals(object);
            }
            case P1P1: {
                return this.toP2().equals(object);
            }
            case PRECOMP: {
                return this.X.equals(((GroupElement)object).X) && this.Y.equals(((GroupElement)object).Y) && this.Z.equals(((GroupElement)object).Z);
            }
            case CACHED: {
                if (this.Z.equals(((GroupElement)object).Z)) {
                    return this.X.equals(((GroupElement)object).X) && this.Y.equals(((GroupElement)object).Y) && this.T.equals(((GroupElement)object).T);
                }
                FieldElement fieldElement = this.X.multiply(((GroupElement)object).Z);
                FieldElement fieldElement4 = this.Y.multiply(((GroupElement)object).Z);
                FieldElement fieldElement5 = this.T.multiply(((GroupElement)object).Z);
                FieldElement fieldElement6 = ((GroupElement)object).X.multiply(this.Z);
                FieldElement fieldElement7 = ((GroupElement)object).Y.multiply(this.Z);
                object = ((GroupElement)object).T.multiply(this.Z);
                return fieldElement.equals(fieldElement6) && fieldElement4.equals(fieldElement7) && fieldElement5.equals(object);
            }
        }
        return false;
    }

    GroupElement cmov(GroupElement groupElement, int n) {
        return GroupElement.precomp(this.curve, this.X.cmov(groupElement.X, n), this.Y.cmov(groupElement.Y, n), this.Z.cmov(groupElement.Z, n));
    }

    GroupElement select(int n, int n2) {
        int n3 = Utils.negative(n2);
        n2 -= (-n3 & n2) << 1;
        GroupElement groupElement = this.curve.getZero(Representation.PRECOMP).cmov(this.precmp[n][0], Utils.equal(n2, 1)).cmov(this.precmp[n][1], Utils.equal(n2, 2)).cmov(this.precmp[n][2], Utils.equal(n2, 3)).cmov(this.precmp[n][3], Utils.equal(n2, 4)).cmov(this.precmp[n][4], Utils.equal(n2, 5)).cmov(this.precmp[n][5], Utils.equal(n2, 6)).cmov(this.precmp[n][6], Utils.equal(n2, 7)).cmov(this.precmp[n][7], Utils.equal(n2, 8));
        GroupElement groupElement2 = GroupElement.precomp(this.curve, groupElement.Y, groupElement.X, groupElement.Z.negate());
        return groupElement.cmov(groupElement2, n3);
    }

    public GroupElement scalarMultiply(byte[] object) {
        byte[] byArray = GroupElement.toRadix16(object);
        GroupElement groupElement = this.curve.getZero(Representation.P3);
        GroupElement groupElement2 = this;
        synchronized (groupElement2) {
            int n;
            for (n = 1; n < 64; n += 2) {
                object = this.select(n / 2, byArray[n]);
                groupElement = groupElement.a((GroupElement)object).toP3();
            }
            groupElement = groupElement.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
            for (n = 0; n < 64; n += 2) {
                object = this.select(n / 2, byArray[n]);
                groupElement = groupElement.a((GroupElement)object).toP3();
            }
        }
        return groupElement;
    }

    public GroupElement doubleScalarMultiplyVariableTime(GroupElement groupElement, byte[] byArray, byte[] byArray2) {
        int n;
        byArray = GroupElement.slide(byArray);
        byArray2 = GroupElement.slide(byArray2);
        GroupElement groupElement2 = this.curve.getZero(Representation.P2);
        for (n = 255; n >= 0 && byArray[n] == 0 && byArray2[n] == 0; --n) {
        }
        GroupElement groupElement3 = this;
        synchronized (groupElement3) {
            while (n >= 0) {
                groupElement2 = groupElement2.dbl();
                if (byArray[n] > 0) {
                    groupElement2 = groupElement2.toP3().a(groupElement.dblPrecmp[byArray[n] / 2]);
                } else if (byArray[n] < 0) {
                    groupElement2 = groupElement2.toP3().b(groupElement.dblPrecmp[-byArray[n] / 2]);
                }
                if (byArray2[n] > 0) {
                    groupElement2 = groupElement2.toP3().a(this.dblPrecmp[byArray2[n] / 2]);
                } else if (byArray2[n] < 0) {
                    groupElement2 = groupElement2.toP3().b(this.dblPrecmp[-byArray2[n] / 2]);
                }
                groupElement2 = groupElement2.toP2();
                --n;
            }
        }
        return groupElement2;
    }

    public boolean isOnCurve() {
        GroupElement groupElement = this;
        return groupElement.isOnCurve(groupElement.curve);
    }

    public boolean isOnCurve(Curve curve) {
        switch (this.repr) {
            case P2: 
            case P3: {
                FieldElement fieldElement = this.Z.invert();
                FieldElement fieldElement2 = this.X.multiply(fieldElement);
                fieldElement = this.Y.multiply(fieldElement);
                fieldElement2 = fieldElement2.square();
                fieldElement = fieldElement.square();
                FieldElement fieldElement3 = curve.getD().multiply(fieldElement2).multiply(fieldElement);
                return curve.getField().ONE.add(fieldElement3).add(fieldElement2).equals(fieldElement);
            }
        }
        return this.toP2().isOnCurve(curve);
    }

    public String toString() {
        return "[GroupElement\nX=" + this.X + "\nY=" + this.Y + "\nZ=" + this.Z + "\nT=" + this.T + "\n]";
    }

    public static enum Representation {
        P2,
        P3,
        P1P1,
        PRECOMP,
        CACHED;

    }
}

