/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.spec;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math.Curve;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math.GroupElement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.ed25519.math.ed25519.ScalarOps;

public class EdDSAParameterSpec
implements Serializable,
AlgorithmParameterSpec {
    private static final long a = 8274987108472012L;
    private final Curve b;
    private final String c;
    private final ScalarOps d;
    private final GroupElement e;

    public EdDSAParameterSpec(Curve curve, String string, ScalarOps scalarOps, GroupElement groupElement) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            if (curve.getField().getb() / 4 != messageDigest.getDigestLength()) {
                throw new IllegalArgumentException("Hash output is not 2b-bit");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
        this.b = curve;
        this.c = string;
        this.d = scalarOps;
        this.e = groupElement;
    }

    public Curve getCurve() {
        return this.b;
    }

    public String getHashAlgorithm() {
        return this.c;
    }

    public ScalarOps getScalarOps() {
        return this.d;
    }

    public GroupElement getB() {
        return this.e;
    }

    public int hashCode() {
        return this.c.hashCode() ^ this.b.hashCode() ^ this.e.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdDSAParameterSpec)) {
            return false;
        }
        return this.c.equals(((EdDSAParameterSpec)(object = (EdDSAParameterSpec)object)).getHashAlgorithm()) && this.b.equals(((EdDSAParameterSpec)object).getCurve()) && this.e.equals(((EdDSAParameterSpec)object).getB());
    }
}

