/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters;

import java.time.LocalTime;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;

public class LocalTimeParameter
implements Cloneable,
ParameterHolder {
    private final LocalTime a;
    private final boolean b;

    public LocalTimeParameter(LocalTime localTime, boolean bl) {
        this.a = localTime;
        this.b = bl;
    }

    @Override
    public void writeTo(PacketOutputStream packetOutputStream) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(this.a.getHour() < 10 ? "0" : "").append(this.a.getHour()).append(this.a.getMinute() < 10 ? ":0" : ":").append(this.a.getMinute()).append(this.a.getSecond() < 10 ? ":0" : ":").append(this.a.getSecond());
        int n = this.a.getNano() / 1000;
        if (n > 0 && this.b) {
            stringBuilder.append(".");
            if (n % 1000 == 0) {
                stringBuilder.append(Integer.toString(n / 1000 + 1000).substring(1));
            } else {
                stringBuilder.append(Integer.toString(n + 1000000).substring(1));
            }
        }
        packetOutputStream.write(39);
        packetOutputStream.write(stringBuilder.toString().getBytes());
        packetOutputStream.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 15;
    }

    @Override
    public void writeBinary(PacketOutputStream packetOutputStream) {
        int n = this.a.getNano();
        if (this.b && n > 0) {
            packetOutputStream.write(12);
            packetOutputStream.write(0);
            packetOutputStream.writeInt(0);
            packetOutputStream.write((byte)this.a.getHour());
            packetOutputStream.write((byte)this.a.getMinute());
            packetOutputStream.write((byte)this.a.getSecond());
            packetOutputStream.writeInt(n / 1000);
            return;
        }
        packetOutputStream.write(8);
        packetOutputStream.write(0);
        packetOutputStream.writeInt(0);
        packetOutputStream.write((byte)this.a.getHour());
        packetOutputStream.write((byte)this.a.getMinute());
        packetOutputStream.write((byte)this.a.getSecond());
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TIME;
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

