/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class ZonedDateTimeParameter
implements Cloneable,
ParameterHolder {
    private final ZonedDateTime a;
    private final boolean b;

    public ZonedDateTimeParameter(ZonedDateTime zonedDateTime, TimeZone serializable, boolean bl, Options options) {
        serializable = serializable == null ? ZoneOffset.systemDefault() : serializable.toZoneId();
        this.a = zonedDateTime.withZoneSameInstant((ZoneId)serializable);
        this.b = bl;
    }

    @Override
    public void writeTo(PacketOutputStream packetOutputStream) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.b ? "yyyy-MM-dd HH:mm:ss.SSSSSS" : "yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        packetOutputStream.write(39);
        packetOutputStream.write(dateTimeFormatter.format(this.a).getBytes());
        packetOutputStream.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 27;
    }

    @Override
    public void writeBinary(PacketOutputStream packetOutputStream) {
        packetOutputStream.write((byte)(this.b ? 11 : 7));
        packetOutputStream.writeShort((short)this.a.getYear());
        packetOutputStream.write((byte)this.a.getMonth().getValue());
        packetOutputStream.write((byte)this.a.getDayOfMonth());
        packetOutputStream.write((byte)this.a.getHour());
        packetOutputStream.write((byte)this.a.getMinute());
        packetOutputStream.write((byte)this.a.getSecond());
        if (this.b) {
            packetOutputStream.writeInt(this.a.getNano() / 1000);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.a.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

