/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.FailoverProxy;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.HandleErrorResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.Listener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread.ConnectionValidator;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.SqlStates;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ClientPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;

public abstract class AbstractMastersListener
implements Listener {
    private static final ConcurrentMap<HostAddress, Long> a = new ConcurrentHashMap<HostAddress, Long>();
    private static final ConnectionValidator b = new ConnectionValidator();
    private static final Logger c = LoggerFactory.getLogger(AbstractMastersListener.class);
    public final UrlParser urlParser;
    protected final AtomicInteger currentConnectionAttempts = new AtomicInteger();
    protected final AtomicBoolean explicitClosed = new AtomicBoolean(false);
    protected final GlobalStateInfo globalInfo;
    private final AtomicBoolean d = new AtomicBoolean();
    protected volatile boolean currentReadOnlyAsked = false;
    protected Protocol currentProtocol = null;
    protected FailoverProxy proxy;
    protected long lastRetry = 0L;
    protected long lastQueryNanos = 0L;
    private volatile long e = 0L;

    protected AbstractMastersListener(UrlParser urlParser, GlobalStateInfo globalStateInfo) {
        this.urlParser = urlParser;
        this.globalInfo = globalStateInfo;
        this.d.set(true);
        this.lastQueryNanos = System.nanoTime();
    }

    public static void clearBlacklist() {
        a.clear();
    }

    @Override
    public void initializeConnection() {
        long l = TimeUnit.SECONDS.toMillis(this.urlParser.getOptions().validConnectionTimeout);
        this.lastQueryNanos = System.nanoTime();
        if (l > 0L) {
            b.addListener(this, l);
        }
    }

    protected void removeListenerFromSchedulers() {
        b.removeListener(this);
    }

    protected void preAutoReconnect() {
        if (!this.isExplicitClosed()) {
            try {
                boolean bl = this.currentReadOnlyAsked;
                this.reconnectFailedConnection(new SearchFilter(!bl, bl));
            }
            catch (SQLException sQLException) {}
            this.handleFailLoop();
            return;
        }
        throw new SQLException("Connection is closed", SqlStates.CONNECTION_EXCEPTION.getSqlState());
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy failoverProxy) {
        this.proxy = failoverProxy;
    }

    @Override
    public Set<HostAddress> getBlacklistKeys() {
        return a.keySet();
    }

    @Override
    public HandleErrorResult handleFailover(SQLException sQLException, Method method, Object[] objectArray, Protocol protocol, boolean bl) {
        if (this.isExplicitClosed()) {
            throw new SQLException("Connection has been closed !");
        }
        if (this.setMasterHostFail()) {
            c.warn("SQL Primary node [{}, conn={}, local_port={}, timeout={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), this.currentProtocol.getSocket().getLocalPort(), this.currentProtocol.getTimeout(), sQLException.getMessage());
            AbstractMastersListener abstractMastersListener = this;
            abstractMastersListener.addToBlacklist(abstractMastersListener.currentProtocol.getHostAddress());
        }
        boolean bl2 = sQLException != null && sQLException.getSQLState() != null && sQLException.getSQLState().equals("70100") && 1927 == sQLException.getErrorCode();
        return this.primaryFail(method, objectArray, bl2, bl);
    }

    @Override
    public void addToBlacklist(HostAddress hostAddress) {
        if (hostAddress != null && !this.isExplicitClosed()) {
            a.putIfAbsent(hostAddress, System.nanoTime());
        }
    }

    @Override
    public void removeFromBlacklist(HostAddress hostAddress) {
        if (hostAddress != null) {
            a.remove(hostAddress);
        }
    }

    public void resetOldsBlackListHosts() {
        long l = System.nanoTime();
        Object object = a.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            long l2 = (Long)entry.getValue();
            long l3 = TimeUnit.NANOSECONDS.toSeconds(l - l2);
            if (l3 < (long)this.urlParser.getOptions().loadBalanceBlacklistTimeout) continue;
            a.remove(entry.getKey(), l2);
        }
    }

    protected void resetMasterFailoverData() {
        if (this.d.compareAndSet(true, false)) {
            this.e = 0L;
        }
    }

    protected void setSessionReadOnly(boolean bl, Protocol protocol) {
        if (protocol.versionGreaterOrEqual(5, 6, 5)) {
            c.info("SQL node [{}, conn={}] is now in {} mode.", protocol.getHostAddress().toString(), protocol.getServerThreadId(), bl ? "read-only" : "write");
            protocol.executeQuery("SET SESSION TRANSACTION " + (bl ? "READ ONLY" : "READ WRITE"));
        }
    }

    public abstract void handleFailLoop();

    @Override
    public Protocol getCurrentProtocol() {
        return this.currentProtocol;
    }

    public long getMasterHostFailNanos() {
        return this.e;
    }

    @Override
    public boolean setMasterHostFail() {
        if (this.d.compareAndSet(false, true)) {
            this.e = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMasterHostFail() {
        return this.d.get();
    }

    @Override
    public boolean hasHostFail() {
        return this.d.get();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), false);
    }

    public HandleErrorResult relaunchOperation(Method method, Object[] objectArray) {
        HandleErrorResult handleErrorResult = new HandleErrorResult(true);
        if (method != null) {
            switch (method.getName()) {
                case "executeQuery": {
                    String string;
                    if (!(objectArray[2] instanceof String) || "ALTER SYSTEM CRASH".equals(string = ((String)objectArray[2]).toUpperCase(Locale.ROOT)) || string.startsWith("KILL")) break;
                    c.debug("relaunch query to new connection {}", (Object)(this.currentProtocol != null ? "(conn=" + this.currentProtocol.getServerThreadId() + ")" : ""));
                    try {
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, objectArray);
                        handleErrorResult.mustThrowError = false;
                        break;
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new SQLException(reflectiveOperationException.getCause());
                    }
                }
                case "executePreparedQuery": {
                    try {
                        boolean bl = (Boolean)objectArray[0];
                        ServerPrepareResult serverPrepareResult = (ServerPrepareResult)objectArray[1];
                        ServerPrepareResult serverPrepareResult2 = this.currentProtocol.prepare(serverPrepareResult.getSql(), bl);
                        serverPrepareResult.failover(serverPrepareResult2.getStatementId(), this.currentProtocol);
                        c.debug("relaunch query to new connection " + (this.currentProtocol != null ? "server thread id " + this.currentProtocol.getServerThreadId() : ""));
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, objectArray);
                        handleErrorResult.mustThrowError = false;
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    try {
                        handleErrorResult.resultObject = method.invoke((Object)this.currentProtocol, objectArray);
                        handleErrorResult.mustThrowError = false;
                        break;
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new SQLException(reflectiveOperationException);
                    }
                }
            }
        }
        return handleErrorResult;
    }

    public boolean isQueryRelaunchable(Method object, Object[] objectArray) {
        if (object != null) {
            switch (((Method)object).getName()) {
                case "executeQuery": {
                    if (!((Boolean)objectArray[0]).booleanValue()) {
                        return true;
                    }
                    if (objectArray[2] instanceof String) {
                        return ((String)objectArray[2]).toUpperCase(Locale.ROOT).startsWith("SELECT");
                    }
                    if (!(objectArray[2] instanceof ClientPrepareResult)) break;
                    object = new String(((ClientPrepareResult)objectArray[2]).getQueryParts().get(0)).toUpperCase(Locale.ROOT);
                    return ((String)object).startsWith("SELECT");
                }
                case "executePreparedQuery": {
                    if (!((Boolean)objectArray[0]).booleanValue()) {
                        return true;
                    }
                    object = (ServerPrepareResult)objectArray[1];
                    return ((ServerPrepareResult)object).getSql().toUpperCase(Locale.ROOT).startsWith("SELECT");
                }
                case "executeBatchStmt": 
                case "executeBatchClient": 
                case "executeBatchServer": {
                    return (Boolean)objectArray[0] == false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Object invoke(Method method, Object[] objectArray, Protocol protocol) {
        return method.invoke((Object)protocol, objectArray);
    }

    @Override
    public Object invoke(Method method, Object[] objectArray) {
        return method.invoke((Object)this.currentProtocol, objectArray);
    }

    @Override
    public void syncConnection(Protocol protocol, Protocol protocol2) {
        if (protocol != null) {
            this.proxy.lock.lock();
            try {
                protocol2.resetStateAfterFailover(protocol.getMaxRows(), protocol.getTransactionIsolationLevel(), protocol.getDatabase(), protocol.getAutocommit());
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public boolean versionGreaterOrEqual(int n, int n2, int n3) {
        return this.currentProtocol.versionGreaterOrEqual(n, n2, n3);
    }

    @Override
    public boolean isServerMariaDb() {
        return this.currentProtocol.isServerMariaDb();
    }

    @Override
    public boolean sessionStateAware() {
        return this.currentProtocol.sessionStateAware();
    }

    @Override
    public boolean noBackslashEscapes() {
        return this.currentProtocol.noBackslashEscapes();
    }

    @Override
    public int getMajorServerVersion() {
        return this.currentProtocol.getMajorServerVersion();
    }

    @Override
    public boolean isClosed() {
        return this.currentProtocol.isClosed();
    }

    @Override
    public boolean isValid(int n) {
        return this.currentProtocol.isValid(n);
    }

    @Override
    public boolean isReadOnly() {
        return this.currentReadOnlyAsked;
    }

    @Override
    public boolean inTransaction() {
        return this.currentProtocol.inTransaction();
    }

    @Override
    public boolean isMasterConnection() {
        return true;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed.get();
    }

    @Override
    public int getRetriesAllDown() {
        return this.urlParser.getOptions().retriesAllDown;
    }

    @Override
    public boolean isAutoReconnect() {
        return this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public abstract void preExecute();

    @Override
    public abstract void preClose();

    @Override
    public abstract void reconnectFailedConnection(SearchFilter var1);

    @Override
    public abstract void switchReadOnlyConnection(Boolean var1);

    @Override
    public abstract HandleErrorResult primaryFail(Method var1, Object[] var2, boolean var3, boolean var4);

    @Override
    public void throwFailoverMessage(HostAddress object, boolean bl, SQLException sQLException, boolean bl2) {
        object = "Communications link failure with " + (bl ? "primary" : "secondary") + (object != null ? " host " + ((HostAddress)object).host + ":" + ((HostAddress)object).port : "") + ". ";
        String string = "";
        if (bl2) {
            string = string + " Driver has reconnect connection";
        } else if (this.currentConnectionAttempts.get() > this.urlParser.getOptions().retriesAllDown) {
            string = string + " Driver will not try to reconnect (too much failure > " + this.urlParser.getOptions().retriesAllDown + ")";
        }
        int n = 0;
        Throwable throwable = null;
        if (sQLException == null) {
            object = (String)object + string;
            string = SqlStates.CONNECTION_EXCEPTION.getSqlState();
        } else {
            object = (String)object + sQLException.getMessage() + ". " + string;
            string = sQLException.getSQLState();
            n = sQLException.getErrorCode();
            throwable = sQLException.getCause();
        }
        if (string != null && string.startsWith("08")) {
            if (bl2) {
                string = "25S03";
            } else {
                throw new SQLNonTransientConnectionException((String)object, string, n, throwable);
            }
        }
        throw new SQLException((String)object, string, n, throwable);
    }

    @Override
    public boolean canRetryFailLoop() {
        return this.currentConnectionAttempts.get() < this.urlParser.getOptions().failoverLoopRetries;
    }

    @Override
    public void prolog(long l, MariaDbConnection mariaDbConnection, MariaDbStatement mariaDbStatement) {
        this.currentProtocol.prolog(l, true, mariaDbConnection, mariaDbStatement);
    }

    @Override
    public String getCatalog() {
        return this.currentProtocol.getCatalog();
    }

    @Override
    public int getTimeout() {
        return this.currentProtocol.getTimeout();
    }

    @Override
    public abstract void reconnect();

    @Override
    public abstract boolean checkMasterStatus(SearchFilter var1);

    @Override
    public long getLastQueryNanos() {
        return this.lastQueryNanos;
    }

    protected boolean pingMasterProtocol(Protocol protocol) {
        try {
            if (protocol.isValid(1000)) {
                return true;
            }
        }
        catch (SQLException sQLException) {}
        this.proxy.lock.lock();
        try {
            protocol.close();
            if (this.setMasterHostFail()) {
                this.addToBlacklist(protocol.getHostAddress());
            }
        }
        finally {
            this.proxy.lock.unlock();
        }
        return false;
    }

    public void closeConnection(Protocol protocol) {
        if (protocol != null && protocol.isConnected()) {
            protocol.close();
        }
    }

    public void abortConnection(Protocol protocol) {
        if (protocol != null && protocol.isConnected()) {
            protocol.abort();
        }
    }
}

