/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.AbstractMastersListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.HandleErrorResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;

public abstract class AbstractMastersReplicasListener
extends AbstractMastersListener {
    private static final Logger a = LoggerFactory.getLogger(AbstractMastersReplicasListener.class);
    protected final AtomicReference<Protocol> waitNewSecondaryProtocol = new AtomicReference();
    protected final AtomicReference<Protocol> waitNewMasterProtocol = new AtomicReference();
    private final AtomicBoolean b = new AtomicBoolean();
    private volatile long c = 0L;

    protected AbstractMastersReplicasListener(UrlParser urlParser, GlobalStateInfo globalStateInfo) {
        super(urlParser, globalStateInfo);
        this.b.set(true);
    }

    @Override
    public HandleErrorResult handleFailover(SQLException sQLException, Method method, Object[] objectArray, Protocol protocol, boolean bl) {
        boolean bl2;
        if (this.isExplicitClosed()) {
            throw new SQLException("Connection has been closed !");
        }
        boolean bl3 = bl2 = sQLException != null && sQLException.getSQLState() != null && sQLException.getSQLState().equals("70100") && 1927 == sQLException.getErrorCode();
        if (protocol != null) {
            if (protocol.mustBeMasterConnection()) {
                if (!protocol.isMasterConnection()) {
                    a.warn("SQL Primary node [{}, conn={}] is now in read-only mode. Exception : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), sQLException.getMessage());
                } else if (this.setMasterHostFail()) {
                    a.warn("SQL Primary node [{}, conn={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), sQLException.getMessage());
                    this.addToBlacklist(protocol.getHostAddress());
                }
                return this.primaryFail(method, objectArray, bl2, bl);
            }
            if (this.setSecondaryHostFail()) {
                a.warn("SQL secondary node [{}, conn={}] connection fail. Reason : {}", this.currentProtocol.getHostAddress().toString(), this.currentProtocol.getServerThreadId(), sQLException.getMessage());
                this.addToBlacklist(protocol.getHostAddress());
            }
            return this.secondaryFail(method, objectArray, bl2);
        }
        return this.primaryFail(method, objectArray, bl2, bl);
    }

    @Override
    protected void resetMasterFailoverData() {
        super.resetMasterFailoverData();
        if (!this.b.get()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    protected void resetSecondaryFailoverData() {
        if (this.b.compareAndSet(true, false)) {
            this.c = 0L;
        }
        if (!this.isMasterHostFail()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    public long getSecondaryHostFailNanos() {
        return this.c;
    }

    public boolean setSecondaryHostFail() {
        if (this.b.compareAndSet(false, true)) {
            this.c = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isSecondaryHostFail() {
        return this.b.get();
    }

    public boolean isSecondaryHostFailReconnect() {
        return this.b.get() && this.waitNewSecondaryProtocol.get() == null;
    }

    public boolean isMasterHostFailReconnect() {
        return this.isMasterHostFail() && this.waitNewMasterProtocol.get() == null;
    }

    @Override
    public boolean hasHostFail() {
        return this.isSecondaryHostFailReconnect() || this.isMasterHostFailReconnect();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail());
    }

    public abstract HandleErrorResult secondaryFail(Method var1, Object[] var2, boolean var3);

    public abstract void foundActiveSecondary(Protocol var1);
}

