/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.HandleErrorResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.Listener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;

public class FailoverProxy
implements InvocationHandler {
    private static final String a = "isExplicitClosed";
    private static final String b = "getOptions";
    private static final String c = "getUrlParser";
    private static final String d = "getProxy";
    private static final String e = "executeQuery";
    private static final String f = "setReadonly";
    private static final String g = "getReadonly";
    private static final String h = "isMasterConnection";
    private static final String i = "versionGreaterOrEqual";
    private static final String j = "sessionStateAware";
    private static final String k = "closeExplicit";
    private static final String l = "abort";
    private static final String m = "isClosed";
    private static final String n = "executePreparedQuery";
    private static final String o = "prepareAndExecutesComMulti";
    private static final String p = "prologProxy";
    private static final String q = "reset";
    private static final String r = "isValid";
    private static final String s = "getLock";
    private static final String t = "noBackslashEscapes";
    private static final String u = "getServerThreadId";
    private static final String v = "prolog";
    private static final String w = "getCatalog";
    private static final String x = "getTimeout";
    private static final String y = "getMajorServerVersion";
    private static final String z = "inTransaction";
    private static final String A = "isServerMariaDb";
    private static final Logger B = LoggerFactory.getLogger(FailoverProxy.class);
    public final ReentrantLock lock;
    public final LruTraceCache traceCache;
    private final Listener C;

    public FailoverProxy(Listener listener, ReentrantLock reentrantLock, LruTraceCache lruTraceCache) {
        this.lock = reentrantLock;
        this.C = listener;
        this.C.setProxy(this);
        this.traceCache = lruTraceCache;
        this.C.initializeConnection();
    }

    private static SQLException a(SQLException sQLException, Protocol protocol) {
        if (protocol != null) {
            return new SQLException(sQLException.getMessage() + "\non " + protocol.getHostAddress().toString() + ",master=" + protocol.isMasterConnection(), sQLException.getSQLState(), sQLException.getErrorCode(), sQLException.getCause());
        }
        return sQLException;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        switch (method.getName()) {
            case "getLock": {
                return this.lock;
            }
            case "noBackslashEscapes": {
                return this.C.noBackslashEscapes();
            }
            case "isServerMariaDb": {
                return this.C.isServerMariaDb();
            }
            case "getCatalog": {
                return this.C.getCatalog();
            }
            case "getTimeout": {
                return this.C.getTimeout();
            }
            case "versionGreaterOrEqual": {
                return this.C.versionGreaterOrEqual((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2]);
            }
            case "sessionStateAware": {
                return this.C.sessionStateAware();
            }
            case "isExplicitClosed": {
                return this.C.isExplicitClosed();
            }
            case "getOptions": {
                return this.C.getUrlParser().getOptions();
            }
            case "getMajorServerVersion": {
                return this.C.getMajorServerVersion();
            }
            case "getServerThreadId": {
                return this.C.getServerThreadId();
            }
            case "getUrlParser": {
                return this.C.getUrlParser();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.C.isClosed();
            }
            case "isValid": {
                return this.C.isValid((Integer)objectArray[0]);
            }
            case "prolog": {
                this.C.prolog((Long)objectArray[0], (MariaDbConnection)objectArray[2], (MariaDbStatement)objectArray[3]);
                return null;
            }
            case "executeQuery": {
                boolean bl = this.C.isClosed();
                try {
                    this.C.preExecute();
                    break;
                }
                catch (SQLException sQLException) {
                    if (!this.hasToHandleFailover(sQLException)) break;
                    return this.a(sQLException, method, objectArray, this.C.getCurrentProtocol(), bl);
                }
            }
            case "setReadonly": {
                this.C.switchReadOnlyConnection((Boolean)objectArray[0]);
                return null;
            }
            case "getReadonly": {
                return this.C.isReadOnly();
            }
            case "inTransaction": {
                return this.C.inTransaction();
            }
            case "isMasterConnection": {
                return this.C.isMasterConnection();
            }
            case "abort": {
                this.C.preAbort();
                return null;
            }
            case "closeExplicit": {
                this.C.preClose();
                return null;
            }
            case "prepareAndExecutesComMulti": 
            case "executePreparedQuery": {
                boolean bl = (Boolean)objectArray[0];
                object = (ServerPrepareResult)objectArray[1];
                if (object == null) break;
                if (!bl && ((ServerPrepareResult)object).getUnProxiedProtocol().isMasterConnection() && !this.C.hasHostFail()) {
                    try {
                        B.trace("re-prepare query \"{}\" on replica (was temporary on master since failover)", (Object)((ServerPrepareResult)object).getSql());
                        this.C.rePrepareOnReplica((ServerPrepareResult)object, false);
                    }
                    catch (SQLException sQLException) {}
                }
                bl = this.C.isClosed();
                try {
                    return this.C.invoke(method, objectArray, ((ServerPrepareResult)object).getUnProxiedProtocol());
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    if (invocationTargetException.getTargetException() != null) {
                        if (invocationTargetException2.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)invocationTargetException2.getTargetException())) {
                            return this.a((SQLException)invocationTargetException2.getTargetException(), method, objectArray, ((ServerPrepareResult)object).getUnProxiedProtocol(), bl);
                        }
                        throw invocationTargetException2.getTargetException();
                    }
                    throw invocationTargetException2;
                }
            }
            case "prologProxy": {
                boolean bl = this.C.isClosed();
                try {
                    if (objectArray[0] != null) {
                        return this.C.invoke(method, objectArray, ((ServerPrepareResult)objectArray[0]).getUnProxiedProtocol());
                    }
                    return null;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException3 = invocationTargetException;
                    if (invocationTargetException.getTargetException() != null) {
                        if (invocationTargetException3.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)invocationTargetException3.getTargetException())) {
                            return this.a((SQLException)invocationTargetException3.getTargetException(), method, objectArray, ((ServerPrepareResult)objectArray[0]).getUnProxiedProtocol(), bl);
                        }
                        throw invocationTargetException3.getTargetException();
                    }
                    throw invocationTargetException3;
                }
            }
            case "reset": {
                this.C.reset();
                return null;
            }
        }
        return this.a(method, objectArray, false);
    }

    private Object a(Method method, Object[] objectArray, boolean bl) {
        while (true) {
            boolean bl2 = this.C.isClosed();
            try {
                return this.C.invoke(method, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                if (invocationTargetException.getTargetException() != null) {
                    if (invocationTargetException2.getTargetException() instanceof SQLException) {
                        SQLException sQLException = (SQLException)invocationTargetException2.getTargetException();
                        Protocol protocol = this.C.getCurrentProtocol();
                        Protocol protocol2 = protocol;
                        sQLException = protocol2 != null ? new SQLException(sQLException.getMessage() + "\non " + protocol2.getHostAddress().toString() + ",master=" + protocol2.isMasterConnection(), sQLException.getSQLState(), sQLException.getErrorCode(), sQLException.getCause()) : sQLException;
                        boolean bl3 = sQLException != null && sQLException.getSQLState() != null && sQLException.getSQLState().equals("70100") && 1927 == sQLException.getErrorCode();
                        if (bl3) {
                            this.a(sQLException, method, objectArray, protocol, bl2);
                            return null;
                        }
                        if (this.hasToHandleFailover(sQLException)) {
                            return this.a(sQLException, method, objectArray, protocol, bl2);
                        }
                        if (sQLException.getErrorCode() == 1290 && !bl && protocol != null && protocol.isMasterConnection() && !protocol.checkIfMaster()) {
                            boolean bl4;
                            bl = protocol.inTransaction();
                            this.lock.lock();
                            try {
                                protocol.close();
                                bl4 = this.C.primaryFail(null, null, (boolean)false, (boolean)bl2).isReconnected;
                            }
                            finally {
                                this.lock.unlock();
                            }
                            if (bl4 && !bl) {
                                bl = true;
                                continue;
                            }
                            return this.a(sQLException, method, objectArray, this.C.getCurrentProtocol(), bl2);
                        }
                    }
                    throw invocationTargetException2.getTargetException();
                }
                throw invocationTargetException2;
            }
            break;
        }
    }

    private Object a(SQLException sQLException, Method object, Object[] objectArray, Protocol protocol, boolean bl) {
        HostAddress hostAddress = null;
        boolean bl2 = true;
        if (protocol != null) {
            hostAddress = protocol.getHostAddress();
            bl2 = protocol.isMasterConnection();
        }
        object = this.C.handleFailover(sQLException, (Method)object, objectArray, protocol, bl);
        if (((HandleErrorResult)object).mustThrowError) {
            this.C.throwFailoverMessage(hostAddress, bl2, sQLException, ((HandleErrorResult)object).isReconnected);
        }
        return ((HandleErrorResult)object).resultObject;
    }

    public boolean hasToHandleFailover(SQLException sQLException) {
        return sQLException.getSQLState() != null && (sQLException.getSQLState().startsWith("08") || sQLException.getSQLState().equals("70100") && 1927 == sQLException.getErrorCode());
    }

    public void reconnect() {
        try {
            this.C.reconnect();
            return;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.INSTANCE.create(sQLException);
        }
    }

    public Listener getListener() {
        return this.C;
    }
}

