/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.dao.Results;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl.MastersReplicasListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AuroraProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ReconnectDuringTransactionException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;

public class AuroraListener
extends MastersReplicasListener {
    private static final Logger a = Logger.getLogger(AuroraListener.class.getName());
    private final Pattern b;
    private final HostAddress c;
    private String d;

    public AuroraListener(UrlParser object, GlobalStateInfo object2) {
        HostAddress hostAddress;
        block5: {
            super((UrlParser)object, (GlobalStateInfo)object2);
            this.b = Pattern.compile("(.+)\\.(cluster-|cluster-ro-)?([a-zA-Z0-9]+\\.[a-zA-Z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
            this.d = null;
            object = this;
            for (HostAddress hostAddress2 : ((AuroraListener)object).hostAddresses) {
                object2 = ((AuroraListener)object).b.matcher(hostAddress2.host);
                if (((Matcher)object2).find()) {
                    if (((AuroraListener)object).d != null) {
                        if (!((AuroraListener)object).d.equalsIgnoreCase(((Matcher)object2).group(3))) {
                            throw new SQLException("Connection string must contain only one aurora cluster. '" + hostAddress2.host + "' doesn't correspond to DNS prefix '" + ((AuroraListener)object).d + "'");
                        }
                    } else {
                        ((AuroraListener)object).d = ((Matcher)object2).group(3);
                    }
                    if (((Matcher)object2).group(2) == null || ((Matcher)object2).group(2).isEmpty()) continue;
                    hostAddress = hostAddress2;
                    break block5;
                }
                if (((AuroraListener)object).d != null || !hostAddress2.host.contains(".") || Utils.isIPv4(hostAddress2.host) || Utils.isIPv6(hostAddress2.host)) continue;
                ((AuroraListener)object).d = hostAddress2.host.substring(hostAddress2.host.indexOf(".") + 1);
            }
            hostAddress = null;
        }
        ((AuroraListener)object).c = hostAddress;
    }

    private HostAddress c() {
        for (HostAddress hostAddress : this.hostAddresses) {
            Matcher matcher = this.b.matcher(hostAddress.host);
            if (matcher.find()) {
                if (this.d != null) {
                    if (!this.d.equalsIgnoreCase(matcher.group(3))) {
                        throw new SQLException("Connection string must contain only one aurora cluster. '" + hostAddress.host + "' doesn't correspond to DNS prefix '" + this.d + "'");
                    }
                } else {
                    this.d = matcher.group(3);
                }
                if (matcher.group(2) == null || matcher.group(2).isEmpty()) continue;
                return hostAddress;
            }
            if (this.d != null || !hostAddress.host.contains(".") || Utils.isIPv4(hostAddress.host) || Utils.isIPv6(hostAddress.host)) continue;
            this.d = hostAddress.host.substring(hostAddress.host.indexOf(".") + 1);
        }
        return null;
    }

    public String getClusterDnsSuffix() {
        return this.d;
    }

    public HostAddress getClusterHostAddress() {
        return this.c;
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) {
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlyReplica() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlyReplica() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>(this.hostAddresses);
        linkedList.removeAll(this.getBlacklistKeys());
        Collections.shuffle(linkedList);
        LinkedList<HostAddress> linkedList2 = new LinkedList<HostAddress>(this.getBlacklistKeys());
        linkedList2.retainAll(this.hostAddresses);
        Collections.shuffle(linkedList2);
        linkedList.addAll(linkedList2);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            linkedList.remove(this.masterProtocol.getHostAddress());
            linkedList.add(this.masterProtocol.getHostAddress());
        }
        if (!this.isSecondaryHostFail() && this.secondaryProtocol != null) {
            linkedList.remove(this.secondaryProtocol.getHostAddress());
            linkedList.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.hostAddresses.size() <= 1) {
            searchFilter = new SearchFilter(true, false);
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                AuroraListener auroraListener = this;
                AuroraProtocol.loop(auroraListener, auroraListener.globalInfo, linkedList, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {}
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null && (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null));
        }
        if (this.getCurrentProtocol() != null && !this.getCurrentProtocol().isClosed()) {
            AuroraListener auroraListener = this;
            auroraListener.retrieveAllEndpointsAndSet(auroraListener.getCurrentProtocol());
        }
        if (searchFilter.isInitialConnection() && this.masterProtocol == null && !this.currentReadOnlyAsked) {
            this.currentProtocol = this.secondaryProtocol;
            this.currentReadOnlyAsked = true;
        }
    }

    public void retrieveAllEndpointsAndSet(Protocol object) {
        if (this.d != null) {
            Object object2 = this.a((Protocol)object);
            int n = object.getPort();
            object = this;
            ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (string == null) continue;
                arrayList.add(new HostAddress(string, n, null));
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(((AuroraListener)object).urlParser.getHostAddresses());
            }
            ((AuroraListener)object).hostAddresses = arrayList;
        }
    }

    private List<String> a(Protocol protocol) {
        ArrayList<String> arrayList;
        block9: {
            arrayList = new ArrayList<String>();
            try {
                this.proxy.lock.lock();
                try {
                    Object object = new Results();
                    protocol.executeQuery(false, (Results)object, "select server_id, session_id from information_schema.replica_host_status where last_update_timestamp > now() - INTERVAL 3 MINUTE");
                    ((Results)object).commandEnd();
                    object = ((Results)object).getResultSet();
                    while (object.next()) {
                        arrayList.add(object.getString(1) + "." + this.d);
                    }
                    Collections.shuffle(arrayList);
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            catch (SQLException sQLException) {
                a.warning("SQL exception occurred: " + sQLException.getMessage());
                if (!protocol.getProxy().hasToHandleFailover(sQLException)) break block9;
                if (this.masterProtocol == null || this.masterProtocol.equals(protocol)) {
                    this.setMasterHostFail();
                } else if (this.secondaryProtocol.equals(protocol)) {
                    this.setSecondaryHostFail();
                }
                this.addToBlacklist(protocol.getHostAddress());
                this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail()));
            }
        }
        return arrayList;
    }

    private void a(List<String> object, int n) {
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string == null) continue;
            arrayList.add(new HostAddress(string, n, null));
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(this.urlParser.getHostAddresses());
        }
        this.hostAddresses = arrayList;
    }

    public HostAddress searchByStartName(Protocol protocol, List<HostAddress> list) {
        if (!this.isSecondaryHostFail()) {
            HostAddress hostAddress;
            block9: {
                int n = 3;
                hostAddress = null;
                do {
                    try {
                        hostAddress = this.a(protocol, list);
                    }
                    catch (SQLException sQLException) {
                        if (!this.proxy.hasToHandleFailover(sQLException) || !this.setSecondaryHostFail()) continue;
                        this.addToBlacklist(protocol.getHostAddress());
                        return null;
                    }
                } while (hostAddress == null && --n > 0);
                if (hostAddress == null && this.getClusterHostAddress() != null) {
                    AuroraProtocol auroraProtocol = AuroraProtocol.getNewProtocol(this.getProxy(), this.globalInfo, this.getUrlParser());
                    auroraProtocol.setHostAddress(this.getClusterHostAddress());
                    try {
                        auroraProtocol.connect();
                        if (auroraProtocol.isMasterConnection()) {
                            auroraProtocol.setMustBeMasterConnection(true);
                            this.foundActiveMaster(auroraProtocol);
                        } else {
                            auroraProtocol.setMustBeMasterConnection(false);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!this.proxy.hasToHandleFailover(sQLException)) break block9;
                        this.addToBlacklist(auroraProtocol.getHostAddress());
                    }
                }
            }
            return hostAddress;
        }
        return null;
    }

    private HostAddress a(Protocol protocol, List<HostAddress> list) {
        String string;
        Object object;
        Object object2;
        this.proxy.lock.lock();
        try {
            object2 = new Results();
            protocol.executeQuery(false, (Results)object2, "select server_id from information_schema.replica_host_status where session_id = 'MASTER_SESSION_ID' and last_update_timestamp > now() - INTERVAL 3 MINUTE ORDER BY last_update_timestamp DESC LIMIT 1");
            ((Results)object2).commandEnd();
            object = ((Results)object2).getResultSet();
            if (!object.isBeforeFirst()) {
                HostAddress hostAddress = null;
                return hostAddress;
            }
            object.next();
            string = object.getString(1);
        }
        finally {
            this.proxy.lock.unlock();
        }
        if (string != null) {
            for (HostAddress hostAddress : list) {
                object2 = this.b.matcher(hostAddress.host);
                if (!hostAddress.host.startsWith(string) || ((Matcher)object2).find()) continue;
                return hostAddress;
            }
            if (this.d != null || !protocol.getHost().contains(".")) {
                return null;
            }
            this.d = protocol.getHost().substring(protocol.getHost().indexOf(".") + 1);
            object = new HostAddress(string + "." + this.d, protocol.getPort(), null);
            list.add((HostAddress)object);
            if (!this.hostAddresses.contains(object)) {
                this.hostAddresses.add(object);
            }
            return object;
        }
        return null;
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (!this.isMasterHostFail()) {
            try {
                if (this.masterProtocol != null && !this.masterProtocol.checkIfMaster()) {
                    this.setMasterHostFail();
                    if (this.isSecondaryHostFail()) {
                        AuroraListener auroraListener = this;
                        auroraListener.foundActiveSecondary(auroraListener.masterProtocol);
                    }
                    return true;
                }
            }
            catch (SQLException sQLException) {
                block22: {
                    try {
                        this.masterProtocol.ping();
                    }
                    catch (SQLException sQLException2) {
                        this.proxy.lock.lock();
                        try {
                            this.masterProtocol.close();
                        }
                        finally {
                            this.proxy.lock.unlock();
                        }
                        if (!this.setMasterHostFail()) break block22;
                        AuroraListener auroraListener = this;
                        auroraListener.addToBlacklist(auroraListener.masterProtocol.getHostAddress());
                    }
                }
                return true;
            }
        }
        if (!this.isSecondaryHostFail()) {
            try {
                if (this.secondaryProtocol != null && this.secondaryProtocol.checkIfMaster()) {
                    this.setSecondaryHostFail();
                    if (this.isMasterHostFail()) {
                        AuroraListener auroraListener = this;
                        auroraListener.foundActiveMaster(auroraListener.secondaryProtocol);
                    }
                    return true;
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.secondaryProtocol.ping();
                }
                catch (Exception exception) {
                    this.proxy.lock.lock();
                    try {
                        this.secondaryProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    if (this.setSecondaryHostFail()) {
                        AuroraListener auroraListener = this;
                        auroraListener.addToBlacklist(auroraListener.secondaryProtocol.getHostAddress());
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

