/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.AbstractMastersListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.HandleErrorResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread.FailoverLoop;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MasterProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ReconnectDuringTransactionException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;

public class MastersFailoverListener
extends AbstractMastersListener {
    private static final Logger a = LoggerFactory.getLogger(MastersFailoverListener.class);
    private final HaMode b;

    public MastersFailoverListener(UrlParser urlParser, GlobalStateInfo globalStateInfo) {
        super(urlParser, globalStateInfo);
        this.b = urlParser.getHaMode();
        this.setMasterHostFail();
    }

    @Override
    public void initializeConnection() {
        super.initializeConnection();
        this.currentProtocol = null;
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.resetMasterFailoverData();
    }

    @Override
    public void preExecute() {
        this.lastQueryNanos = System.nanoTime();
        if (this.currentProtocol != null && this.currentProtocol.isClosed()) {
            this.preAutoReconnect();
        }
    }

    @Override
    public void preClose() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                MastersFailoverListener mastersFailoverListener = this;
                mastersFailoverListener.closeConnection(mastersFailoverListener.currentProtocol);
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public long getServerThreadId() {
        return this.currentProtocol.getServerThreadId();
    }

    @Override
    public void preAbort() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                MastersFailoverListener mastersFailoverListener = this;
                mastersFailoverListener.abortConnection(mastersFailoverListener.currentProtocol);
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public HandleErrorResult primaryFail(Method object, Object[] objectArray, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.currentProtocol != null && this.currentProtocol.inTransaction();
        if (this.currentProtocol.isConnected()) {
            this.currentProtocol.close();
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, false));
            this.handleFailLoop();
            if (bl) {
                return new HandleErrorResult(true, false);
            }
            if (bl2 || !bl3 && this.isQueryRelaunchable((Method)object, objectArray)) {
                a.info("Connection to master lost, new master {} found, query type permit to be re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress());
                return this.relaunchOperation((Method)object, objectArray);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception exception) {
            object = exception;
            if (exception.getCause() != null && this.proxy.hasToHandleFailover((SQLException)((Throwable)object).getCause()) && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) {
        this.proxy.lock.lock();
        try {
            if (!(searchFilter.isInitialConnection() || !this.isExplicitClosed() && this.isMasterHostFail())) {
                return;
            }
            this.currentConnectionAttempts.incrementAndGet();
            this.resetOldsBlackListHosts();
            LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
            if (HaMode.LOADBALANCE.equals((Object)this.b)) {
                linkedList.removeAll(this.getBlacklistKeys());
                Collections.shuffle(linkedList);
                LinkedList<HostAddress> linkedList2 = new LinkedList<HostAddress>(this.getBlacklistKeys());
                linkedList2.retainAll(this.urlParser.getHostAddresses());
                Collections.shuffle(linkedList2);
                linkedList.addAll(linkedList2);
            } else {
                linkedList.removeAll(this.getBlacklistKeys());
                linkedList.addAll(this.getBlacklistKeys());
                linkedList.retainAll(this.urlParser.getHostAddresses());
            }
            if (this.currentProtocol != null && !this.isMasterHostFail()) {
                linkedList.remove(this.currentProtocol.getHostAddress());
            }
            MastersFailoverListener mastersFailoverListener = this;
            MasterProtocol.loop(mastersFailoverListener, mastersFailoverListener.globalInfo, linkedList, searchFilter);
            if (!this.isMasterHostFail()) {
                FailoverLoop.removeListener(this);
            }
            this.resetMasterFailoverData();
            return;
        }
        finally {
            this.proxy.lock.unlock();
        }
    }

    @Override
    public void switchReadOnlyConnection(Boolean bl) {
        if (this.urlParser.getOptions().assureReadOnly && this.currentReadOnlyAsked != bl) {
            this.proxy.lock.lock();
            try {
                if (this.currentReadOnlyAsked != bl) {
                    this.currentReadOnlyAsked = bl;
                    this.setSessionReadOnly(bl, this.currentProtocol);
                }
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) {
        if (this.isExplicitClosed()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        MastersFailoverListener mastersFailoverListener = this;
        mastersFailoverListener.syncConnection(mastersFailoverListener.currentProtocol, protocol);
        this.proxy.lock.lock();
        try {
            if (this.currentProtocol != null && !this.currentProtocol.isClosed()) {
                this.currentProtocol.close();
            }
            this.currentProtocol = protocol;
        }
        finally {
            this.proxy.lock.unlock();
        }
        this.resetMasterFailoverData();
        FailoverLoop.removeListener(this);
    }

    @Override
    public void reconnect() {
        boolean bl = this.currentProtocol != null && this.currentProtocol.inTransaction();
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.handleFailLoop();
        if (bl) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
                return;
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.currentProtocol != null && this.currentProtocol.isConnected();
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.currentProtocol != null) {
            MastersFailoverListener mastersFailoverListener = this;
            mastersFailoverListener.pingMasterProtocol(mastersFailoverListener.currentProtocol);
        }
        return false;
    }

    @Override
    public void rePrepareOnReplica(ServerPrepareResult serverPrepareResult, boolean bl) {
    }

    @Override
    public void reset() {
        if (!this.isMasterHostFail()) {
            this.currentProtocol.reset();
        }
    }
}

