/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbStatement;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.AbstractMastersReplicasListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.HandleErrorResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread.FailoverLoop;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread.TerminableRunnable;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.tools.SearchFilter;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MastersReplicasProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.SqlStates;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ReconnectDuringTransactionException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.DynamicSizedSchedulerInterface;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MastersReplicasListener
extends AbstractMastersReplicasListener {
    private static final AtomicInteger a = new AtomicInteger();
    private static final Logger b = LoggerFactory.getLogger(MastersReplicasListener.class);
    private static DynamicSizedSchedulerInterface c;
    protected Protocol masterProtocol;
    protected Protocol secondaryProtocol;
    protected List<HostAddress> hostAddresses;

    public MastersReplicasListener(UrlParser urlParser, GlobalStateInfo globalStateInfo) {
        super(urlParser, globalStateInfo);
        if (c.isTerminated()) {
            MastersReplicasListener.c();
        }
        a.incrementAndGet();
        this.masterProtocol = null;
        this.secondaryProtocol = null;
        this.hostAddresses = urlParser.getHostAddresses();
        this.setMasterHostFail();
        this.setSecondaryHostFail();
    }

    private static void c() {
        c = SchedulerServiceProviderHolder.getScheduler(1, "MariaDb-failover", 8);
        c.scheduleWithFixedDelay(new Runnable(){
            private final ArrayDeque<FailoverLoop> a = new ArrayDeque(8);

            @Override
            public final void run() {
                block5: {
                    int n = Math.min(8, a.get() / 5 + 1);
                    int n2 = n - this.a.size();
                    if (n2 == 0) break block5;
                    c.setPoolSize(n);
                    if (n2 > 0) {
                        while (n2 > 0) {
                            this.a.add(new FailoverLoop(c));
                            --n2;
                        }
                    } else {
                        Object object;
                        Object object2 = new ArrayList<Object>(-n2);
                        while (n2 < 0) {
                            object = this.a.remove();
                            ((TerminableRunnable)object).unscheduleTask();
                            object2.add(object);
                            ++n2;
                        }
                        object = object2.iterator();
                        while (object.hasNext()) {
                            object2 = (FailoverLoop)object.next();
                            ((TerminableRunnable)object2).blockTillTerminated();
                        }
                    }
                }
            }
        }, 1L, 2L, TimeUnit.MINUTES);
    }

    @Override
    protected void removeListenerFromSchedulers() {
        super.removeListenerFromSchedulers();
        FailoverLoop.removeListener(this);
        a.addAndGet(-1);
    }

    @Override
    public void initializeConnection() {
        super.initializeConnection();
        try {
            this.reconnectFailedConnection(new SearchFilter(true));
            return;
        }
        catch (SQLException sQLException) {
            this.checkInitialConnection(sQLException);
            return;
        }
    }

    @Override
    public boolean isClosed() {
        if (this.currentProtocol != null) {
            return this.currentProtocol.isClosed();
        }
        if (this.urlParser.getOptions().allowMasterDownConnection) {
            return this.secondaryProtocol.isClosed();
        }
        return false;
    }

    @Override
    public Object invoke(Method method, Object[] objectArray) {
        if (this.currentProtocol == null) {
            block6: {
                try {
                    this.reconnectFailedConnection(new SearchFilter(true, false));
                    this.handleFailLoop();
                }
                catch (SQLException sQLException) {
                    FailoverLoop.removeListener(this);
                    throw new InvocationTargetException(new SQLNonTransientConnectionException("No master connection available (only read-only)\n(Possible because option allowMasterDownConnection is set)", SqlStates.CONNECTION_EXCEPTION.getSqlState()));
                }
                if (!this.isMasterHostFail()) {
                    try {
                        MastersReplicasListener mastersReplicasListener = this;
                        mastersReplicasListener.syncConnection(mastersReplicasListener.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                        return method.invoke((Object)this.currentProtocol, objectArray);
                    }
                    catch (SQLException sQLException) {
                        if (!this.setMasterHostFail()) break block6;
                        MastersReplicasListener mastersReplicasListener = this;
                        mastersReplicasListener.addToBlacklist(mastersReplicasListener.masterProtocol.getHostAddress());
                    }
                }
            }
            throw new InvocationTargetException(new SQLNonTransientConnectionException("No master connection available (only read-only)\n(Possible because option allowMasterDownConnection is set)", SqlStates.CONNECTION_EXCEPTION.getSqlState()));
        }
        return method.invoke((Object)this.currentProtocol, objectArray);
    }

    @Override
    public boolean versionGreaterOrEqual(int n, int n2, int n3) {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        if (protocol == null) {
            return false;
        }
        return protocol.versionGreaterOrEqual(n, n2, n3);
    }

    @Override
    public boolean isServerMariaDb() {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        return protocol != null && protocol.isServerMariaDb();
    }

    @Override
    public boolean sessionStateAware() {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        if (protocol == null) {
            return false;
        }
        return protocol.sessionStateAware();
    }

    @Override
    public String getCatalog() {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        if (protocol == null) {
            return this.urlParser.getDatabase();
        }
        return protocol.getCatalog();
    }

    @Override
    public int getMajorServerVersion() {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        if (protocol == null) {
            return 5;
        }
        return protocol.getMajorServerVersion();
    }

    @Override
    public boolean isMasterConnection() {
        return this.currentProtocol == null || this.currentProtocol.isMasterConnection();
    }

    @Override
    public int getTimeout() {
        if (this.currentProtocol != null) {
            return this.currentProtocol.getTimeout();
        }
        if (this.urlParser.getOptions().socketTimeout == null) {
            return 0;
        }
        return this.urlParser.getOptions().socketTimeout;
    }

    @Override
    public void prolog(long l, MariaDbConnection mariaDbConnection, MariaDbStatement mariaDbStatement) {
        if (this.currentProtocol != null) {
            this.currentProtocol.prolog(l, true, mariaDbConnection, mariaDbStatement);
        }
    }

    @Override
    public boolean noBackslashEscapes() {
        Protocol protocol = this.currentProtocol != null ? this.currentProtocol : this.secondaryProtocol;
        return protocol.noBackslashEscapes();
    }

    @Override
    public long getServerThreadId() {
        if (this.currentProtocol == null) {
            return -1L;
        }
        return this.currentProtocol.getServerThreadId();
    }

    protected void checkInitialConnection(SQLException sQLException) {
        Protocol protocol;
        if (this.isSecondaryHostFail() && (protocol = (Protocol)this.waitNewSecondaryProtocol.getAndSet(null)) != null) {
            this.secondaryProtocol = protocol;
            if (this.urlParser.getOptions().assureReadOnly) {
                this.setSessionReadOnly(true, this.secondaryProtocol);
            }
            if (this.currentReadOnlyAsked) {
                this.currentProtocol = protocol;
            }
            this.resetSecondaryFailoverData();
        }
        if (this.isMasterHostFail() && (protocol = (Protocol)this.waitNewMasterProtocol.getAndSet(null)) != null) {
            this.masterProtocol = protocol;
            if (!this.currentReadOnlyAsked || this.isSecondaryHostFail()) {
                this.currentProtocol = protocol;
            }
            this.resetMasterFailoverData();
        }
        if (this.masterProtocol == null || !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
            if (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null) {
                MastersReplicasListener mastersReplicasListener = this;
                mastersReplicasListener.throwFailoverMessage(mastersReplicasListener.masterProtocol != null ? this.masterProtocol.getHostAddress() : null, true, sQLException, false);
                return;
            }
        } else {
            this.resetMasterFailoverData();
            if (this.isSecondaryHostFail()) {
                this.handleFailLoop();
            }
        }
    }

    @Override
    public void preClose() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                MastersReplicasListener mastersReplicasListener = this;
                mastersReplicasListener.closeConnection(mastersReplicasListener.waitNewSecondaryProtocol.getAndSet(null));
                MastersReplicasListener mastersReplicasListener2 = this;
                mastersReplicasListener2.closeConnection(mastersReplicasListener2.waitNewMasterProtocol.getAndSet(null));
                MastersReplicasListener mastersReplicasListener3 = this;
                mastersReplicasListener3.closeConnection(mastersReplicasListener3.masterProtocol);
                MastersReplicasListener mastersReplicasListener4 = this;
                mastersReplicasListener4.closeConnection(mastersReplicasListener4.secondaryProtocol);
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void preAbort() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                MastersReplicasListener mastersReplicasListener = this;
                mastersReplicasListener.abortConnection(mastersReplicasListener.waitNewSecondaryProtocol.getAndSet(null));
                MastersReplicasListener mastersReplicasListener2 = this;
                mastersReplicasListener2.abortConnection(mastersReplicasListener2.waitNewMasterProtocol.getAndSet(null));
                MastersReplicasListener mastersReplicasListener3 = this;
                mastersReplicasListener3.abortConnection(mastersReplicasListener3.masterProtocol);
                MastersReplicasListener mastersReplicasListener4 = this;
                mastersReplicasListener4.abortConnection(mastersReplicasListener4.secondaryProtocol);
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void preExecute() {
        this.lastQueryNanos = System.nanoTime();
        this.checkWaitingConnection();
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked && !this.currentProtocol.isMasterConnection())) {
            this.preAutoReconnect();
        }
    }

    @Override
    public boolean isValid(int n) {
        if (this.currentProtocol != null) {
            if (this.currentProtocol.isMasterConnection()) {
                boolean bl = this.currentProtocol.isValid(n);
                if (this.secondaryProtocol != null) {
                    try {
                        n = this.secondaryProtocol.isValid(n) ? 1 : 0;
                        if (!bl && this.urlParser.getOptions().allowMasterDownConnection && n != 0) {
                            this.setMasterHostFail();
                            return true;
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                return bl;
            }
            boolean bl = this.currentProtocol.isValid(n);
            if (this.masterProtocol != null) {
                try {
                    this.masterProtocol.isValid(n);
                }
                catch (SQLException sQLException) {}
            }
            return bl;
        }
        return false;
    }

    public void checkWaitingConnection() {
        Protocol protocol;
        if (this.isSecondaryHostFail()) {
            this.proxy.lock.lock();
            try {
                protocol = this.waitNewSecondaryProtocol.getAndSet(null);
                if (protocol != null && this.b(protocol)) {
                    this.lockAndSwitchSecondary(protocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        if (this.isMasterHostFail()) {
            this.proxy.lock.lock();
            try {
                protocol = this.waitNewMasterProtocol.getAndSet(null);
                if (protocol != null && this.pingMasterProtocol(protocol)) {
                    this.lockAndSwitchMaster(protocol);
                }
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) {
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlyReplica() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlyReplica() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>(this.hostAddresses);
        linkedList.removeAll(this.getBlacklistKeys());
        Collections.shuffle(linkedList);
        LinkedList<HostAddress> linkedList2 = new LinkedList<HostAddress>(this.getBlacklistKeys());
        linkedList2.retainAll(this.hostAddresses);
        Collections.shuffle(linkedList2);
        linkedList.addAll(linkedList2);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            linkedList.remove(this.masterProtocol.getHostAddress());
            linkedList.add(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            linkedList.remove(this.secondaryProtocol.getHostAddress());
            linkedList.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                MastersReplicasListener mastersReplicasListener = this;
                MastersReplicasProtocol.loop(mastersReplicasListener, mastersReplicasListener.globalInfo, linkedList, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {}
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null && (!this.urlParser.getOptions().allowMasterDownConnection || this.secondaryProtocol == null));
            if (searchFilter.isInitialConnection() && this.masterProtocol == null && this.currentReadOnlyAsked) {
                this.currentProtocol = this.secondaryProtocol;
                this.currentReadOnlyAsked = true;
            }
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) {
        block5: {
            block4: {
                if (!this.isMasterHostFail()) break block4;
                if (this.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                if (this.waitNewMasterProtocol.compareAndSet(null, protocol)) break block5;
            }
            protocol.close();
        }
    }

    public void lockAndSwitchMaster(Protocol protocol) {
        if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
            this.masterProtocol.close();
        }
        if (!this.currentReadOnlyAsked || this.isSecondaryHostFail()) {
            if (this.currentProtocol != null) {
                try {
                    MastersReplicasListener mastersReplicasListener = this;
                    mastersReplicasListener.syncConnection(mastersReplicasListener.currentProtocol, protocol);
                }
                catch (Exception exception) {}
            }
            this.currentProtocol = protocol;
        }
        boolean bl = this.masterProtocol != null && this.masterProtocol.inTransaction();
        this.masterProtocol = protocol;
        this.resetMasterFailoverData();
        if (bl) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void foundActiveSecondary(Protocol protocol) {
        block10: {
            block9: {
                if (!this.isSecondaryHostFail()) break block9;
                if (this.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                if (this.proxy.lock.tryLock()) {
                    try {
                        this.lockAndSwitchSecondary(protocol);
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                }
                if (this.waitNewSecondaryProtocol.compareAndSet(null, protocol)) break block10;
            }
            protocol.close();
        }
    }

    public void lockAndSwitchSecondary(Protocol protocol) {
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
            this.secondaryProtocol.close();
        }
        if (this.currentReadOnlyAsked || this.urlParser.getOptions().failOnReadOnly && !this.currentReadOnlyAsked && this.isMasterHostFail()) {
            if (this.currentProtocol != null) {
                try {
                    MastersReplicasListener mastersReplicasListener = this;
                    mastersReplicasListener.syncConnection(mastersReplicasListener.currentProtocol, protocol);
                }
                catch (Exception exception) {}
            }
            this.currentProtocol = protocol;
        }
        this.secondaryProtocol = protocol;
        if (this.urlParser.getOptions().assureReadOnly) {
            this.setSessionReadOnly(true, this.secondaryProtocol);
        }
        this.resetSecondaryFailoverData();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void switchReadOnlyConnection(Boolean var1_1) {
        block23: {
            block22: {
                block25: {
                    block24: {
                        this.checkWaitingConnection();
                        if (this.currentReadOnlyAsked == var1_1) break block23;
                        this.proxy.lock.lock();
                        if (this.currentReadOnlyAsked == var1_1) {
                            return;
                        }
                        this.currentReadOnlyAsked = var1_1;
                        if (!this.currentReadOnlyAsked) break block24;
                        if (this.currentProtocol == null) {
                            this.currentProtocol = this.secondaryProtocol;
                            break block22;
                        }
                        if (!this.currentProtocol.isMasterConnection()) break block22;
                        if (this.isSecondaryHostFail()) ** GOTO lbl23
                        try {
                            v0 = this;
                            v0.syncConnection(v0.masterProtocol, this.secondaryProtocol);
                            this.currentProtocol = this.secondaryProtocol;
                            return;
                        }
                        catch (SQLException v1) {
                            if (this.setSecondaryHostFail()) {
                                v2 = this;
                                v2.addToBlacklist(v2.secondaryProtocol.getHostAddress());
                            }
lbl23:
                            // 4 sources

                            FailoverLoop.addListener(this);
                            break block22;
                        }
                    }
                    if (this.currentProtocol == null) {
                        this.currentProtocol = this.masterProtocol;
                        break block22;
                    }
                    if (this.currentProtocol.isMasterConnection()) break block22;
                    if (this.isMasterHostFail()) break block25;
                    try {
                        v3 = this;
                        v3.syncConnection(v3.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                        return;
                    }
                    catch (SQLException v4) {
                        if (this.setMasterHostFail()) {
                            v5 = this;
                            v5.addToBlacklist(v5.masterProtocol.getHostAddress());
                        }
                        ** GOTO lbl-1000
                    }
                }
                if (!this.urlParser.getOptions().allowMasterDownConnection) ** GOTO lbl-1000
                this.currentProtocol = null;
                return;
lbl-1000:
                // 2 sources

                {
                    try {
                        this.reconnectFailedConnection(new SearchFilter(true, false));
                        this.handleFailLoop();
                    }
                    catch (SQLException v6) {
                        FailoverLoop.removeListener(this);
                        var2_3 = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
                        this.throwFailoverMessage(var2_3, true, new SQLException("master connection failed"), false);
                    }
                    if (!this.isMasterHostFail()) {
                        try {
                            v7 = this;
                            v7.syncConnection(v7.secondaryProtocol, this.masterProtocol);
                            this.currentProtocol = this.masterProtocol;
                        }
                        catch (SQLException v8) {
                            if (this.setMasterHostFail()) {
                                v9 = this;
                                v9.addToBlacklist(v9.masterProtocol.getHostAddress());
                            }
                            break block22;
                        }
                    }
                    this.currentReadOnlyAsked = var1_1 == false;
                    var1_1 = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
                    this.throwFailoverMessage((HostAddress)var1_1, true, new SQLException("master connection failed"), false);
                }
            }
            return;
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public HandleErrorResult primaryFail(Method method, Object[] objectArray, boolean bl, boolean bl2) {
        boolean bl3;
        block16: {
            bl2 = this.masterProtocol == null || bl2;
            boolean bl4 = bl3 = this.masterProtocol != null && this.masterProtocol.inTransaction();
            if (this.masterProtocol != null && this.masterProtocol.isConnected()) {
                this.masterProtocol.close();
            }
            if (this.urlParser.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
                try {
                    if (this.secondaryProtocol == null || !this.secondaryProtocol.ping()) break block16;
                    this.proxy.lock.lock();
                    try {
                        if (this.masterProtocol != null) {
                            MastersReplicasListener mastersReplicasListener = this;
                            mastersReplicasListener.syncConnection(mastersReplicasListener.masterProtocol, this.secondaryProtocol);
                        }
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    try {
                        return this.relaunchOperation(method, objectArray);
                    }
                    catch (Exception exception) {
                        return new HandleErrorResult();
                    }
                }
                catch (Exception exception) {
                    if (!this.setSecondaryHostFail()) break block16;
                    MastersReplicasListener mastersReplicasListener = this;
                    mastersReplicasListener.a(mastersReplicasListener.secondaryProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly));
            this.handleFailLoop();
            if (this.currentProtocol != null) {
                if (bl) {
                    return new HandleErrorResult(true, false);
                }
                if (this.currentReadOnlyAsked || bl2 || !bl3 && this.isQueryRelaunchable(method, objectArray)) {
                    b.info("Connection to master lost, new master {}, conn={} found, query type permit to be re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress(), (Object)this.currentProtocol.getServerThreadId());
                    return this.relaunchOperation(method, objectArray);
                }
                return new HandleErrorResult(true);
            }
            this.setMasterHostFail();
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.getCause() != null && this.proxy.hasToHandleFailover((SQLException)exception2.getCause()) && this.currentProtocol != null && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
            this.setMasterHostFail();
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    private void a(Protocol protocol) {
        this.addToBlacklist(protocol.getHostAddress());
        if (protocol.isConnected()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
                return;
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnect() {
        SearchFilter searchFilter;
        boolean bl = false;
        if (this.currentReadOnlyAsked) {
            searchFilter = new SearchFilter(true, true);
        } else {
            bl = this.masterProtocol != null && this.masterProtocol.inTransaction();
            searchFilter = new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly);
        }
        this.reconnectFailedConnection(searchFilter);
        this.handleFailLoop();
        if (bl) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    private boolean b(Protocol protocol) {
        block3: {
            try {
                if (protocol != null && protocol.isConnected() && protocol.ping()) {
                    return true;
                }
            }
            catch (Exception exception) {
                protocol.close();
                if (!this.setSecondaryHostFail()) break block3;
                this.addToBlacklist(protocol.getHostAddress());
            }
        }
        return false;
    }

    @Override
    public HandleErrorResult secondaryFail(Method object, Object[] objectArray, boolean bl) {
        block18: {
            this.proxy.lock.lock();
            try {
                MastersReplicasListener mastersReplicasListener = this;
                if (mastersReplicasListener.b(mastersReplicasListener.secondaryProtocol)) {
                    object = this.relaunchOperation((Method)object, objectArray);
                    return object;
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null || !this.masterProtocol.isValid(1000)) break block18;
                    MastersReplicasListener mastersReplicasListener = this;
                    mastersReplicasListener.syncConnection(mastersReplicasListener.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    b.info("Connection to replica lost, using master connection, query is re-execute on master server without throwing exception");
                    return this.relaunchOperation((Method)object, objectArray);
                }
                catch (Exception exception) {
                    if (!this.setMasterHostFail()) break block18;
                    MastersReplicasListener mastersReplicasListener = this;
                    mastersReplicasListener.a(mastersReplicasListener.masterProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true));
            this.handleFailLoop();
            if (this.isSecondaryHostFail()) {
                MastersReplicasListener mastersReplicasListener = this;
                mastersReplicasListener.syncConnection(mastersReplicasListener.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            if (bl) {
                return new HandleErrorResult(true, false);
            }
            b.info("Connection to replica lost, new replica {}, conn={} found, query is re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress(), (Object)this.currentProtocol.getServerThreadId());
            return this.relaunchOperation((Method)object, objectArray);
        }
        catch (Exception exception) {
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
                return;
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.masterProtocol != null && this.masterProtocol.isConnected();
    }

    @Override
    public boolean inTransaction() {
        if (this.currentProtocol != null) {
            return this.currentProtocol.inTransaction();
        }
        return true;
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.masterProtocol != null) {
            MastersReplicasListener mastersReplicasListener = this;
            mastersReplicasListener.pingMasterProtocol(mastersReplicasListener.masterProtocol);
        }
        return false;
    }

    @Override
    public void rePrepareOnReplica(ServerPrepareResult serverPrepareResult, boolean bl) {
        Object object;
        if (this.isSecondaryHostFail() && (object = (Protocol)this.waitNewSecondaryProtocol.getAndSet(null)) != null) {
            this.proxy.lock.lock();
            try {
                if (this.b((Protocol)object)) {
                    this.lockAndSwitchSecondary((Protocol)object);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            object = this.secondaryProtocol.prepare(serverPrepareResult.getSql(), bl);
            try {
                ((ServerPrepareResult)object).getUnProxiedProtocol().releasePrepareStatement((ServerPrepareResult)object);
            }
            catch (SQLException sQLException) {}
            serverPrepareResult.failover(((ServerPrepareResult)object).getStatementId(), this.secondaryProtocol);
        }
    }

    public List<HostAddress> connectedHosts() {
        Protocol protocol;
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>();
        if (this.isMasterHostFail()) {
            protocol = (Protocol)this.waitNewMasterProtocol.get();
            if (protocol != null) {
                arrayList.add(protocol.getHostAddress());
            }
        } else {
            arrayList.add(this.masterProtocol.getHostAddress());
        }
        if (this.isSecondaryHostFail()) {
            protocol = (Protocol)this.waitNewSecondaryProtocol.get();
            if (protocol != null) {
                arrayList.add(protocol.getHostAddress());
            }
        } else {
            arrayList.add(this.secondaryProtocol.getHostAddress());
        }
        return arrayList;
    }

    @Override
    public void reset() {
        if (!this.isMasterHostFail()) {
            this.masterProtocol.reset();
        }
        if (!this.isSecondaryHostFail()) {
            this.secondaryProtocol.reset();
        }
    }

    static {
        MastersReplicasListener.c();
    }
}

