/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public abstract class TerminableRunnable
implements Runnable {
    private final AtomicReference<State> a = new AtomicReference<State>(State.IDLE);
    private final AtomicBoolean b = new AtomicBoolean();
    private volatile ScheduledFuture<?> c = null;

    public TerminableRunnable(ScheduledExecutorService scheduledExecutorService, long l, long l2, TimeUnit timeUnit) {
        this.c = scheduledExecutorService.scheduleWithFixedDelay(this, l, l2, timeUnit);
    }

    protected abstract void doRun();

    @Override
    public final void run() {
        if (!this.a.compareAndSet(State.IDLE, State.ACTIVE)) {
            return;
        }
        try {
            this.doRun();
            return;
        }
        finally {
            this.a.compareAndSet(State.ACTIVE, State.IDLE);
        }
    }

    public void blockTillTerminated() {
        while (!this.a.compareAndSet(State.IDLE, State.REMOVED)) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            if (!Thread.currentThread().isInterrupted()) continue;
            this.a.set(State.REMOVED);
            return;
        }
    }

    public boolean isUnschedule() {
        return this.b.get();
    }

    public void unscheduleTask() {
        if (this.b.compareAndSet(false, true)) {
            this.c.cancel(false);
            this.c = null;
        }
    }

    private static enum State {
        REMOVED,
        IDLE,
        ACTIVE;

    }
}

