/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.TraceObject;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;

public class LruTraceCache
extends LinkedHashMap<String, TraceObject> {
    private AtomicLong a = new AtomicLong();

    public LruTraceCache() {
        super(16, 1.0f, false);
    }

    public TraceObject put(TraceObject traceObject) {
        String string = this.a.incrementAndGet() + "- " + DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        return this.put(string, traceObject);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, TraceObject> entry) {
        return this.size() > 10;
    }

    public synchronized String printStack() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (!bl) {
            try {
                Map.Entry[] entryArray = this.entrySet().toArray(new Map.Entry[0]);
                Map.Entry[] entryArray2 = entryArray;
                entryArray2 = entryArray;
                int n = entryArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object = entryArray2[i];
                    TraceObject traceObject = (TraceObject)object.getValue();
                    if (traceObject.getBuf() == null) continue;
                    object = (String)object.getKey();
                    String string = "";
                    switch (traceObject.getIndicatorFlag()) {
                        case 2: {
                            string = " (compressed protocol - packet not compressed)";
                            break;
                        }
                        case 1: {
                            string = " (compressed protocol - packet compressed)";
                        }
                    }
                    stringBuilder.append("\nthread:").append(traceObject.getThreadId());
                    if (traceObject.isSend()) {
                        stringBuilder.append(" send at -exchange:");
                    } else {
                        stringBuilder.append(" read at -exchange:");
                    }
                    stringBuilder.append((String)object).append(string).append(Utils.hexdump(traceObject.getBuf()));
                }
                bl = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.clear();
        return stringBuilder.toString();
    }

    public synchronized void clearMemory() {
        try {
            Object object = this.values();
            object = object.iterator();
            while (object.hasNext()) {
                TraceObject traceObject = (TraceObject)object.next();
                traceObject.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        this.clear();
    }
}

