/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output;

import java.io.OutputStream;
import java.util.Arrays;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.TraceObject;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.AbstractPacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class StandardPacketOutputStream
extends AbstractPacketOutputStream {
    private static final Logger a = LoggerFactory.getLogger(StandardPacketOutputStream.class);
    private static final int b = 0x1000003;
    private int c = 0x1000003;

    public StandardPacketOutputStream(OutputStream outputStream, Options options, long l) {
        super(outputStream, options.maxQuerySizeToLog, l);
    }

    @Override
    public int getMaxPacketLength() {
        return this.c;
    }

    @Override
    public void startPacket(int n) {
        this.seqNo = n;
        this.pos = 4;
        this.cmdLength = 0L;
    }

    @Override
    public void setMaxAllowedPacket(int n) {
        this.maxAllowedPacket = n;
        this.c = Math.min(0x1000003, n + 4);
    }

    @Override
    public int initialPacketPos() {
        return 4;
    }

    @Override
    protected void flushBuffer(boolean bl) {
        if (this.pos > 4) {
            this.buf[0] = (byte)(this.pos - 4);
            this.buf[1] = (byte)(this.pos - 4 >>> 8);
            this.buf[2] = (byte)(this.pos - 4 >>> 16);
            this.buf[3] = (byte)this.seqNo++;
            StandardPacketOutputStream standardPacketOutputStream = this;
            standardPacketOutputStream.checkMaxAllowedLength(standardPacketOutputStream.pos - 4);
            this.out.write(this.buf, 0, this.pos);
            this.cmdLength += (long)(this.pos - 4);
            if (this.traceCache != null && this.permitTrace) {
                this.traceCache.put(new TraceObject(true, 0, this.threadId, new byte[][]{Arrays.copyOfRange(this.buf, 0, this.pos > 1000 ? 1000 : this.pos)}));
            }
            if (a.isTraceEnabled()) {
                if (this.permitTrace) {
                    a.trace("send: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog, 0, this.pos, (byte[][])new byte[][]{this.buf}));
                } else {
                    a.trace("send: content length={} {} com=<hidden>", (Object)(this.pos - 4), (Object)this.serverThreadLog);
                }
            }
            if (bl && this.pos == 0x1000003) {
                this.writeEmptyPacket();
            }
            this.pos = 4;
        }
    }

    @Override
    public void writeEmptyPacket() {
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = (byte)this.seqNo++;
        this.out.write(this.buf, 0, 4);
        if (this.traceCache != null) {
            this.traceCache.put(new TraceObject(true, 0, this.threadId, new byte[][]{Arrays.copyOfRange(this.buf, 0, 4)}));
        }
        if (a.isTraceEnabled()) {
            a.trace("send com : content length=0 {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog, 0, 4, (byte[][])new byte[][]{this.buf}));
        }
    }
}

