/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharedMemorySocket
extends Socket {
    private static final String a = "D:(A;;0x100000;;;WD)";
    private static final Map<String, Object> b = new HashMap<String, Object>();
    private static final int c = 16004;
    private InputStream d;
    private OutputStream e;
    private String f;
    private WinNT.HANDLE g;
    private WinNT.HANDLE h;
    private WinNT.HANDLE i;
    private WinNT.HANDLE j;
    private WinNT.HANDLE k;
    private Pointer l;
    private int m;
    private int n;
    private int o = -1;

    public SharedMemorySocket(String string) {
        if (!Platform.isWindows()) {
            throw new IOException("shared memory connections are only supported on Windows");
        }
        this.f = string;
    }

    private static WinNT.HANDLE a(String string) {
        return Kernel32.INSTANCE.OpenEvent(0x100002, false, string);
    }

    private static Pointer a(String string, int n, int n2) {
        string = Kernel32.INSTANCE.OpenFileMapping(n, false, string);
        Pointer pointer = Kernel32.INSTANCE.MapViewOfFile((WinNT.HANDLE)string, n, 0, 0, new BaseTSD.SIZE_T((long)n2));
        Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)string);
        return pointer;
    }

    @Override
    public void connect(SocketAddress socketAddress) {
        this.connect(socketAddress, 0);
    }

    private WinNT.HANDLE b() {
        PointerByReference pointerByReference = new PointerByReference();
        Advapi32.INSTANCE.ConvertStringSecurityDescriptorToSecurityDescriptor(a, 1, pointerByReference, null);
        Advapi32.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new Advapi32.SECURITY_ATTRIBUTES();
        new Advapi32.SECURITY_ATTRIBUTES().nLength = sECURITY_ATTRIBUTES.size();
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = pointerByReference.getValue();
        sECURITY_ATTRIBUTES.bInheritHandle = false;
        sECURITY_ATTRIBUTES = Kernel32.INSTANCE.CreateMutex(sECURITY_ATTRIBUTES, false, this.f + "_CONNECT_MUTEX");
        Kernel32.INSTANCE.LocalFree(pointerByReference.getValue());
        if (Kernel32.INSTANCE.WaitForSingleObject((WinNT.HANDLE)sECURITY_ATTRIBUTES, this.o) == -1) {
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)sECURITY_ATTRIBUTES);
            throw new IOException("wait failed (timeout, last error =  " + Kernel32.INSTANCE.GetLastError());
        }
        return sECURITY_ATTRIBUTES;
    }

    private int c() {
        WinNT.HANDLE hANDLE;
        try {
            hANDLE = SharedMemorySocket.a(this.f + "_CONNECT_REQUEST");
        }
        catch (LastErrorException lastErrorException) {
            try {
                hANDLE = SharedMemorySocket.a("Global\\" + this.f + "_CONNECT_REQUEST");
                this.f = "Global\\" + this.f;
            }
            catch (LastErrorException lastErrorException2) {
                throw new IOException("getConnectNumber() fails : " + lastErrorException2.getMessage() + " " + this.f);
            }
        }
        WinNT.HANDLE hANDLE2 = SharedMemorySocket.a(this.f + "_CONNECT_ANSWER");
        Object object = this;
        PointerByReference pointerByReference = new PointerByReference();
        Advapi32.INSTANCE.ConvertStringSecurityDescriptorToSecurityDescriptor(a, 1, pointerByReference, null);
        Advapi32.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new Advapi32.SECURITY_ATTRIBUTES();
        new Advapi32.SECURITY_ATTRIBUTES().nLength = sECURITY_ATTRIBUTES.size();
        sECURITY_ATTRIBUTES.lpSecurityDescriptor = pointerByReference.getValue();
        sECURITY_ATTRIBUTES.bInheritHandle = false;
        sECURITY_ATTRIBUTES = Kernel32.INSTANCE.CreateMutex(sECURITY_ATTRIBUTES, false, object.f + "_CONNECT_MUTEX");
        Kernel32.INSTANCE.LocalFree(pointerByReference.getValue());
        if (Kernel32.INSTANCE.WaitForSingleObject((WinNT.HANDLE)sECURITY_ATTRIBUTES, object.o) == -1) {
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)sECURITY_ATTRIBUTES);
            throw new IOException("wait failed (timeout, last error =  " + Kernel32.INSTANCE.GetLastError());
        }
        object = sECURITY_ATTRIBUTES;
        pointerByReference = null;
        try {
            Kernel32.INSTANCE.SetEvent(hANDLE);
            pointerByReference = SharedMemorySocket.a(this.f + "_CONNECT_DATA", 4, 4);
            int n = Kernel32.INSTANCE.WaitForSingleObject(hANDLE2, this.o);
            if (n != 0) {
                throw new IOException("WaitForSingleObject returned " + n + ", last error " + Kernel32.INSTANCE.GetLastError());
            }
            n = pointerByReference.getInt(0L);
            return n;
        }
        finally {
            Kernel32.INSTANCE.ReleaseMutex((WinNT.HANDLE)object);
            Kernel32.INSTANCE.CloseHandle((WinNT.HANDLE)object);
            if (pointerByReference != null) {
                Kernel32.INSTANCE.UnmapViewOfFile((Pointer)pointerByReference);
            }
            Kernel32.INSTANCE.CloseHandle(hANDLE);
            Kernel32.INSTANCE.CloseHandle(hANDLE2);
        }
    }

    @Override
    public void connect(SocketAddress object, int n) {
        try {
            this.d = new SharedMemoryInputStream();
            this.e = new SharedMemoryOutputStream();
            object = this.f + "_" + this.c();
            this.i = SharedMemorySocket.a((String)object + "_CLIENT_READ");
            this.g = SharedMemorySocket.a((String)object + "_SERVER_READ");
            this.h = SharedMemorySocket.a((String)object + "_SERVER_WROTE");
            this.j = SharedMemorySocket.a((String)object + "_CLIENT_WROTE");
            this.k = SharedMemorySocket.a((String)object + "_CONNECTION_CLOSED");
            this.l = SharedMemorySocket.a((String)object + "_DATA", 2, 16004);
            Kernel32.INSTANCE.SetEvent(this.g);
            return;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException.getMessage(), lastErrorException.getCause());
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.d;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.e;
    }

    @Override
    public void setTcpNoDelay(boolean bl) {
    }

    @Override
    public void setKeepAlive(boolean bl) {
    }

    @Override
    public void setReceiveBufferSize(int n) {
    }

    @Override
    public void setSendBufferSize(int n) {
    }

    @Override
    public void setSoLinger(boolean bl, int n) {
    }

    @Override
    public void setSoTimeout(int n) {
        if (n == 0) {
            this.o = -1;
            return;
        }
        this.o = n;
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public void close() {
        if (this.k != null && Kernel32.INSTANCE.WaitForSingleObject(this.k, 0) != 0) {
            Kernel32.INSTANCE.SetEvent(this.k);
        }
        WinNT.HANDLE[] hANDLEArray = new WinNT.HANDLE[]{this.g, this.h, this.i, this.j, this.k};
        hANDLEArray = hANDLEArray;
        for (int i = 0; i < 5; ++i) {
            WinNT.HANDLE hANDLE = hANDLEArray[i];
            if (hANDLE == null) continue;
            Kernel32.INSTANCE.CloseHandle(hANDLE);
        }
        if (this.l != null) {
            Kernel32.INSTANCE.UnmapViewOfFile(this.l);
        }
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
    }

    static /* synthetic */ Map a() {
        return b;
    }

    static {
        b.put("function-mapper", W32APIFunctionMapper.UNICODE);
        b.put("type-mapper", W32APITypeMapper.UNICODE);
    }

    class SharedMemoryOutputStream
    extends OutputStream {
        SharedMemoryOutputStream() {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            WinNT.HANDLE[] hANDLEArray = new WinNT.HANDLE[]{SharedMemorySocket.this.g, SharedMemorySocket.this.k};
            while (n2 > 0) {
                int n3 = Kernel32.INSTANCE.WaitForMultipleObjects(2, hANDLEArray, false, SharedMemorySocket.this.o);
                if (n3 == -1) {
                    throw new IOException("WaitForMultipleObjects() failed, timeout");
                }
                if (n3 == 1) {
                    throw new IOException("Server closed connection");
                }
                if (n3 != 0) {
                    throw new IOException("Unexpected return result from WaitForMultipleObjects : " + n3);
                }
                n3 = Math.min(n2, 16004);
                SharedMemorySocket.this.l.setInt(0L, n3);
                SharedMemorySocket.this.l.write(4L, byArray, n, n3);
                n += n3;
                n2 -= n3;
                if (Kernel32.INSTANCE.SetEvent(SharedMemorySocket.this.j)) continue;
                throw new IOException("SetEvent failed");
            }
        }

        @Override
        public void write(int n) {
            this.write(new byte[]{(byte)n});
        }

        @Override
        public void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }
    }

    class SharedMemoryInputStream
    extends InputStream {
        SharedMemoryInputStream() {
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            WinNT.HANDLE[] hANDLEArray = new WinNT.HANDLE[]{SharedMemorySocket.this.h, SharedMemorySocket.this.k};
            if (SharedMemorySocket.this.m == 0) {
                int n3 = Kernel32.INSTANCE.WaitForMultipleObjects(2, hANDLEArray, false, SharedMemorySocket.this.o);
                if (n3 == -1) {
                    throw new IOException("wait failed, timeout");
                }
                if (n3 == 1) {
                    throw new IOException("Server closed connection");
                }
                if (n3 != 0) {
                    throw new IOException("Unexpected return result from WaitForMultipleObjects : " + n3);
                }
                SharedMemorySocket.this.m = SharedMemorySocket.this.l.getInt(0L);
                SharedMemorySocket.this.n = 4;
            }
            int n4 = Math.min(n2, SharedMemorySocket.this.m);
            SharedMemorySocket.this.l.read((long)SharedMemorySocket.this.n, byArray, n, n4);
            SharedMemorySocket.this.n = SharedMemorySocket.this.n + n4;
            SharedMemorySocket.this.m = SharedMemorySocket.this.m - n4;
            if (SharedMemorySocket.this.m == 0) {
                Kernel32.INSTANCE.SetEvent(SharedMemorySocket.this.i);
            }
            return n4;
        }

        @Override
        public int read() {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n == 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }
    }

    public static interface Advapi32
    extends StdCallLibrary {
        public static final Advapi32 INSTANCE = (Advapi32)Native.load((String)"advapi32", Advapi32.class, (Map)SharedMemorySocket.a());

        public boolean ConvertStringSecurityDescriptorToSecurityDescriptor(String var1, int var2, PointerByReference var3, IntByReference var4);

        public static class SECURITY_ATTRIBUTES
        extends Structure {
            public int nLength;
            public Pointer lpSecurityDescriptor;
            public boolean bInheritHandle;

            protected List<String> getFieldOrder() {
                return Arrays.asList("nLength", "lpSecurityDescriptor", "bInheritHandle");
            }
        }
    }

    public static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.load((String)"Kernel32", Kernel32.class, (Map)SharedMemorySocket.a());
        public static final int FILE_MAP_WRITE = 2;
        public static final int FILE_MAP_READ = 4;
        public static final int EVENT_MODIFY_STATE = 2;
        public static final int SYNCHRONIZE = 0x100000;
        public static final int INFINITE = -1;

        public WinNT.HANDLE OpenEvent(int var1, boolean var2, String var3) throws LastErrorException;

        public WinNT.HANDLE OpenFileMapping(int var1, boolean var2, String var3) throws LastErrorException;

        public Pointer MapViewOfFile(WinNT.HANDLE var1, int var2, int var3, int var4, BaseTSD.SIZE_T var5) throws LastErrorException;

        public boolean UnmapViewOfFile(Pointer var1) throws LastErrorException;

        public boolean SetEvent(WinNT.HANDLE var1) throws LastErrorException;

        public boolean CloseHandle(WinNT.HANDLE var1) throws LastErrorException;

        public int WaitForSingleObject(WinNT.HANDLE var1, int var2) throws LastErrorException;

        public int WaitForMultipleObjects(int var1, WinNT.HANDLE[] var2, boolean var3, int var4) throws LastErrorException;

        public int GetLastError() throws LastErrorException;

        public WinNT.HANDLE CreateMutex(Advapi32.SECURITY_ATTRIBUTES var1, boolean var2, String var3);

        public boolean ReleaseMutex(WinNT.HANDLE var1);

        public Pointer LocalFree(Pointer var1);
    }
}

