/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.osgi;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.Driver;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbDataSource;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbPoolDataSource;

public class MariaDbDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties properties) {
        if (properties != null && (properties.containsKey("minPoolSize") || properties.containsKey("maxPoolSize") || properties.containsKey("maxIdleTime"))) {
            return MariaDbDataSourceFactory.b(properties);
        }
        return MariaDbDataSourceFactory.a(properties);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) {
        if (properties != null && (properties.containsKey("minPoolSize") || properties.containsKey("maxPoolSize") || properties.containsKey("maxIdleTime"))) {
            return MariaDbDataSourceFactory.b(properties);
        }
        return MariaDbDataSourceFactory.a(properties);
    }

    public XADataSource createXADataSource(Properties properties) {
        if (properties != null && (properties.containsKey("minPoolSize") || properties.containsKey("maxPoolSize") || properties.containsKey("maxIdleTime"))) {
            return MariaDbDataSourceFactory.b(properties);
        }
        return MariaDbDataSourceFactory.a(properties);
    }

    public Driver createDriver(Properties properties) {
        return new Driver();
    }

    private static MariaDbDataSource a(Properties properties) {
        MariaDbDataSource mariaDbDataSource = new MariaDbDataSource();
        if (properties.containsKey("url")) {
            mariaDbDataSource.setUrl(properties.getProperty("url"));
        }
        if (properties.containsKey("serverName")) {
            mariaDbDataSource.setServerName(properties.getProperty("serverName"));
        }
        if (properties.containsKey("portNumber")) {
            try {
                mariaDbDataSource.setPortNumber(Integer.parseInt(properties.getProperty("portNumber")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Port format must be integer, but value is '" + properties.getProperty("portNumber") + "'");
            }
        }
        if (properties.containsKey("user")) {
            mariaDbDataSource.setUser(properties.getProperty("user"));
        }
        if (properties.containsKey("password")) {
            mariaDbDataSource.setPassword(properties.getProperty("password"));
        }
        if (properties.containsKey("databaseName")) {
            mariaDbDataSource.setDatabaseName(properties.getProperty("databaseName"));
        }
        return mariaDbDataSource;
    }

    private static MariaDbPoolDataSource b(Properties properties) {
        MariaDbPoolDataSource mariaDbPoolDataSource = new MariaDbPoolDataSource();
        if (properties.containsKey("url")) {
            mariaDbPoolDataSource.setUrl(properties.getProperty("url"));
        }
        if (properties.containsKey("serverName")) {
            mariaDbPoolDataSource.setServerName(properties.getProperty("serverName"));
        }
        if (properties.containsKey("portNumber")) {
            try {
                mariaDbPoolDataSource.setPortNumber(Integer.parseInt(properties.getProperty("portNumber")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Port number format must be integer, but value is '" + properties.getProperty("portNumber") + "'");
            }
        }
        if (properties.containsKey("user")) {
            mariaDbPoolDataSource.setUser(properties.getProperty("user"));
        }
        if (properties.containsKey("password")) {
            mariaDbPoolDataSource.setPassword(properties.getProperty("password"));
        }
        if (properties.containsKey("databaseName")) {
            mariaDbPoolDataSource.setDatabaseName(properties.getProperty("databaseName"));
        }
        if (properties.containsKey("maxIdleTime")) {
            try {
                mariaDbPoolDataSource.setMaxIdleTime(Integer.parseInt(properties.getProperty("maxIdleTime")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Max idle time format must be integer, but value is '" + properties.getProperty("maxIdleTime") + "'");
            }
        }
        if (properties.containsKey("maxPoolSize")) {
            try {
                mariaDbPoolDataSource.setMaxPoolSize(Integer.parseInt(properties.getProperty("maxPoolSize")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Max pool size format must be integer, but value is '" + properties.getProperty("maxPoolSize") + "'");
            }
        }
        if (properties.containsKey("minPoolSize")) {
            try {
                mariaDbPoolDataSource.setMinPoolSize(Integer.parseInt(properties.getProperty("minPoolSize")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Min pool size format must be integer, but value is '" + properties.getProperty("minPoolSize") + "'");
            }
        }
        return mariaDbPoolDataSource;
    }
}

