/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.dao.Results;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AsyncMultiRead;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.AsyncMultiReadResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.BulkStatus;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.SqlStates;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ClientPrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.PrepareResult;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.dao.ServerPrepareResult;

public abstract class AbstractMultiSend {
    private final Protocol a;
    private final PacketOutputStream b;
    private final Results c;
    private final boolean d;
    protected int statementId = -1;
    protected ColumnType[] parameterTypeHeader;
    private List<ParameterHolder[]> e;
    private PrepareResult f;
    private List<String> g;
    private String h;
    private ThreadPoolExecutor i;

    public AbstractMultiSend(Protocol protocol, PacketOutputStream packetOutputStream, Results results, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> list, String string, ThreadPoolExecutor threadPoolExecutor) {
        this.a = protocol;
        this.b = packetOutputStream;
        this.c = results;
        this.f = serverPrepareResult;
        this.e = list;
        this.d = true;
        this.i = threadPoolExecutor;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream packetOutputStream, Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> list, ThreadPoolExecutor threadPoolExecutor) {
        this.a = protocol;
        this.b = packetOutputStream;
        this.c = results;
        this.f = clientPrepareResult;
        this.e = list;
        this.d = false;
        this.i = threadPoolExecutor;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream packetOutputStream, Results results, List<String> list, ThreadPoolExecutor threadPoolExecutor) {
        this.a = protocol;
        this.b = packetOutputStream;
        this.c = results;
        this.g = list;
        this.d = false;
        this.i = threadPoolExecutor;
    }

    public abstract void sendCmd(PacketOutputStream var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, BulkStatus var6, PrepareResult var7);

    public abstract SQLException handleResultException(SQLException var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, int var6, int var7, PrepareResult var8);

    public abstract int getParamCount();

    public abstract int getTotalExecutionNumber();

    public PrepareResult getPrepareResult() {
        return this.f;
    }

    public void executeBatch() {
        int n = this.getParamCount();
        if (this.d) {
            this.parameterTypeHeader = new ColumnType[n];
            this.statementId = ((ServerPrepareResult)this.f).getStatementId();
        }
        int n2 = n;
        AbstractMultiSend abstractMultiSend = this;
        int n3 = abstractMultiSend.getTotalExecutionNumber();
        SQLException sQLException = null;
        BulkStatus bulkStatus = new BulkStatus();
        FutureTask<AsyncMultiReadResult> futureTask = null;
        int n4 = n2;
        try {
            do {
                bulkStatus.sendEnded = false;
                bulkStatus.sendSubCmdCounter = 0;
                n2 = Math.min(n3 - bulkStatus.sendCmdCounter, abstractMultiSend.a.getOptions().useBatchMultiSendNumber);
                abstractMultiSend.a.changeSocketTcpNoDelay(false);
                boolean bl = false;
                while (bulkStatus.sendSubCmdCounter < n2) {
                    AbstractMultiSend abstractMultiSend2 = abstractMultiSend;
                    abstractMultiSend2.sendCmd(abstractMultiSend2.b, abstractMultiSend.c, abstractMultiSend.e, abstractMultiSend.g, n4, bulkStatus, abstractMultiSend.f);
                    ++bulkStatus.sendSubCmdCounter;
                    ++bulkStatus.sendCmdCounter;
                    if (bl) {
                        try {
                            abstractMultiSend.a.getResult(abstractMultiSend.c);
                        }
                        catch (SQLException sQLException2) {
                            if (!abstractMultiSend.a.getOptions().continueBatchOnError) {
                                throw sQLException2;
                            }
                            if (sQLException != null) continue;
                            sQLException = sQLException2;
                        }
                        continue;
                    }
                    if (futureTask != null) continue;
                    try {
                        futureTask = new FutureTask<AsyncMultiReadResult>(new AsyncMultiRead(bulkStatus, abstractMultiSend.a, abstractMultiSend, n4, abstractMultiSend.c, abstractMultiSend.e, abstractMultiSend.g, abstractMultiSend.f));
                        abstractMultiSend.i.execute(futureTask);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        bl = true;
                        try {
                            abstractMultiSend.a.getResult(abstractMultiSend.c);
                        }
                        catch (SQLException sQLException3) {
                            if (!abstractMultiSend.a.getOptions().continueBatchOnError) {
                                throw sQLException3;
                            }
                            if (sQLException != null) continue;
                            sQLException = sQLException3;
                        }
                    }
                }
                bulkStatus.sendEnded = true;
                if (!bl) {
                    Object object;
                    abstractMultiSend.a.changeSocketTcpNoDelay(abstractMultiSend.a.getOptions().tcpNoDelay);
                    try {
                        object = (AsyncMultiReadResult)futureTask.get();
                        if (((AsyncMultiReadResult)object).getException() != null && sQLException == null) {
                            sQLException = ((AsyncMultiReadResult)object).getException();
                        }
                    }
                    catch (ExecutionException executionException) {
                        object = executionException;
                        if (executionException.getCause() == null) {
                            throw new SQLException("Error reading results " + ((Throwable)object).getMessage());
                        }
                        throw new SQLException("Error reading results " + ((Throwable)object).getCause().getMessage());
                    }
                    catch (InterruptedException interruptedException) {
                        abstractMultiSend.a.setActiveFutureTask(futureTask);
                        Thread.currentThread().interrupt();
                        throw new SQLException("Interrupted awaiting response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), interruptedException);
                    }
                    finally {
                        abstractMultiSend.a.forceReleaseWaitingPrepareStatement();
                    }
                }
                if (abstractMultiSend.a.isInterrupted()) {
                    futureTask.cancel(true);
                    throw new SQLTimeoutException("Timeout during batch execution");
                }
                futureTask = null;
            } while (bulkStatus.sendCmdCounter < n3);
            if (sQLException != null) {
                throw sQLException;
            }
            return;
        }
        catch (IOException iOException) {
            bulkStatus.sendEnded = true;
            bulkStatus.sendCmdCounter = 0;
            throw abstractMultiSend.a.handleIoException(iOException);
        }
    }

    private void a(int n) {
        int n2 = this.getTotalExecutionNumber();
        SQLException sQLException = null;
        BulkStatus bulkStatus = new BulkStatus();
        FutureTask<AsyncMultiReadResult> futureTask = null;
        int n3 = n;
        try {
            do {
                bulkStatus.sendEnded = false;
                bulkStatus.sendSubCmdCounter = 0;
                n = Math.min(n2 - bulkStatus.sendCmdCounter, this.a.getOptions().useBatchMultiSendNumber);
                this.a.changeSocketTcpNoDelay(false);
                boolean bl = false;
                while (bulkStatus.sendSubCmdCounter < n) {
                    AbstractMultiSend abstractMultiSend = this;
                    abstractMultiSend.sendCmd(abstractMultiSend.b, this.c, this.e, this.g, n3, bulkStatus, this.f);
                    ++bulkStatus.sendSubCmdCounter;
                    ++bulkStatus.sendCmdCounter;
                    if (bl) {
                        try {
                            this.a.getResult(this.c);
                        }
                        catch (SQLException sQLException2) {
                            if (!this.a.getOptions().continueBatchOnError) {
                                throw sQLException2;
                            }
                            if (sQLException != null) continue;
                            sQLException = sQLException2;
                        }
                        continue;
                    }
                    if (futureTask != null) continue;
                    try {
                        futureTask = new FutureTask<AsyncMultiReadResult>(new AsyncMultiRead(bulkStatus, this.a, this, n3, this.c, this.e, this.g, this.f));
                        this.i.execute(futureTask);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        bl = true;
                        try {
                            this.a.getResult(this.c);
                        }
                        catch (SQLException sQLException3) {
                            if (!this.a.getOptions().continueBatchOnError) {
                                throw sQLException3;
                            }
                            if (sQLException != null) continue;
                            sQLException = sQLException3;
                        }
                    }
                }
                bulkStatus.sendEnded = true;
                if (!bl) {
                    Object object;
                    this.a.changeSocketTcpNoDelay(this.a.getOptions().tcpNoDelay);
                    try {
                        object = (AsyncMultiReadResult)futureTask.get();
                        if (((AsyncMultiReadResult)object).getException() != null && sQLException == null) {
                            sQLException = ((AsyncMultiReadResult)object).getException();
                        }
                    }
                    catch (ExecutionException executionException) {
                        object = executionException;
                        if (executionException.getCause() == null) {
                            throw new SQLException("Error reading results " + ((Throwable)object).getMessage());
                        }
                        throw new SQLException("Error reading results " + ((Throwable)object).getCause().getMessage());
                    }
                    catch (InterruptedException interruptedException) {
                        this.a.setActiveFutureTask(futureTask);
                        Thread.currentThread().interrupt();
                        throw new SQLException("Interrupted awaiting response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), interruptedException);
                    }
                    finally {
                        this.a.forceReleaseWaitingPrepareStatement();
                    }
                }
                if (this.a.isInterrupted()) {
                    futureTask.cancel(true);
                    throw new SQLTimeoutException("Timeout during batch execution");
                }
                futureTask = null;
            } while (bulkStatus.sendCmdCounter < n2);
            if (sQLException != null) {
                throw sQLException;
            }
            return;
        }
        catch (IOException iOException) {
            bulkStatus.sendEnded = true;
            bulkStatus.sendCmdCounter = 0;
            throw this.a.handleIoException(iOException);
        }
    }
}

