/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;

public class HostnameVerifierImpl
implements HostnameVerifier {
    private static final Logger a = LoggerFactory.getLogger(HostnameVerifierImpl.class);

    private static boolean a(String string, String string2) {
        boolean bl = Utils.isIPv4(string) || Utils.isIPv6(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(Locale.ROOT), ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2.toLowerCase(Locale.ROOT), ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        try {
            while (stringTokenizer.hasMoreTokens()) {
                if (HostnameVerifierImpl.a(bl, stringTokenizer.nextToken(), stringTokenizer2.nextToken())) continue;
                return false;
            }
        }
        catch (SSLException sSLException) {
            throw new SSLException(HostnameVerifierImpl.c(string) + " doesn't correspond to certificate CN \"" + string2 + "\" : wildcards not possible for IPs");
        }
        return true;
    }

    private static boolean a(boolean bl, String string, String string2) {
        int n = string2.indexOf("*");
        if (n != -1) {
            if (bl) {
                throw new SSLException("WildCards not possible when using IP's");
            }
            bl = true;
            String string3 = string2;
            while (n != -1) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
                n = string.indexOf(string2);
                if (n == -1 || bl && n != 0) {
                    return false;
                }
                bl = false;
                string = string.substring(n + string2.length());
                n = string3.indexOf("*");
            }
            return string.endsWith(string3);
        }
        return string.equals(string2);
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(string);
            for (Rdn rdn : ldapName.getRdns()) {
                Object object;
                if (!rdn.getType().equalsIgnoreCase("CN") || (object = rdn.getValue()) == null) continue;
                return object.toString();
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            throw new SSLException("DN value \"" + string + "\" is invalid");
        }
    }

    private static String b(String string) {
        if (string == null) {
            return null;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    private static String c(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (Utils.isIPv4(string)) {
            stringBuilder.append("IPv4 host \"");
        } else if (Utils.isIPv6(string)) {
            stringBuilder.append("IPv6 host \"");
        } else {
            stringBuilder.append("DNS host \"");
        }
        stringBuilder.append(string).append("\"");
        return stringBuilder.toString();
    }

    private SubjectAltNames a(X509Certificate iterator) {
        iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
        SubjectAltNames subjectAltNames = new SubjectAltNames(0);
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string;
                List list = (List)iterator.next();
                if (list.size() < 2) continue;
                int n = (Integer)list.get(0);
                if (n == 2 && (string = (String)list.get(1)) != null) {
                    string = string.toLowerCase(Locale.ROOT);
                    subjectAltNames.add(new GeneralName(string, Extension.DNS));
                }
                if (n != 7 || (string = (String)list.get(1)) == null) continue;
                subjectAltNames.add(new GeneralName(string, Extension.IP));
            }
        }
        return subjectAltNames;
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        return this.verify(string, sSLSession, -1L);
    }

    public boolean verify(String string, SSLSession object, long l) {
        try {
            object = object.getPeerCertificates();
            object = (X509Certificate)object[0];
            this.verify(string, (X509Certificate)object, l);
            return true;
        }
        catch (SSLException sSLException) {
            if (a.isDebugEnabled()) {
                a.debug(sSLException.getMessage(), sSLException);
            }
            return false;
        }
    }

    public void verify(String string, X509Certificate x509Certificate, long l) {
        if (string == null) {
            return;
        }
        string = string.toLowerCase(Locale.ROOT);
        try {
            Object object;
            Iterator<GeneralName> iterator = x509Certificate;
            Object object2 = this;
            iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
            Object object3 = (HostnameVerifierImpl)object2.new SubjectAltNames(0);
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    object = (List)iterator.next();
                    if (object.size() < 2) continue;
                    int n = (Integer)object.get(0);
                    if (n == 2 && (string2 = (String)object.get(1)) != null) {
                        string2 = string2.toLowerCase(Locale.ROOT);
                        ((SubjectAltNames)object3).add((HostnameVerifierImpl)object2.new GeneralName(string2, Extension.DNS));
                    }
                    if (n != 7 || (string2 = (String)object.get(1)) == null) continue;
                    ((SubjectAltNames)object3).add((HostnameVerifierImpl)object2.new GeneralName(string2, Extension.IP));
                }
            }
            if (!((SubjectAltNames)(object2 = object3)).isEmpty()) {
                if (Utils.isIPv4(string)) {
                    iterator = ((SubjectAltNames)object2).getGeneralNames().iterator();
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        if (a.isTraceEnabled()) {
                            a.trace("Conn={}. IPv4 verification of hostname : type={} value={} to {}", new Object[]{l, ((GeneralName)object3).b, ((GeneralName)object3).a, string});
                        }
                        if (((GeneralName)object3).b != Extension.IP || !string.equals(((GeneralName)object3).a)) continue;
                        return;
                    }
                } else if (Utils.isIPv6(string)) {
                    iterator = HostnameVerifierImpl.b(string);
                    object3 = ((SubjectAltNames)object2).getGeneralNames().iterator();
                    while (object3.hasNext()) {
                        object = (GeneralName)object3.next();
                        if (a.isTraceEnabled()) {
                            a.trace("Conn={}. IPv6 verification of hostname : type={} value={} to {}", new Object[]{l, ((GeneralName)object).b, ((GeneralName)object).a, string});
                        }
                        if (((GeneralName)object).b != Extension.IP || Utils.isIPv4(((GeneralName)object).a) || !((String)((Object)iterator)).equals(HostnameVerifierImpl.b(((GeneralName)object).a))) continue;
                        return;
                    }
                } else {
                    iterator = ((SubjectAltNames)object2).getGeneralNames().iterator();
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        if (a.isTraceEnabled()) {
                            a.trace("Conn={}. DNS verification of hostname : type={} value={} to {}", new Object[]{l, ((GeneralName)object3).b, ((GeneralName)object3).a, string});
                        }
                        if (((GeneralName)object3).b != Extension.DNS || !HostnameVerifierImpl.a(string, ((GeneralName)object3).a.toLowerCase(Locale.ROOT))) continue;
                        return;
                    }
                }
            }
            if ((object3 = HostnameVerifierImpl.a(((X500Principal)((Object)(iterator = x509Certificate.getSubjectX500Principal()))).getName("RFC2253"))) == null) {
                if (((SubjectAltNames)object2).isEmpty()) {
                    throw new SSLException("CN not found in certificate principal \"{}" + iterator + "\" and certificate doesn't contain SAN");
                }
                throw new SSLException("CN not found in certificate principal \"" + iterator + "\" and " + HostnameVerifierImpl.c(string) + " doesn't correspond to " + ((SubjectAltNames)object2).toString());
            }
            object = ((String)object3).toLowerCase(Locale.ROOT);
            if (a.isTraceEnabled()) {
                a.trace("Conn={}. DNS verification of hostname : CN={} to {}", l, object, string);
            }
            if (!HostnameVerifierImpl.a(string, (String)object)) {
                string = HostnameVerifierImpl.c(string) + " doesn't correspond to certificate CN \"" + (String)object + "\"";
                if (!((SubjectAltNames)object2).isEmpty()) {
                    string = string + " and " + ((SubjectAltNames)object2).toString();
                }
                throw new SSLException(string);
            }
            return;
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new SSLException("certificate parsing error : " + certificateParsingException.getMessage());
        }
    }

    private class SubjectAltNames {
        private final List<GeneralName> a = new ArrayList<GeneralName>();

        private SubjectAltNames() {
        }

        public String toString() {
            if (this.isEmpty()) {
                return "SAN[-empty-]";
            }
            StringBuilder stringBuilder = new StringBuilder("SAN[");
            boolean bl = true;
            for (GeneralName generalName : this.a) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append(generalName.toString());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public List<GeneralName> getGeneralNames() {
            return this.a;
        }

        public void add(GeneralName generalName) {
            this.a.add(generalName);
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        /* synthetic */ SubjectAltNames(byte by) {
            this();
        }
    }

    private class GeneralName {
        private final String a;
        private final Extension b;

        public GeneralName(String string, Extension extension) {
            this.a = string;
            this.b = extension;
        }

        public String toString() {
            return "{" + (Object)((Object)this.b) + ":\"" + this.a + "\"}";
        }
    }

    private static enum Extension {
        DNS,
        IP;

    }
}

