/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls;

import java.io.Serializable;
import java.net.Socket;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

public class MariaDbX509KeyManager
extends X509ExtendedKeyManager {
    private final Hashtable<String, KeyStore.PrivateKeyEntry> a = new Hashtable();

    public MariaDbX509KeyManager(KeyStore keyStore, char[] cArray) {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) continue;
            try {
                this.a.put(string, (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, new KeyStore.PasswordProtection(cArray)));
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {}
        }
    }

    @Override
    public String[] getClientAliases(String object, Principal[] principalArray) {
        if ((object = this.a(new String[]{object}, principalArray)).size() == 0) {
            return null;
        }
        Object object2 = object;
        return object2.toArray(new String[object2.size()]);
    }

    @Override
    public String chooseClientAlias(String[] object, Principal[] principalArray, Socket socket) {
        if ((object = this.a((String[])object, principalArray)).size() > 0) {
            return (String)object.get(0);
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String certificateArray) {
        if ((certificateArray = this.a.get(certificateArray)) == null) {
            return null;
        }
        if ((certificateArray = certificateArray.getCertificateChain()).length > 0 && certificateArray[0] instanceof X509Certificate) {
            return (X509Certificate[])Arrays.copyOf(certificateArray, certificateArray.length, X509Certificate[].class);
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    @Override
    public PrivateKey getPrivateKey(String object) {
        if ((object = this.a.get(object)) == null) {
            return null;
        }
        return ((KeyStore.PrivateKeyEntry)object).getPrivateKey();
    }

    private ArrayList<String> a(String[] stringArray, Principal[] principalArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, KeyStore.PrivateKeyEntry> entry : this.a.entrySet()) {
            Certificate[] certificateArray = entry.getValue().getCertificateChain();
            String string = certificateArray[0].getPublicKey().getAlgorithm();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            block1: for (int i = 0; i < n; ++i) {
                Certificate[] certificateArray2 = stringArray2[i];
                if (!string.equals(certificateArray2)) continue;
                if (principalArray != null && principalArray.length != 0) {
                    certificateArray2 = certificateArray;
                    int n2 = certificateArray.length;
                    for (int j = 0; j < n2; ++j) {
                        Serializable serializable = certificateArray2[j];
                        if (!(serializable instanceof X509Certificate)) continue;
                        serializable = ((X509Certificate)serializable).getIssuerX500Principal();
                        Principal[] principalArray2 = principalArray;
                        int n3 = principalArray.length;
                        for (int k = 0; k < n3; ++k) {
                            Principal principal = principalArray2[k];
                            if (!((X500Principal)serializable).equals(principal)) continue;
                            arrayList.add(entry.getKey());
                            continue block1;
                        }
                    }
                    continue;
                }
                arrayList.add(entry.getKey());
            }
        }
        return arrayList;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return null;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return null;
    }
}

