/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Cake;
import org.bukkit.material.Colorable;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;
import org.bukkit.material.Wool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.xseries.XMaterial;

public final class XBlock {
    public static final Set<XMaterial> CROPS = Collections.unmodifiableSet(EnumSet.of(XMaterial.CARROT, new XMaterial[]{XMaterial.CARROTS, XMaterial.POTATO, XMaterial.POTATOES, XMaterial.NETHER_WART, XMaterial.PUMPKIN_SEEDS, XMaterial.WHEAT_SEEDS, XMaterial.WHEAT, XMaterial.MELON_SEEDS, XMaterial.BEETROOT_SEEDS, XMaterial.BEETROOTS, XMaterial.SUGAR_CANE, XMaterial.BAMBOO_SAPLING, XMaterial.BAMBOO, XMaterial.CHORUS_PLANT, XMaterial.KELP, XMaterial.KELP_PLANT, XMaterial.SEA_PICKLE, XMaterial.BROWN_MUSHROOM, XMaterial.RED_MUSHROOM, XMaterial.MELON_STEM, XMaterial.PUMPKIN_STEM}));
    public static final Set<XMaterial> DANGEROUS = Collections.unmodifiableSet(EnumSet.of(XMaterial.MAGMA_BLOCK, XMaterial.LAVA, XMaterial.CAMPFIRE, XMaterial.FIRE, XMaterial.SOUL_FIRE));
    public static final byte CAKE_SLICES = 6;
    private static final boolean a = XMaterial.supports(13);
    private static final Map<XMaterial, XMaterial> b = new EnumMap<XMaterial, XMaterial>(XMaterial.class);

    private XBlock() {
    }

    public static boolean isLit(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return false;
            }
            block = (Lightable)block.getBlockData();
            return block.isLit();
        }
        BlockMaterial[] blockMaterialArray = new BlockMaterial[]{BlockMaterial.REDSTONE_LAMP_ON, BlockMaterial.REDSTONE_TORCH_ON, BlockMaterial.BURNING_FURNACE};
        block = block.getType();
        for (int i = 0; i < 3; ++i) {
            BlockMaterial blockMaterial = blockMaterialArray[i];
            if (block != blockMaterial.a) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainer(@Nullable Block block) {
        return block != null && block.getState() instanceof InventoryHolder;
    }

    public static void setLit(Block block, boolean bl) {
        if (a) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return;
            }
            BlockData blockData = block.getBlockData();
            Lightable lightable = (Lightable)blockData;
            lightable.setLit(bl);
            block.setBlockData(blockData, false);
            return;
        }
        String string = block.getType().name();
        if (string.endsWith("FURNACE")) {
            block.setType(BlockMaterial.BURNING_FURNACE.a);
            return;
        }
        if (string.startsWith("REDSTONE_LAMP")) {
            block.setType(BlockMaterial.REDSTONE_LAMP_ON.a);
            return;
        }
        block.setType(BlockMaterial.REDSTONE_TORCH_ON.a);
    }

    public static boolean isCrop(XMaterial xMaterial) {
        return CROPS.contains((Object)xMaterial);
    }

    public static boolean isDangerous(XMaterial xMaterial) {
        return DANGEROUS.contains((Object)xMaterial);
    }

    public static DyeColor getColor(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Colorable)) {
                return null;
            }
            block = (Colorable)block.getBlockData();
            return block.getColor();
        }
        block = block.getState();
        if ((block = block.getData()) instanceof Wool) {
            block = (Wool)block;
            return block.getColor();
        }
        return null;
    }

    public static boolean isCake(@Nullable Material material) {
        return material == Material.CAKE || material == BlockMaterial.CAKE_BLOCK.a;
    }

    public static boolean isWheat(@Nullable Material material) {
        return material == Material.WHEAT || material == BlockMaterial.CROPS.a;
    }

    public static boolean isSugarCane(@Nullable Material material) {
        return material == Material.SUGAR_CANE || material == BlockMaterial.SUGAR_CANE_BLOCK.a;
    }

    public static boolean isBeetroot(@Nullable Material material) {
        return material == Material.BEETROOT || material == Material.BEETROOTS || material == BlockMaterial.BEETROOT_BLOCK.a;
    }

    public static boolean isNetherWart(@Nullable Material material) {
        return material == Material.NETHER_WART || material == BlockMaterial.NETHER_WARTS.a;
    }

    public static boolean isCarrot(@Nullable Material material) {
        return material == Material.CARROT || material == Material.CARROTS;
    }

    public static boolean isMelon(@Nullable Material material) {
        return material == Material.MELON || material == Material.MELON_SLICE || material == BlockMaterial.MELON_BLOCK.a;
    }

    public static boolean isPotato(@Nullable Material material) {
        return material == Material.POTATO || material == Material.POTATOES;
    }

    public static BlockFace getDirection(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return BlockFace.SELF;
            }
            block = (org.bukkit.block.data.Directional)block.getBlockData();
            return block.getFacing();
        }
        block = block.getState();
        if ((block = block.getData()) instanceof Directional) {
            return ((Directional)block).getFacing();
        }
        return BlockFace.SELF;
    }

    public static boolean setDirection(Block block, BlockFace blockFace) {
        if (a) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return false;
            }
            BlockData blockData = block.getBlockData();
            org.bukkit.block.data.Directional directional = (org.bukkit.block.data.Directional)blockData;
            directional.setFacing(blockFace);
            block.setBlockData(blockData, false);
            return true;
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        if (materialData instanceof Directional) {
            if (XMaterial.matchXMaterial(block.getType()) == XMaterial.LADDER) {
                blockFace = blockFace.getOppositeFace();
            }
            ((Directional)materialData).setFacingDirection(blockFace);
            blockState.update(true);
            return true;
        }
        return false;
    }

    public static boolean setType(@Nonnull Block block, @Nullable XMaterial object, boolean bl) {
        int n;
        block39: {
            block40: {
                Object object2;
                Object object3;
                block38: {
                    Object object4;
                    Objects.requireNonNull(block, "Cannot set type of null block");
                    if (object == null) {
                        object = XMaterial.AIR;
                    }
                    if ((object4 = b.get(object)) != null) {
                        object = object4;
                    }
                    if (((XMaterial)((Object)object)).parseMaterial() == null) {
                        return false;
                    }
                    block.setType(((XMaterial)((Object)object)).parseMaterial(), bl);
                    if (a) {
                        return false;
                    }
                    object4 = ((XMaterial)((Object)object)).parseMaterial().name();
                    if (((String)object4).endsWith("_ITEM")) {
                        object3 = ((String)object4).substring(0, ((String)object4).length() - 5);
                        object2 = Objects.requireNonNull(Material.getMaterial((String)object3), () -> XBlock.a((String)object4, (String)object3));
                        block.setType((Material)object2, bl);
                    } else if (((String)object4).contains("CAKE")) {
                        object3 = Material.getMaterial((String)"CAKE_BLOCK");
                        block.setType((Material)object3, bl);
                    }
                    object3 = LegacyMaterial.a.get((String)object4);
                    if (object3 == LegacyMaterial.BANNER) {
                        block.setType(LegacyMaterial.STANDING_BANNER.b, bl);
                    }
                    object2 = object3 == null ? null : ((LegacyMaterial)((Object)object3)).c;
                    block = block.getState();
                    n = 0;
                    if (object2 != LegacyMaterial.Handling.COLORABLE) break block38;
                    if (block instanceof Banner) {
                        int n2;
                        Banner banner = (Banner)block;
                        String string = ((String)(object = ((Enum)object).name())).substring(0, n2 = ((String)object).indexOf(95));
                        if (string.equals("LIGHT")) {
                            string = ((String)object).substring(0, 6 + 4);
                        }
                        banner.setBaseColor(DyeColor.valueOf((String)string));
                    } else {
                        block.setRawData(((XMaterial)((Object)object)).getData());
                    }
                    n = 1;
                    break block39;
                }
                if (object2 != LegacyMaterial.Handling.WOOD_SPECIES) break block40;
                String string = ((Enum)object).name();
                int n3 = string.indexOf(95);
                if (n3 < 0) {
                    return false;
                }
                object2 = string.substring(0, n3);
                switch (object2) {
                    case "OAK": {
                        object2 = TreeSpecies.GENERIC;
                        break;
                    }
                    case "DARK": {
                        object2 = TreeSpecies.DARK_OAK;
                        break;
                    }
                    case "SPRUCE": {
                        object2 = TreeSpecies.REDWOOD;
                        break;
                    }
                    default: {
                        try {
                            object2 = TreeSpecies.valueOf((String)object2);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new AssertionError((Object)("Unknown material " + object3 + " for wood species"));
                        }
                    }
                }
                boolean bl2 = false;
                switch (1.$SwitchMap$com$cryptomorin$xseries$XBlock$LegacyMaterial[((Enum)object3).ordinal()]) {
                    case 1: 
                    case 2: {
                        block.setRawData(object2.getData());
                        n = 1;
                        break block39;
                    }
                    case 3: 
                    case 4: {
                        bl2 = true;
                    }
                    case 5: 
                    case 6: {
                        switch (1.$SwitchMap$org$bukkit$TreeSpecies[object2.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (!bl2) {
                                    throw new AssertionError((Object)("Invalid tree species " + (Object)object2 + " for block type" + object3 + ", use block type 2 instead"));
                                }
                                break;
                            }
                            case 5: 
                            case 6: {
                                if (bl2) {
                                    throw new AssertionError((Object)("Invalid tree species " + (Object)object2 + " for block type 2 " + object3 + ", use block type instead"));
                                }
                                break;
                            }
                        }
                        Block block2 = block;
                        block2.setRawData((byte)(block2.getRawData() & 0xC | object2.getData() & 3));
                        n = 1;
                        break block39;
                    }
                    case 7: 
                    case 8: {
                        Block block3 = block;
                        block3.setRawData((byte)(block3.getRawData() & 8 | object2.getData()));
                        n = 1;
                        break block39;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown block type " + object3 + " for tree species: " + (Object)object2));
                    }
                }
            }
            if (((XMaterial)((Object)object)).getData() != 0) {
                block.setRawData(((XMaterial)((Object)object)).getData());
                n = 1;
            }
        }
        if (n != 0) {
            block.update(false, bl);
        }
        return n != 0;
    }

    public static boolean setType(@Nonnull Block block, @Nullable XMaterial xMaterial) {
        return XBlock.setType(block, xMaterial, true);
    }

    public static int getAge(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return 0;
            }
            block = (Ageable)block.getBlockData();
            return block.getAge();
        }
        block = block.getState();
        block = block.getData();
        return block.getData();
    }

    public static void setAge(Block block, int n) {
        MaterialData materialData;
        BlockState blockState;
        if (a) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return;
            }
            blockState = block.getBlockData();
            materialData = (Ageable)blockState;
            materialData.setAge(n);
            block.setBlockData((BlockData)blockState, false);
        }
        blockState = block.getState();
        materialData = blockState.getData();
        materialData.setData((byte)n);
        blockState.update(true);
    }

    public static boolean setColor(Block block, DyeColor dyeColor) {
        if (a) {
            String string = block.getType().name();
            int n = string.indexOf(95);
            if (n == -1) {
                return false;
            }
            string = string.substring(n);
            if ((dyeColor = Material.getMaterial((String)(dyeColor.name() + '_' + string))) == null) {
                return false;
            }
            block.setType((Material)dyeColor);
            return true;
        }
        BlockState blockState = block.getState();
        blockState.setRawData(dyeColor.getWoolData());
        blockState.update(true);
        return false;
    }

    public static boolean setFluidLevel(Block block, int n) {
        if (a) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return false;
            }
            BlockData blockData = block.getBlockData();
            Levelled levelled = (Levelled)blockData;
            levelled.setLevel(n);
            block.setBlockData(blockData, false);
            return true;
        }
        BlockState blockState = block.getState();
        MaterialData materialData = blockState.getData();
        materialData.setData((byte)n);
        blockState.update(true);
        return false;
    }

    public static int getFluidLevel(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return -1;
            }
            block = (Levelled)block.getBlockData();
            return block.getLevel();
        }
        block = block.getState();
        block = block.getData();
        return block.getData();
    }

    public static boolean isWaterStationary(Block block) {
        if (a) {
            return XBlock.getFluidLevel(block) < 7;
        }
        return block.getType() == BlockMaterial.STATIONARY_WATER.a;
    }

    public static boolean isWater(Material material) {
        return material == Material.WATER || material == BlockMaterial.STATIONARY_WATER.a;
    }

    public static boolean isLava(Material material) {
        return material == Material.LAVA || material == BlockMaterial.STATIONARY_LAVA.a;
    }

    public static boolean isOneOf(Block block, Collection<String> object) {
        if (object == null || object.isEmpty()) {
            return false;
        }
        String string = block.getType().name();
        XMaterial xMaterial = XMaterial.matchXMaterial(block.getType());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            String string2 = ((String)object2).toUpperCase(Locale.ENGLISH);
            if (!(string2.startsWith("CONTAINS:") ? string.contains((CharSequence)(object2 = XMaterial.format(string2.substring(9)))) : (string2.startsWith("REGEX:") ? string.matches((String)(object2 = ((String)object2).substring(6))) : ((Optional)(object2 = XMaterial.matchXMaterial((String)object2))).isPresent() && (xMaterial == ((Optional)object2).get() || XBlock.isType(block, (XMaterial)((Object)((Optional)object2).get())))))) continue;
            return true;
        }
        return false;
    }

    public static void setCakeSlices(Block block, int n) {
        if (!XBlock.isCake(block.getType())) {
            throw new IllegalArgumentException("Block is not a cake: " + block.getType());
        }
        if (a) {
            BlockData blockData = block.getBlockData();
            org.bukkit.block.data.type.Cake cake = (org.bukkit.block.data.type.Cake)blockData;
            n = cake.getMaximumBites() - (cake.getBites() + n);
            if (n > 0) {
                cake.setBites(n);
                block.setBlockData(blockData);
                return;
            }
            block.breakNaturally();
            return;
        }
        BlockState blockState = block.getState();
        Cake cake = (Cake)blockState.getData();
        if (n > 0) {
            cake.setSlicesRemaining(n);
            blockState.update(true);
            return;
        }
        block.breakNaturally();
    }

    public static int addCakeSlices(Block block, int n) {
        if (!XBlock.isCake(block.getType())) {
            throw new IllegalArgumentException("Block is not a cake: " + block.getType());
        }
        if (a) {
            BlockData blockData = block.getBlockData();
            org.bukkit.block.data.type.Cake cake = (org.bukkit.block.data.type.Cake)blockData;
            n = cake.getBites() - n;
            int n2 = cake.getMaximumBites() - n;
            if (n2 > 0) {
                cake.setBites(n);
                block.setBlockData(blockData);
                return n2;
            }
            block.breakNaturally();
            return 0;
        }
        BlockState blockState = block.getState();
        Cake cake = (Cake)blockState.getData();
        n = cake.getSlicesRemaining() + n;
        if (n > 0) {
            cake.setSlicesRemaining(n);
            blockState.update(true);
            return n;
        }
        block.breakNaturally();
        return 0;
    }

    public static void setEnderPearlOnFrame(Block block, boolean bl) {
        block = block.getState();
        if (a) {
            BlockData blockData = block.getBlockData();
            EndPortalFrame endPortalFrame = (EndPortalFrame)blockData;
            endPortalFrame.setEye(bl);
            block.setBlockData(blockData);
        } else {
            block.setRawData((byte)(bl ? 4 : 0));
        }
        block.update(true);
    }

    @Deprecated
    public static XMaterial getType(Block block) {
        byte by;
        if (a) {
            return XMaterial.matchXMaterial(block.getType());
        }
        String string = block.getType().name();
        BlockState blockState = block.getState();
        if ((blockState = blockState.getData()) instanceof Wood) {
            blockState = ((Wood)blockState).getSpecies();
            by = blockState.getData();
        } else if (blockState instanceof Colorable) {
            blockState = ((Colorable)blockState).getColor();
            by = blockState.getDyeData();
        } else {
            by = blockState.getData();
        }
        return XMaterial.matchDefinedXMaterial(string, by).orElseThrow(() -> new IllegalArgumentException("Unsupported material for block " + by + ": " + block.getType().name()));
    }

    public static boolean isSimilar(Block block, XMaterial xMaterial) {
        return xMaterial == XMaterial.matchXMaterial(block.getType()) || XBlock.isType(block, xMaterial);
    }

    public static boolean isType(Block block, XMaterial xMaterial) {
        block = block.getType();
        switch (xMaterial) {
            case CAKE: {
                return XBlock.isCake((Material)block);
            }
            case NETHER_WART: {
                return XBlock.isNetherWart((Material)block);
            }
            case MELON: 
            case MELON_SLICE: {
                return XBlock.isMelon((Material)block);
            }
            case CARROT: 
            case CARROTS: {
                return XBlock.isCarrot((Material)block);
            }
            case POTATO: 
            case POTATOES: {
                return XBlock.isPotato((Material)block);
            }
            case WHEAT: 
            case WHEAT_SEEDS: {
                return XBlock.isWheat((Material)block);
            }
            case BEETROOT: 
            case BEETROOT_SEEDS: 
            case BEETROOTS: {
                return XBlock.isBeetroot((Material)block);
            }
            case SUGAR_CANE: {
                return XBlock.isSugarCane((Material)block);
            }
            case WATER: {
                return XBlock.isWater((Material)block);
            }
            case LAVA: {
                return XBlock.isLava((Material)block);
            }
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return XBlock.isAir((Material)block);
            }
        }
        return false;
    }

    public static boolean isAir(@Nullable Material material) {
        if (a) {
            switch (material) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    return true;
                }
            }
            return false;
        }
        return material == Material.AIR;
    }

    public static boolean isPowered(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return false;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            return powerable.isPowered();
        }
        String string = block.getType().name();
        if (string.startsWith("REDSTONE_COMPARATOR")) {
            return block.getType() == BlockMaterial.REDSTONE_COMPARATOR_ON.a;
        }
        return false;
    }

    public static void setPowered(Block block, boolean bl) {
        if (a) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return;
            }
            BlockData blockData = block.getBlockData();
            Powerable powerable = (Powerable)blockData;
            powerable.setPowered(bl);
            block.setBlockData(blockData, false);
            return;
        }
        String string = block.getType().name();
        if (string.startsWith("REDSTONE_COMPARATOR")) {
            block.setType(BlockMaterial.REDSTONE_COMPARATOR_ON.a);
        }
    }

    public static boolean isOpen(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Openable)) {
                return false;
            }
            block = (Openable)block.getBlockData();
            return block.isOpen();
        }
        if (!((block = block.getState()) instanceof org.bukkit.material.Openable)) {
            return false;
        }
        block = (org.bukkit.material.Openable)block.getData();
        return block.isOpen();
    }

    public static void setOpened(Block block, boolean bl) {
        if (a) {
            if (!(block.getBlockData() instanceof Openable)) {
                return;
            }
            BlockData blockData = block.getBlockData();
            Openable openable = (Openable)blockData;
            openable.setOpen(bl);
            block.setBlockData(blockData, false);
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof org.bukkit.material.Openable)) {
            return;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)blockState.getData();
        openable.setOpen(bl);
        blockState.setData((MaterialData)openable);
        blockState.update();
    }

    public static BlockFace getRotation(Block block) {
        if (a) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return null;
            }
            block = (Rotatable)block.getBlockData();
            return block.getRotation();
        }
        return null;
    }

    public static void setRotation(Block block, BlockFace blockFace) {
        if (a) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return;
            }
            BlockData blockData = block.getBlockData();
            Rotatable rotatable = (Rotatable)blockData;
            rotatable.setRotation(blockFace);
            block.setBlockData(blockData, false);
        }
    }

    private static boolean a(Block block, BlockMaterial ... blockMaterialArray) {
        block = block.getType();
        for (int i = 0; i < 3; ++i) {
            BlockMaterial blockMaterial = blockMaterialArray[i];
            if (block != blockMaterial.a) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ String a(String string, String string2) {
        return "Could not find block material for item '" + string + "' as '" + string2 + '\'';
    }

    static {
        b.put(XMaterial.MELON_SLICE, XMaterial.MELON_STEM);
        b.put(XMaterial.MELON_SEEDS, XMaterial.MELON_STEM);
        b.put(XMaterial.CARROT_ON_A_STICK, XMaterial.CARROTS);
        b.put(XMaterial.GOLDEN_CARROT, XMaterial.CARROTS);
        b.put(XMaterial.CARROT, XMaterial.CARROTS);
        b.put(XMaterial.POTATO, XMaterial.POTATOES);
        b.put(XMaterial.BAKED_POTATO, XMaterial.POTATOES);
        b.put(XMaterial.POISONOUS_POTATO, XMaterial.POTATOES);
        b.put(XMaterial.PUMPKIN_SEEDS, XMaterial.PUMPKIN_STEM);
        b.put(XMaterial.PUMPKIN_PIE, XMaterial.PUMPKIN);
    }

    public static enum BlockMaterial {
        CAKE_BLOCK,
        CROPS,
        SUGAR_CANE_BLOCK,
        BEETROOT_BLOCK,
        NETHER_WARTS,
        MELON_BLOCK,
        BURNING_FURNACE,
        STATIONARY_WATER,
        STATIONARY_LAVA,
        REDSTONE_LAMP_ON,
        REDSTONE_LAMP_OFF,
        REDSTONE_TORCH_ON,
        REDSTONE_TORCH_OFF,
        REDSTONE_COMPARATOR_ON,
        REDSTONE_COMPARATOR_OFF;

        @Nullable
        private final Material a = Material.getMaterial((String)this.name());

        private static /* synthetic */ BlockMaterial[] a() {
            return new BlockMaterial[]{CAKE_BLOCK, CROPS, SUGAR_CANE_BLOCK, BEETROOT_BLOCK, NETHER_WARTS, MELON_BLOCK, BURNING_FURNACE, STATIONARY_WATER, STATIONARY_LAVA, REDSTONE_LAMP_ON, REDSTONE_LAMP_OFF, REDSTONE_TORCH_ON, REDSTONE_TORCH_OFF, REDSTONE_COMPARATOR_ON, REDSTONE_COMPARATOR_OFF};
        }
    }

    private static enum LegacyMaterial {
        STANDING_BANNER(Handling.COLORABLE),
        WALL_BANNER(Handling.COLORABLE),
        BANNER(Handling.COLORABLE),
        CARPET(Handling.COLORABLE),
        WOOL(Handling.COLORABLE),
        STAINED_CLAY(Handling.COLORABLE),
        STAINED_GLASS(Handling.COLORABLE),
        STAINED_GLASS_PANE(Handling.COLORABLE),
        THIN_GLASS(Handling.COLORABLE),
        WOOD(Handling.WOOD_SPECIES),
        WOOD_STEP(Handling.WOOD_SPECIES),
        WOOD_DOUBLE_STEP(Handling.WOOD_SPECIES),
        LEAVES(Handling.WOOD_SPECIES),
        LEAVES_2(Handling.WOOD_SPECIES),
        LOG(Handling.WOOD_SPECIES),
        LOG_2(Handling.WOOD_SPECIES),
        SAPLING(Handling.WOOD_SPECIES);

        private static final Map<String, LegacyMaterial> a;
        private final Material b = Material.getMaterial((String)this.name());
        private final Handling c;

        private LegacyMaterial(Handling handling) {
            this.c = handling;
        }

        private static LegacyMaterial b(String string) {
            return a.get(string);
        }

        private static /* synthetic */ LegacyMaterial[] a() {
            return new LegacyMaterial[]{STANDING_BANNER, WALL_BANNER, BANNER, CARPET, WOOL, STAINED_CLAY, STAINED_GLASS, STAINED_GLASS_PANE, THIN_GLASS, WOOD, WOOD_STEP, WOOD_DOUBLE_STEP, LEAVES, LEAVES_2, LOG, LOG_2, SAPLING};
        }

        static {
            a = new HashMap<String, LegacyMaterial>();
            for (LegacyMaterial legacyMaterial : LegacyMaterial.values()) {
                a.put(legacyMaterial.name(), legacyMaterial);
            }
        }

        private static enum Handling {
            COLORABLE,
            WOOD_SPECIES;


            private static /* synthetic */ Handling[] a() {
                return new Handling[]{COLORABLE, WOOD_SPECIES};
            }
        }
    }
}

