/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.enchanthandler.effects.changearrow;

import java.util.HashMap;
import java.util.Map;
import net.advancedplugins.ae.Core;
import net.advancedplugins.ae.enchanthandler.effects.changearrow.ArrowLandAction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;

public class PacketChangeArrow
implements Listener {
    private static PacketChangeArrow instance;
    private final Map<Projectile, PacketArrowChange> arrowChanges = new HashMap<Projectile, PacketArrowChange>();

    public static PacketChangeArrow getInstance() {
        return instance;
    }

    public PacketChangeArrow() {
        instance = this;
    }

    @EventHandler
    public void onArrowLand(ProjectileHitEvent projectileHitEvent) {
        if (projectileHitEvent.getEntityType() != EntityType.ARROW) {
            return;
        }
        Arrow arrow = (Arrow)projectileHitEvent.getEntity();
        if (!this.arrowChanges.containsKey(arrow)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Core.getInstance(), () -> {
            block5: {
                PacketArrowChange packetArrowChange;
                block4: {
                    packetArrowChange = this.arrowChanges.remove(arrow);
                    int[] nArray = ArrowLandAction.b();
                    if (packetArrowChange.landAction != ArrowLandAction.SUMMON) break block4;
                    packetArrowChange.getProjectile().remove();
                    packetArrowChange.getProjectile().getWorld().spawnEntity(packetArrowChange.getProjectile().getLocation(), packetArrowChange.getEntityType());
                    if (nArray != null) break block5;
                }
                if (packetArrowChange.landAction == ArrowLandAction.REMOVE) {
                    packetArrowChange.getProjectile().remove();
                }
            }
        }, 1L);
    }

    public void startPacketTracking(Projectile projectile, EntityType entityType, int n, ArrowLandAction arrowLandAction) {
        PacketArrowChange packetArrowChange = new PacketArrowChange(projectile, entityType, n, arrowLandAction);
        this.arrowChanges.put(projectile, packetArrowChange);
    }

    private static class PacketArrowChange {
        private final Projectile a;
        private final EntityType et;
        private final int entityId;
        private final ArrowLandAction landAction;

        public PacketArrowChange(Projectile projectile, EntityType entityType, int n, ArrowLandAction arrowLandAction) {
            this.a = projectile;
            this.et = entityType;
            this.entityId = n;
            this.landAction = arrowLandAction;
        }

        public Projectile getProjectile() {
            return this.a;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public EntityType getEntityType() {
            return this.et;
        }
    }
}

