/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.handlers.lootPopulation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.ae.handlers.lootPopulation.PopulationHandler;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootMapType;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootType;

public class LootMap {
    private ImmutableMap<LootType, Integer> chancesMap;
    private final boolean enabled;
    private double generationChance;
    private final LootMapType lootMapType;
    private boolean tradeAllLoot;
    private int maxItemsPerContainer;
    private ImmutableList<LootType> finalLootChances;
    private static final String[] a;

    public LootMap(LootMapType lootMapType, PopulationHandler populationHandler) {
        String[] stringArray = PopulationHandler.b();
        this.lootMapType = lootMapType;
        String[] stringArray2 = stringArray;
        this.enabled = populationHandler.getPopFile().get().getBoolean(lootMapType.getEnabledPath());
        if (!this.enabled) {
            return;
        }
        this.chancesMap = populationHandler.readChances(lootMapType);
        this.generationChance = populationHandler.getPopFile().get().getInt(lootMapType.getGenerationChance());
        switch (lootMapType) {
            case VILLAGER: {
                String[] stringArray3 = a;
                this.tradeAllLoot = populationHandler.getPopFile().get().getBoolean(stringArray3[1]);
                if (stringArray2 != null) break;
            }
            case RANDOM_LOOT: {
                this.maxItemsPerContainer = populationHandler.getPopFile().get().getInt(a[0]);
            }
        }
        this.generateLootChances();
    }

    private void generateLootChances() {
        ArrayList<LootType> arrayList;
        block3: {
            LootMap lootMap;
            arrayList = new ArrayList<LootType>();
            UnmodifiableIterator unmodifiableIterator = this.chancesMap.entrySet().iterator();
            String[] stringArray = PopulationHandler.b();
            block0: while (unmodifiableIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)unmodifiableIterator.next();
                lootMap = this;
                if (stringArray != null) {
                    if (lootMap.lootMapType == LootMapType.VILLAGER && !this.shouldTradeAllLoot() && !((LootType)((Object)entry.getKey())).equals((Object)LootType.RANDOM_ENCHANT_BOOK) && stringArray != null) continue;
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        arrayList.add((LootType)((Object)entry.getKey()));
                        if (stringArray == null) continue block0;
                        if (stringArray != null) continue;
                    }
                    if (stringArray != null) continue;
                }
                break block3;
            }
            lootMap = this;
        }
        lootMap.finalLootChances = ImmutableList.copyOf(arrayList);
    }

    public LootType getRandomLoot() {
        if (this.getGenerationChance() < (double)(ThreadLocalRandom.current().nextInt(100) + 1)) {
            return null;
        }
        if (this.finalLootChances.size() <= 0) {
            return null;
        }
        if (this.finalLootChances.size() < 2) {
            return (LootType)((Object)this.finalLootChances.get(0));
        }
        return (LootType)((Object)this.finalLootChances.get(ThreadLocalRandom.current().nextInt(this.finalLootChances.size())));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getGenerationChance() {
        return this.generationChance;
    }

    public ImmutableMap<LootType, Integer> getChancesMap() {
        return this.chancesMap;
    }

    public int getMaxItemsPerContainer() {
        return this.maxItemsPerContainer;
    }

    public boolean shouldTradeAllLoot() {
        return this.tradeAllLoot;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "\u0004s~K\u000fK\u0019\u0019}d\u0001\rG-?fuB\u0013v0\u0004Q\u007fA\u0014G<\u0018wb\u001b\u0000{|C\u0001A0\u0004FbN\u0004C&XfbN\u0004C\u0014\u001a~\\@\u000fR";
        int n2 = "\u0004s~K\u000fK\u0019\u0019}d\u0001\rG-?fuB\u0013v0\u0004Q\u007fA\u0014G<\u0018wb\u001b\u0000{|C\u0001A0\u0004FbN\u0004C&XfbN\u0004C\u0014\u001a~\\@\u000fR".length();
        int n3 = 31;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            stringArray[n++] = LootMap.a(121, LootMap.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) {
                a = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x2C);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 15;
                        break;
                    }
                    case 1: {
                        n5 = 107;
                        break;
                    }
                    case 2: {
                        n5 = 105;
                        break;
                    }
                    case 3: {
                        n5 = 86;
                        break;
                    }
                    case 4: {
                        n5 = 25;
                        break;
                    }
                    case 5: {
                        n5 = 95;
                        break;
                    }
                    default: {
                        n5 = 44;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

