/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.SaddlePointExpansion;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Beta;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int n, double d) {
        this(new Well19937c(), n, d);
    }

    public BinomialDistribution(RandomGenerator randomGenerator, int n, double d) {
        block5: {
            super(randomGenerator);
            if (n < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n);
            }
            try {
                try {
                    if (!(d < 0.0) && !(d > 1.0)) break block5;
                }
                catch (NotPositiveException notPositiveException) {
                    throw BinomialDistribution.b(notPositiveException);
                }
                throw new OutOfRangeException(d, (Number)0, 1);
            }
            catch (NotPositiveException notPositiveException) {
                throw BinomialDistribution.b(notPositiveException);
            }
        }
        this.probabilityOfSuccess = d;
        this.numberOfTrials = n;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int n) {
        double d;
        double d2 = this.logProbability(n);
        try {
            d = d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
        }
        catch (NotPositiveException notPositiveException) {
            throw BinomialDistribution.b(notPositiveException);
        }
        return d;
    }

    public double logProbability(int n) {
        double d;
        block12: {
            block11: {
                String string;
                block8: {
                    double d2;
                    block10: {
                        block9: {
                            string = AbstractRealDistribution.b();
                            try {
                                try {
                                    if (this.numberOfTrials != 0) break block8;
                                    if (n != 0) break block9;
                                }
                                catch (NotPositiveException notPositiveException) {
                                    throw BinomialDistribution.b(notPositiveException);
                                }
                                d2 = 0.0;
                                break block10;
                            }
                            catch (NotPositiveException notPositiveException) {
                                throw BinomialDistribution.b(notPositiveException);
                            }
                        }
                        d2 = Double.NEGATIVE_INFINITY;
                    }
                    return d2;
                }
                try {
                    if (n >= 0 && n <= this.numberOfTrials) break block11;
                }
                catch (NotPositiveException notPositiveException) {
                    throw BinomialDistribution.b(notPositiveException);
                }
                d = Double.NEGATIVE_INFINITY;
                if (string == null) break block12;
            }
            d = SaddlePointExpansion.logBinomialProbability(n, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public double cumulativeProbability(int var1_1) {
        block4: {
            block5: {
                var2_2 = AbstractRealDistribution.b();
                if (var1_1 >= 0) ** GOTO lbl6
                var3_3 = 0.0;
                try {
                    if (var2_2 == null) break block4;
lbl6:
                    // 2 sources

                    if (var1_1 < this.numberOfTrials) break block5;
                }
                catch (NotPositiveException v0) {
                    throw BinomialDistribution.b(v0);
                }
                var3_3 = 1.0;
                if (var2_2 == null) break block4;
            }
            var3_3 = 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)var1_1 + 1.0, this.numberOfTrials - var1_1);
        }
        return var3_3;
    }

    public double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    public double getNumericalVariance() {
        double d = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * d * (1.0 - d);
    }

    public int getSupportLowerBound() {
        int n;
        try {
            n = this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
        }
        catch (NotPositiveException notPositiveException) {
            throw BinomialDistribution.b(notPositiveException);
        }
        return n;
    }

    public int getSupportUpperBound() {
        int n;
        try {
            n = this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
        }
        catch (NotPositiveException notPositiveException) {
            throw BinomialDistribution.b(notPositiveException);
        }
        return n;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotPositiveException b(NotPositiveException notPositiveException) {
        return notPositiveException;
    }
}

