/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalStateException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NullArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooSmallException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.util.DoubleArray;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathArrays;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathUtils;

public class ResizableDoubleArray
implements DoubleArray,
Serializable {
    @Deprecated
    public static final int ADDITIVE_MODE = 1;
    @Deprecated
    public static final int MULTIPLICATIVE_MODE = 0;
    private static final long serialVersionUID = -3485529955529426875L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final double DEFAULT_EXPANSION_FACTOR = 2.0;
    private static final double DEFAULT_CONTRACTION_DELTA = 0.5;
    private double contractionCriterion;
    private double expansionFactor;
    private ExpansionMode expansionMode;
    private double[] internalArray;
    private int numElements;
    private int startIndex;
    private static final String[] a;

    public ResizableDoubleArray() {
        this(16);
    }

    public ResizableDoubleArray(int n) throws MathIllegalArgumentException {
        this(n, 2.0);
    }

    public ResizableDoubleArray(double[] dArray) {
        this(16, 2.0, 2.5, ExpansionMode.MULTIPLICATIVE, dArray);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f) throws MathIllegalArgumentException {
        this(n, (double)f);
    }

    public ResizableDoubleArray(int n, double d) throws MathIllegalArgumentException {
        this(n, d, 0.5 + d);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2) throws MathIllegalArgumentException {
        this(n, (double)f, (double)f2);
    }

    public ResizableDoubleArray(int n, double d, double d2) throws MathIllegalArgumentException {
        this(n, d, d2, ExpansionMode.MULTIPLICATIVE, null);
    }

    @Deprecated
    public ResizableDoubleArray(int n, float f, float f2, int n2) throws MathIllegalArgumentException {
        this(n, f, f2, n2 == 1 ? ExpansionMode.ADDITIVE : ExpansionMode.MULTIPLICATIVE, null);
        this.setExpansionMode(n2);
    }

    public ResizableDoubleArray(int n, double d, double d2, ExpansionMode expansionMode, double ... dArray) throws MathIllegalArgumentException {
        block5: {
            this.contractionCriterion = 2.5;
            this.expansionFactor = 2.0;
            this.expansionMode = ExpansionMode.MULTIPLICATIVE;
            this.numElements = 0;
            this.startIndex = 0;
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INITIAL_CAPACITY_NOT_POSITIVE, n);
            }
            try {
                try {
                    this.checkContractExpand(d2, d);
                    this.expansionFactor = d;
                    this.contractionCriterion = d2;
                    this.expansionMode = expansionMode;
                    this.internalArray = new double[n];
                    this.numElements = 0;
                    this.startIndex = 0;
                    if (dArray == null || dArray.length <= 0) break block5;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
                this.addElements(dArray);
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw ResizableDoubleArray.b(mathIllegalArgumentException);
            }
        }
    }

    public ResizableDoubleArray(ResizableDoubleArray resizableDoubleArray) throws NullArgumentException {
        this.contractionCriterion = 2.5;
        this.expansionFactor = 2.0;
        this.expansionMode = ExpansionMode.MULTIPLICATIVE;
        this.numElements = 0;
        this.startIndex = 0;
        MathUtils.checkNotNull(resizableDoubleArray);
        ResizableDoubleArray.copy(resizableDoubleArray, this);
    }

    public synchronized void addElement(double d) {
        try {
            if (this.internalArray.length <= this.startIndex + this.numElements) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.internalArray[this.startIndex + this.numElements++] = d;
    }

    public synchronized void addElements(double[] dArray) {
        double[] dArray2 = new double[this.numElements + dArray.length + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray2, 0, this.numElements);
        System.arraycopy(dArray, 0, dArray2, this.numElements, dArray.length);
        this.internalArray = dArray2;
        this.startIndex = 0;
        this.numElements += dArray.length;
    }

    public synchronized double addElementRolling(double d) {
        double d2 = this.internalArray[this.startIndex];
        try {
            if (this.startIndex + (this.numElements + 1) > this.internalArray.length) {
                this.expand();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            ++this.startIndex;
            this.internalArray[this.startIndex + (this.numElements - 1)] = d;
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return d2;
    }

    public synchronized double substituteMostRecentElement(double d) throws MathIllegalStateException {
        try {
            if (this.numElements < 1) {
                throw new MathIllegalStateException(LocalizedFormats.CANNOT_SUBSTITUTE_ELEMENT_FROM_EMPTY_ARRAY, new Object[0]);
            }
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            throw ResizableDoubleArray.b(mathIllegalStateException);
        }
        int n = this.startIndex + (this.numElements - 1);
        double d2 = this.internalArray[n];
        this.internalArray[n] = d;
        return d2;
    }

    @Deprecated
    protected void checkContractExpand(float f, float f2) throws MathIllegalArgumentException {
        this.checkContractExpand((double)f, (double)f2);
    }

    protected void checkContractExpand(double d, double d2) throws NumberIsTooSmallException {
        if (d < d2) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, true);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_EXPANSION_FACTOR, d, d2);
            throw numberIsTooSmallException;
        }
        if (d <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.CONTRACTION_CRITERIA_SMALLER_THAN_ONE, d);
            throw numberIsTooSmallException;
        }
        if (d2 <= 1.0) {
            NumberIsTooSmallException numberIsTooSmallException = new NumberIsTooSmallException(d, (Number)1, false);
            numberIsTooSmallException.getContext().addMessage(LocalizedFormats.EXPANSION_FACTOR_SMALLER_THAN_ONE, d2);
            throw numberIsTooSmallException;
        }
    }

    public synchronized void clear() {
        this.numElements = 0;
        this.startIndex = 0;
    }

    public synchronized void contract() {
        double[] dArray = new double[this.numElements + 1];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        this.internalArray = dArray;
        this.startIndex = 0;
    }

    public synchronized void discardFrontElements(int n) throws MathIllegalArgumentException {
        this.discardExtremeElements(n, true);
    }

    public synchronized void discardMostRecentElements(int n) throws MathIllegalArgumentException {
        this.discardExtremeElements(n, false);
    }

    private synchronized void discardExtremeElements(int n, boolean bl) throws MathIllegalArgumentException {
        try {
            if (n > this.numElements) {
                throw new MathIllegalArgumentException(LocalizedFormats.TOO_MANY_ELEMENTS_TO_DISCARD_FROM_ARRAY, n, this.numElements);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_DISCARD_NEGATIVE_NUMBER_OF_ELEMENTS, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            this.numElements -= n;
            if (bl) {
                this.startIndex += n;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.shouldContract()) {
                this.contract();
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
    }

    protected synchronized void expand() {
        int n = 0;
        n = this.expansionMode == ExpansionMode.MULTIPLICATIVE ? (int)FastMath.ceil((double)this.internalArray.length * this.expansionFactor) : (int)((long)this.internalArray.length + FastMath.round(this.expansionFactor));
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    private synchronized void expandTo(int n) {
        double[] dArray = new double[n];
        System.arraycopy(this.internalArray, 0, dArray, 0, this.internalArray.length);
        this.internalArray = dArray;
    }

    @Deprecated
    public float getContractionCriteria() {
        return (float)this.getContractionCriterion();
    }

    public double getContractionCriterion() {
        return this.contractionCriterion;
    }

    public synchronized double getElement(int n) {
        try {
            if (n >= this.numElements) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n >= 0) {
                return this.internalArray[this.startIndex + n];
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public synchronized double[] getElements() {
        double[] dArray = new double[this.numElements];
        System.arraycopy(this.internalArray, this.startIndex, dArray, 0, this.numElements);
        return dArray;
    }

    @Deprecated
    public float getExpansionFactor() {
        return (float)this.expansionFactor;
    }

    @Deprecated
    public int getExpansionMode() {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            switch (this.expansionMode) {
                case MULTIPLICATIVE: {
                    return 0;
                }
                case ADDITIVE: {
                    return 1;
                }
            }
            throw new MathInternalError();
        }
    }

    @Deprecated
    synchronized int getInternalLength() {
        return this.internalArray.length;
    }

    public int getCapacity() {
        return this.internalArray.length;
    }

    public synchronized int getNumElements() {
        return this.numElements;
    }

    @Deprecated
    public synchronized double[] getInternalValues() {
        return this.internalArray;
    }

    protected double[] getArrayRef() {
        return this.internalArray;
    }

    protected int getStartIndex() {
        return this.startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setContractionCriteria(float f) throws MathIllegalArgumentException {
        this.checkContractExpand(f, this.getExpansionFactor());
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.contractionCriterion = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compute(MathArrays.Function function) {
        int n;
        int n2;
        double[] dArray;
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            dArray = this.internalArray;
            n2 = this.startIndex;
            n = this.numElements;
        }
        return function.evaluate(dArray, n2, n);
    }

    public synchronized void setElement(int n, double d) {
        try {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (n + 1 > this.numElements) {
                this.numElements = n + 1;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (this.startIndex + n >= this.internalArray.length) {
                this.expandTo(this.startIndex + (n + 1));
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.internalArray[this.startIndex + n] = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionFactor(float f) throws MathIllegalArgumentException {
        this.checkContractExpand(this.getContractionCriterion(), (double)f);
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.expansionFactor = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public void setExpansionMode(int n) throws MathIllegalArgumentException {
        block14: {
            AdvancedEffect[] advancedEffectArray;
            block11: {
                advancedEffectArray = FastMath.b();
                if (n == 0) break block11;
                try {
                    block12: {
                        if (n == 1) break block11;
                        break block12;
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                    }
                    Object[] objectArray = new Object[5];
                    objectArray[0] = n;
                    objectArray[1] = 0;
                    String[] stringArray = a;
                    objectArray[2] = stringArray[0];
                    objectArray[3] = 1;
                    objectArray[4] = stringArray[1];
                    throw new MathIllegalArgumentException(LocalizedFormats.UNSUPPORTED_EXPANSION_MODE, objectArray);
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw ResizableDoubleArray.b(mathIllegalArgumentException);
                }
            }
            ResizableDoubleArray resizableDoubleArray = this;
            synchronized (resizableDoubleArray) {
                block13: {
                    if (n != 0) break block13;
                    this.setExpansionMode(ExpansionMode.MULTIPLICATIVE);
                    if (advancedEffectArray != null) break block14;
                }
                if (n == 1) {
                    this.setExpansionMode(ExpansionMode.ADDITIVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExpansionMode(ExpansionMode expansionMode) {
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            this.expansionMode = expansionMode;
        }
    }

    @Deprecated
    protected void setInitialCapacity(int n) throws MathIllegalArgumentException {
    }

    public synchronized void setNumElements(int n) throws MathIllegalArgumentException {
        try {
            if (n < 0) {
                throw new MathIllegalArgumentException(LocalizedFormats.INDEX_NOT_POSITIVE, n);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        int n2 = this.startIndex + n;
        try {
            if (n2 > this.internalArray.length) {
                this.expandTo(n2);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        this.numElements = n;
    }

    private synchronized boolean shouldContract() {
        boolean bl;
        block6: {
            boolean bl2;
            block8: {
                block7: {
                    try {
                        try {
                            if (this.expansionMode != ExpansionMode.MULTIPLICATIVE) break block6;
                            if (!((double)((float)this.internalArray.length / (float)this.numElements) > this.contractionCriterion)) break block7;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw ResizableDoubleArray.b(mathIllegalArgumentException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw ResizableDoubleArray.b(mathIllegalArgumentException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            bl = (double)(this.internalArray.length - this.numElements) > this.contractionCriterion;
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        return bl;
    }

    @Deprecated
    public synchronized int start() {
        return this.startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ResizableDoubleArray resizableDoubleArray, ResizableDoubleArray resizableDoubleArray2) throws NullArgumentException {
        MathUtils.checkNotNull(resizableDoubleArray);
        MathUtils.checkNotNull(resizableDoubleArray2);
        ResizableDoubleArray resizableDoubleArray3 = resizableDoubleArray;
        synchronized (resizableDoubleArray3) {
            ResizableDoubleArray resizableDoubleArray4 = resizableDoubleArray2;
            synchronized (resizableDoubleArray4) {
                resizableDoubleArray2.contractionCriterion = resizableDoubleArray.contractionCriterion;
                resizableDoubleArray2.expansionFactor = resizableDoubleArray.expansionFactor;
                resizableDoubleArray2.expansionMode = resizableDoubleArray.expansionMode;
                resizableDoubleArray2.internalArray = new double[resizableDoubleArray.internalArray.length];
                System.arraycopy(resizableDoubleArray.internalArray, 0, resizableDoubleArray2.internalArray, 0, resizableDoubleArray2.internalArray.length);
                resizableDoubleArray2.numElements = resizableDoubleArray.numElements;
                resizableDoubleArray2.startIndex = resizableDoubleArray.startIndex;
            }
        }
    }

    public synchronized ResizableDoubleArray copy() {
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray();
        ResizableDoubleArray.copy(this, resizableDoubleArray);
        return resizableDoubleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            if (object == this) {
                return true;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        try {
            if (!(object instanceof ResizableDoubleArray)) {
                return false;
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw ResizableDoubleArray.b(mathIllegalArgumentException);
        }
        ResizableDoubleArray resizableDoubleArray = this;
        synchronized (resizableDoubleArray) {
            Object object2 = object;
            synchronized (object2) {
                boolean bl = true;
                ResizableDoubleArray resizableDoubleArray2 = (ResizableDoubleArray)object;
                bl = bl && resizableDoubleArray2.contractionCriterion == this.contractionCriterion;
                bl = bl && resizableDoubleArray2.expansionFactor == this.expansionFactor;
                bl = bl && resizableDoubleArray2.expansionMode == this.expansionMode;
                bl = bl && resizableDoubleArray2.numElements == this.numElements;
                boolean bl2 = bl = bl && resizableDoubleArray2.startIndex == this.startIndex;
                if (!bl) {
                    return false;
                }
                return Arrays.equals(this.internalArray, resizableDoubleArray2.internalArray);
            }
        }
    }

    public synchronized int hashCode() {
        int[] nArray = new int[]{Double.valueOf(this.expansionFactor).hashCode(), Double.valueOf(this.contractionCriterion).hashCode(), this.expansionMode.hashCode(), Arrays.hashCode(this.internalArray), this.numElements, this.startIndex};
        return Arrays.hashCode(nArray);
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = "w\u0012UR\u0018N/s\u0004XR\u0018H&e\nVB\u0014\r{\u0003]O\u0005W5\u007f\u0018TI\u0015[";
        int n2 = "w\u0012UR\u0018N/s\u0004XR\u0018H&e\nVB\u0014\r{\u0003]O\u0005W5\u007f\u0018TI\u0015[".length();
        int n3 = 19;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            Object var6_6 = null;
            stringArray[n++] = ResizableDoubleArray.a(13, ResizableDoubleArray.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) break;
            n3 = string.charAt(n4);
        }
        a = stringArray;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x6E);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 55;
                        break;
                    }
                    case 1: {
                        n5 = 74;
                        break;
                    }
                    case 2: {
                        n5 = 20;
                        break;
                    }
                    case 3: {
                        n5 = 11;
                        break;
                    }
                    case 4: {
                        n5 = 92;
                        break;
                    }
                    case 5: {
                        n5 = 19;
                        break;
                    }
                    default: {
                        n5 = 110;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExpansionMode
    extends Enum<ExpansionMode> {
        public static final /* enum */ ExpansionMode MULTIPLICATIVE;
        public static final /* enum */ ExpansionMode ADDITIVE;
        private static final /* synthetic */ ExpansionMode[] $VALUES;

        public static ExpansionMode[] values() {
            return (ExpansionMode[])$VALUES.clone();
        }

        public static ExpansionMode valueOf(String string) {
            return Enum.valueOf(ExpansionMode.class, string);
        }

        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "=Rt?Q259Dy?Q4<\b1C|\"L+/5";
            int n2 = "=Rt?Q259Dy?Q4<\b1C|\"L+/5".length();
            int n3 = 14;
            int n4 = -1;
            while (true) {
                int n5 = ++n4;
                Object var7_6 = null;
                stringArray[n++] = ExpansionMode.a(19, ExpansionMode.a(string.substring(n5, n5 + n3)));
                if ((n4 += n3) >= n2) break;
                n3 = string.charAt(n4);
            }
            String[] stringArray2 = stringArray;
            MULTIPLICATIVE = new ExpansionMode();
            ADDITIVE = new ExpansionMode();
            $VALUES = new ExpansionMode[]{MULTIPLICATIVE, ADDITIVE};
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x6A);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 99;
                            break;
                        }
                        case 1: {
                            n5 = 20;
                            break;
                        }
                        case 2: {
                            n5 = 43;
                            break;
                        }
                        case 3: {
                            n5 = 120;
                            break;
                        }
                        case 4: {
                            n5 = 11;
                            break;
                        }
                        case 5: {
                            n5 = 113;
                            break;
                        }
                        default: {
                            n5 = 106;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }
}

