/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalNumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double g = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] i;
    private final double j;
    private final double f;
    private final double h;

    public ExponentialDistribution(double d) {
        this(d, 1.0E-9);
    }

    public ExponentialDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d) {
        this(randomGenerator, d, 1.0E-9);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.j = d;
        this.f = FastMath.log(d);
        this.h = d2;
    }

    public double getMean() {
        return this.j;
    }

    public double density(double d) {
        double d2;
        double d3 = this.logDensity(d);
        try {
            d2 = d3 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d3);
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return d2;
    }

    public double logDensity(double d) {
        try {
            if (d < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return -d / this.j - this.f;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.b();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (bl) break block3;
            }
            d2 = 1.0 - FastMath.exp(-d / this.j);
        }
        return d2;
    }

    public double inverseCumulativeProbability(double d) {
        double d2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    bl = AbstractRealDistribution.a();
                    try {
                        try {
                            if (!(d < 0.0) && !(d > 1.0)) break block6;
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw ExponentialDistribution.c(outOfRangeException);
                        }
                        throw new OutOfRangeException(d, (Number)0.0, 1.0);
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        throw ExponentialDistribution.c(outOfRangeException);
                    }
                }
                if (d != 1.0) break block7;
                d2 = Double.POSITIVE_INFINITY;
                if (!bl) break block8;
            }
            d2 = -this.j * FastMath.log(1.0 - d);
        }
        return d2;
    }

    public double sample() {
        double d;
        double d2;
        double d3;
        boolean bl;
        double d4;
        block10: {
            d4 = 0.0;
            bl = AbstractRealDistribution.a();
            for (d3 = this.d.nextDouble(); d3 < 0.5; d3 *= 2.0) {
                d4 += i[0];
                try {
                    if (!bl) {
                        if (!bl) continue;
                        break;
                    }
                    break block10;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ExponentialDistribution.c(notStrictlyPositiveException);
                }
            }
            d3 += d3 - 1.0;
        }
        try {
            if (d3 <= i[0]) {
                return this.j * (d4 + d3);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        int n = 0;
        double d5 = d2 = this.d.nextDouble();
        block5: while (true) {
            ++n;
            d2 = this.d.nextDouble();
            if (d2 < d5) {
                d = d5 = d2;
            }
            do {
                if (d3 > i[n]) continue block5;
                d = this.j * (d4 + d5 * i[0]);
            } while (bl);
            break;
        }
        return d;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.h;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double d = this.getMean();
        return d * d;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    static {
        double d = FastMath.log(2.0);
        double d2 = 0.0;
        int n = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d2 < 1.0) {
            resizableDoubleArray.addElement(d2 += FastMath.pow(d, n) / (double)CombinatoricsUtils.factorial(n));
            ++n;
        }
        i = resizableDoubleArray.getElements();
    }

    private static MathIllegalNumberException c(MathIllegalNumberException mathIllegalNumberException) {
        return mathIllegalNumberException;
    }
}

