/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.SaddlePointExpansion;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class HypergeometricDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -436928820673516179L;
    private final int f;
    private final int g;
    private final int c;
    private double e = Double.NaN;
    private boolean d = false;

    public HypergeometricDistribution(int n, int n2, int n3) {
        this(new Well19937c(), n, n2, n3);
    }

    public HypergeometricDistribution(RandomGenerator randomGenerator, int n, int n2, int n3) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.POPULATION_SIZE, n);
        }
        try {
            if (n2 < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n2);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n3 < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n3);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n2 > n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)n2, n, true);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n3 > n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE, (Number)n3, n, true);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        this.f = n2;
        this.g = n;
        this.c = n3;
    }

    /*
     * Unable to fully structure code
     */
    public double cumulativeProbability(int var1_1) {
        block4: {
            block5: {
                var5_2 = this.getDomain(this.g, this.f, this.c);
                var2_3 = AbstractRealDistribution.b();
                if (var1_1 >= var5_2[0]) ** GOTO lbl7
                var3_4 = 0.0;
                try {
                    if (var2_3) break block4;
lbl7:
                    // 2 sources

                    if (var1_1 < var5_2[1]) break block5;
                }
                catch (NotPositiveException v0) {
                    throw HypergeometricDistribution.b(v0);
                }
                var3_4 = 1.0;
                if (var2_3) break block4;
            }
            var3_4 = this.innerCumulativeProbability(var5_2[0], var1_1, 1);
        }
        return var3_4;
    }

    private int[] getDomain(int n, int n2, int n3) {
        return new int[]{this.getLowerDomain(n, n2, n3), this.getUpperDomain(n2, n3)};
    }

    private int getLowerDomain(int n, int n2, int n3) {
        return FastMath.max(0, n2 - (n - n3));
    }

    public int getNumberOfSuccesses() {
        return this.f;
    }

    public int getPopulationSize() {
        return this.g;
    }

    public int getSampleSize() {
        return this.c;
    }

    private int getUpperDomain(int n, int n2) {
        return FastMath.min(n2, n);
    }

    public double probability(int n) {
        double d;
        double d2 = this.logProbability(n);
        try {
            d = d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        return d;
    }

    public double logProbability(int n) {
        double d;
        block5: {
            block4: {
                int[] nArray = this.getDomain(this.g, this.f, this.c);
                boolean bl = AbstractRealDistribution.b();
                try {
                    if (n >= nArray[0] && n <= nArray[1]) break block4;
                }
                catch (NotPositiveException notPositiveException) {
                    throw HypergeometricDistribution.b(notPositiveException);
                }
                d = Double.NEGATIVE_INFINITY;
                if (bl) break block5;
            }
            double d2 = (double)this.c / (double)this.g;
            double d3 = (double)(this.g - this.c) / (double)this.g;
            double d4 = SaddlePointExpansion.logBinomialProbability(n, this.f, d2, d3);
            double d5 = SaddlePointExpansion.logBinomialProbability(this.c - n, this.g - this.f, d2, d3);
            double d6 = SaddlePointExpansion.logBinomialProbability(this.c, this.g, d2, d3);
            d = d4 + d5 - d6;
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public double upperCumulativeProbability(int var1_1) {
        block4: {
            block5: {
                var5_2 = this.getDomain(this.g, this.f, this.c);
                var2_3 = AbstractRealDistribution.a();
                if (var1_1 > var5_2[0]) ** GOTO lbl7
                var3_4 = 1.0;
                try {
                    if (!var2_3) break block4;
lbl7:
                    // 2 sources

                    if (var1_1 <= var5_2[1]) break block5;
                }
                catch (NotPositiveException v0) {
                    throw HypergeometricDistribution.b(v0);
                }
                var3_4 = 0.0;
                if (!var2_3) break block4;
            }
            var3_4 = this.innerCumulativeProbability(var5_2[1], var1_1, -1);
        }
        return var3_4;
    }

    private double innerCumulativeProbability(int n, int n2, int n3) {
        double d;
        block2: {
            double d2 = this.probability(n);
            boolean bl = AbstractRealDistribution.a();
            while (n != n2) {
                d = d2 + this.probability(n += n3);
                if (!bl) {
                    d2 = d;
                    if (!bl) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public double getNumericalMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    public double getNumericalVariance() {
        try {
            if (!this.d) {
                this.e = this.calculateNumericalVariance();
                this.d = true;
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        return this.e;
    }

    protected double calculateNumericalVariance() {
        double d = this.getPopulationSize();
        double d2 = this.getNumberOfSuccesses();
        double d3 = this.getSampleSize();
        return d3 * d2 * (d - d3) * (d - d2) / (d * d * (d - 1.0));
    }

    public int getSupportLowerBound() {
        return FastMath.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    public int getSupportUpperBound() {
        return FastMath.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotPositiveException b(NotPositiveException notPositiveException) {
        return notPositiveException;
    }
}

