/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.random;

import java.io.Serializable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public abstract class BitsStreamGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20130104L;
    private double c = Double.NaN;
    private static int b;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        boolean bl;
        try {
            bl = this.next(1) != 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw BitsStreamGenerator.b(illegalArgumentException);
        }
        return bl;
    }

    public double nextDouble() {
        long l = (long)this.next(26) << 26;
        int n = this.next(26);
        return (double)(l | (long)n) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double d;
        block3: {
            block2: {
                int n = BitsStreamGenerator.a();
                if (!Double.isNaN(this.c)) break block2;
                double d2 = this.nextDouble();
                double d3 = this.nextDouble();
                double d4 = Math.PI * 2 * d2;
                double d5 = FastMath.sqrt(-2.0 * FastMath.log(d3));
                d = d5 * FastMath.cos(d4);
                this.c = d5 * FastMath.sin(d4);
                if (n == 0) break block3;
            }
            d = this.c;
            this.c = Double.NaN;
        }
        return d;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        block6: {
            int n2;
            int n3;
            block7: {
                n3 = BitsStreamGenerator.a();
                try {
                    try {
                        if (n <= 0) break block6;
                        if ((n & -n) != n) break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw BitsStreamGenerator.b(illegalArgumentException);
                    }
                    return (int)((long)n * (long)this.next(31) >> 31);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw BitsStreamGenerator.b(illegalArgumentException);
                }
            }
            block4: while (true) {
                int n4 = this.next(31);
                int n5 = n4 % n;
                n2 = n4 - n5 + (n - 1);
                do {
                    if (n2 < 0) continue block4;
                    n2 = n5;
                } while (n3 != 0);
                break;
            }
            return n2;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public long nextLong() {
        long l = (long)this.next(32) << 32;
        long l2 = (long)this.next(32) & 0xFFFFFFFFL;
        return l | l2;
    }

    public long nextLong(long l) {
        int n = BitsStreamGenerator.b();
        if (l > 0L) {
            long l2;
            block0: while (true) {
                long l3 = (long)this.next(31) << 32;
                long l4 = (l3 |= (long)this.next(32) & 0xFFFFFFFFL) % l;
                l2 = l3 - l4 + (l - 1L);
                do {
                    if (l2 < 0L) continue block0;
                    l2 = l4;
                } while (n == 0);
                break;
            }
            return l2;
        }
        throw new NotStrictlyPositiveException(l);
    }

    public void clear() {
        this.c = Double.NaN;
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytesFill(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        block9: {
            block8: {
                try {
                    try {
                        if (n >= 0 && n < byArray.length) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw BitsStreamGenerator.b(illegalArgumentException);
                    }
                    throw new OutOfRangeException(n, (Number)0, byArray.length);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw BitsStreamGenerator.b(illegalArgumentException);
                }
            }
            try {
                try {
                    if (n2 >= 0 && n2 <= byArray.length - n) break block9;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw BitsStreamGenerator.b(illegalArgumentException);
                }
                throw new OutOfRangeException(n2, (Number)0, byArray.length - n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw BitsStreamGenerator.b(illegalArgumentException);
            }
        }
        this.nextBytesFill(byArray, n, n2);
    }

    private void nextBytesFill(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        block6: {
            n5 = n;
            n4 = BitsStreamGenerator.a();
            int n6 = n5 + (n2 & 0x7FFFFFFC);
            while (n5 < n6) {
                n3 = this.next(32);
                try {
                    byArray[n5++] = (byte)n3;
                    byArray[n5++] = (byte)(n3 >>> 8);
                    byArray[n5++] = (byte)(n3 >>> 16);
                    byArray[n5++] = (byte)(n3 >>> 24);
                    if (n4 == 0) {
                        if (n4 == 0) continue;
                        break;
                    }
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw BitsStreamGenerator.b(illegalArgumentException);
                }
            }
            n3 = n + n2;
        }
        if (n5 < n3) {
            int n7 = this.next(32);
            do {
                byArray[n5++] = (byte)n7;
                if (n5 >= n3) break;
                n7 >>>= 8;
            } while (n4 == 0);
        }
    }

    public static void b(int n) {
        b = n;
    }

    public static int b() {
        return b;
    }

    public static int a() {
        int n = BitsStreamGenerator.b();
        try {
            if (n == 0) {
                return 40;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw BitsStreamGenerator.b(illegalArgumentException);
        }
        return 0;
    }

    private static IllegalArgumentException b(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    static {
        if (BitsStreamGenerator.b() == 0) {
            BitsStreamGenerator.b(6);
        }
    }
}

