/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathArithmeticException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathIllegalNumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.util.ArithmeticUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.Combinations;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CombinatoricsUtils {
    static final long[] a = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference<long[][]> b = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static long binomialCoefficient(int var0, int var1_1) {
        block27: {
            block26: {
                v0 = FastMath.c();
                CombinatoricsUtils.checkBinomial(var0, var1_1);
                var2_2 = v0;
                try {
                    try {
                        if (var0 != var1_1 && var1_1 != 0) break block26;
                    }
                    catch (NotPositiveException v1) {
                        throw CombinatoricsUtils.b(v1);
                    }
                    return 1L;
                }
                catch (NotPositiveException v2) {
                    throw CombinatoricsUtils.b(v2);
                }
            }
            try {
                try {
                    if (var1_1 != 1 && var1_1 != var0 - 1) break block27;
                }
                catch (NotPositiveException v3) {
                    throw CombinatoricsUtils.b(v3);
                }
                return var0;
            }
            catch (NotPositiveException v4) {
                throw CombinatoricsUtils.b(v4);
            }
        }
        try {
            if (var1_1 > var0 / 2) {
                return CombinatoricsUtils.binomialCoefficient(var0, var0 - var1_1);
            }
        }
        catch (NotPositiveException v5) {
            throw CombinatoricsUtils.b(v5);
        }
        var3_3 = 1L;
        if (var0 > 61) ** GOTO lbl45
        var5_4 = var0 - var1_1 + 1;
        for (var6_5 = 1; var6_5 <= var1_1; ++var6_5) {
            var3_3 = var3_3 * (long)var5_4 / (long)var6_5;
            try {
                ++var5_4;
                if (var2_2 == 0) {
                    if (var2_2 == 0) continue;
                    break;
                }
                ** GOTO lbl-1000
            }
            catch (NotPositiveException v6) {
                throw CombinatoricsUtils.b(v6);
            }
        }
        try {
            if (var2_2 == 0) ** GOTO lbl-1000
lbl45:
            // 2 sources

            if (var0 <= 66) {
            }
            ** GOTO lbl-1000
        }
        catch (NotPositiveException v7) {
            throw CombinatoricsUtils.b(v7);
        }
        var5_4 = var0 - var1_1 + 1;
        for (var6_5 = 1; var6_5 <= var1_1; ++var6_5) {
            var7_6 = ArithmeticUtils.gcd(var5_4, var6_5);
            var3_3 = var3_3 / ((long)var6_5 / var7_6) * ((long)var5_4 / var7_6);
            try {
                ++var5_4;
                if (var2_2 == 0) {
                    if (var2_2 == 0) continue;
                    break;
                }
                ** GOTO lbl-1000
            }
            catch (NotPositiveException v8) {
                throw CombinatoricsUtils.b(v8);
            }
        }
        if (var2_2 != 0) lbl-1000:
        // 2 sources

        {
            var5_4 = var0 - var1_1 + 1;
            for (var6_5 = 1; var6_5 <= var1_1; ++var6_5) {
                var7_6 = ArithmeticUtils.gcd(var5_4, var6_5);
                v9 = ArithmeticUtils.mulAndCheck(var3_3 / ((long)var6_5 / var7_6), (long)var5_4 / var7_6);
                if (var2_2 == 0) {
                    var3_3 = v9;
                    ++var5_4;
                    if (var2_2 == 0) continue;
                }
                break;
            }
        } else lbl-1000:
        // 6 sources

        {
            v9 = var3_3;
        }
        return v9;
    }

    public static double binomialCoefficientDouble(int n, int n2) {
        double d;
        block18: {
            int n3;
            block17: {
                block16: {
                    CombinatoricsUtils.checkBinomial(n, n2);
                    n3 = FastMath.c();
                    try {
                        try {
                            if (n != n2 && n2 != 0) break block16;
                        }
                        catch (NotPositiveException notPositiveException) {
                            throw CombinatoricsUtils.b(notPositiveException);
                        }
                        return 1.0;
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                }
                try {
                    try {
                        if (n2 != 1 && n2 != n - 1) break block17;
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                    return n;
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
            }
            try {
                if (n2 > n / 2) {
                    return CombinatoricsUtils.binomialCoefficientDouble(n, n - n2);
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            try {
                if (n < 67) {
                    return CombinatoricsUtils.binomialCoefficient(n, n2);
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            double d2 = 1.0;
            for (int i = 1; i <= n2; ++i) {
                d = d2 * ((double)(n - n2 + i) / (double)i);
                if (n3 == 0) {
                    d2 = d;
                    if (n3 == 0) continue;
                }
                break block18;
            }
            d = FastMath.floor(d2 + 0.5);
        }
        return d;
    }

    public static double binomialCoefficientLog(int n, int n2) {
        double d;
        block27: {
            int n3;
            double d2;
            int n4;
            block26: {
                block25: {
                    block24: {
                        int n5 = FastMath.c();
                        CombinatoricsUtils.checkBinomial(n, n2);
                        n4 = n5;
                        try {
                            try {
                                if (n != n2 && n2 != 0) break block24;
                            }
                            catch (NotPositiveException notPositiveException) {
                                throw CombinatoricsUtils.b(notPositiveException);
                            }
                            return 0.0;
                        }
                        catch (NotPositiveException notPositiveException) {
                            throw CombinatoricsUtils.b(notPositiveException);
                        }
                    }
                    try {
                        try {
                            if (n2 != 1 && n2 != n - 1) break block25;
                        }
                        catch (NotPositiveException notPositiveException) {
                            throw CombinatoricsUtils.b(notPositiveException);
                        }
                        return FastMath.log(n);
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                }
                try {
                    if (n < 67) {
                        return FastMath.log(CombinatoricsUtils.binomialCoefficient(n, n2));
                    }
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                try {
                    if (n < 1030) {
                        return FastMath.log(CombinatoricsUtils.binomialCoefficientDouble(n, n2));
                    }
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                try {
                    if (n2 > n / 2) {
                        return CombinatoricsUtils.binomialCoefficientLog(n, n - n2);
                    }
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                d2 = 0.0;
                for (n3 = n - n2 + 1; n3 <= n; ++n3) {
                    d2 += FastMath.log(n3);
                    try {
                        if (n4 == 0) {
                            if (n4 == 0) continue;
                            break;
                        }
                        break block26;
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                }
                n3 = 2;
            }
            do {
                try {
                    if (n3 > n2) break;
                    d = d2 - FastMath.log(n3);
                    if (n4 != 0) break block27;
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                d2 = d;
                ++n3;
            } while (n4 == 0);
            d = d2;
        }
        return d;
    }

    public static long factorial(int n) {
        try {
            if (n < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw CombinatoricsUtils.b(notPositiveException);
        }
        try {
            if (n > 20) {
                throw new MathArithmeticException();
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw CombinatoricsUtils.b(notPositiveException);
        }
        return a[n];
    }

    public static double factorialDouble(int n) {
        try {
            if (n < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw CombinatoricsUtils.b(notPositiveException);
        }
        try {
            if (n < 21) {
                return a[n];
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw CombinatoricsUtils.b(notPositiveException);
        }
        return FastMath.floor(FastMath.exp(CombinatoricsUtils.factorialLog(n)) + 0.5);
    }

    public static double factorialLog(int n) {
        double d;
        block8: {
            int n2 = FastMath.b();
            try {
                if (n < 0) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            try {
                if (n < 21) {
                    return FastMath.log(a[n]);
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            double d2 = 0.0;
            for (int i = 2; i <= n; ++i) {
                d = d2 + FastMath.log(i);
                if (n2 != 0) {
                    d2 = d;
                    if (n2 != 0) continue;
                }
                break block8;
            }
            d = d2;
        }
        return d;
    }

    public static long stirlingS2(int n, int n2) {
        long l;
        long l2;
        block38: {
            long l3;
            Object object;
            int n3;
            block37: {
                block35: {
                    n3 = FastMath.c();
                    try {
                        if (n2 < 0) {
                            throw new NotPositiveException(n2);
                        }
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                    try {
                        if (n2 > n) {
                            throw new NumberIsTooLargeException(n2, (Number)n, true);
                        }
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                    object = b.get();
                    if (object == null) {
                        int n4;
                        int n5 = 26;
                        object = new long[26][];
                        object[0] = new long[]{1L};
                        int n6 = 1;
                        while (n6 < ((long[][])object).length) {
                            block36: {
                                object[n6] = new long[n6 + 1];
                                object[n6][0] = 0L;
                                object[n6][1] = 1L;
                                object[n6][n6] = 1L;
                                n4 = 2;
                                if (n3 != 0) break block35;
                                for (int i = v1258535; i < n6; ++i) {
                                    try {
                                        object[n6][i] = (long)i * object[n6 - 1][i] + object[n6 - 1][i - 1];
                                        if (n3 == 0) {
                                            if (n3 == 0) continue;
                                            break;
                                        }
                                        break block36;
                                    }
                                    catch (NotPositiveException notPositiveException) {
                                        throw CombinatoricsUtils.b(notPositiveException);
                                    }
                                }
                                ++n6;
                            }
                            if (n3 == 0) continue;
                        }
                        n4 = b.compareAndSet((long[][])null, (long[][])object);
                    }
                }
                try {
                    if (n < ((long[][])object).length) {
                        return object[n][n2];
                    }
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                try {
                    if (n2 == 0) {
                        return 0L;
                    }
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
                try {
                    try {
                        if (n2 != 1 && n2 != n) break block37;
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                    return 1L;
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
            }
            try {
                if (n2 == 2) {
                    return (1L << n - 1) - 1L;
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            try {
                if (n2 == n - 1) {
                    return CombinatoricsUtils.binomialCoefficient(n, 2);
                }
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            long l4 = 0L;
            try {
                l3 = (n2 & 1) == 0 ? 1L : -1L;
            }
            catch (NotPositiveException notPositiveException) {
                throw CombinatoricsUtils.b(notPositiveException);
            }
            long l5 = l3;
            for (int i = 1; i <= n2; ++i) {
                l5 = -l5;
                l4 += l5 * CombinatoricsUtils.binomialCoefficient(n2, i) * (long)ArithmeticUtils.pow(i, n);
                try {
                    try {
                        l2 = l4;
                        l = 0L;
                        if (n3 != 0) break block38;
                        if (l2 >= l) continue;
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw CombinatoricsUtils.b(notPositiveException);
                    }
                    throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, ((long[][])object).length - 1);
                }
                catch (NotPositiveException notPositiveException) {
                    throw CombinatoricsUtils.b(notPositiveException);
                }
            }
            l2 = l4;
            l = CombinatoricsUtils.factorial(n2);
        }
        return l2 / l;
    }

    public static Iterator<int[]> combinationsIterator(int n, int n2) {
        return new Combinations(n, n2).iterator();
    }

    public static void checkBinomial(int n, int n2) {
        try {
            if (n < n2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)n2, n, true);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw CombinatoricsUtils.b(numberIsTooLargeException);
        }
        try {
            if (n < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw CombinatoricsUtils.b(numberIsTooLargeException);
        }
    }

    private static MathIllegalNumberException b(MathIllegalNumberException mathIllegalNumberException) {
        return mathIllegalNumberException;
    }
}

