/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.heads.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.advancedplugins.heads.utils.ConfigItemCreator;
import net.advancedplugins.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack b;
    private ItemMeta a;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.b = itemStack;
        this.a = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n) {
        this.b = new ItemStack(material, n);
        this.a = this.b.getItemMeta();
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.b = new ItemStack(material, n, (short)by);
        this.a = this.b.getItemMeta();
    }

    public ItemBuilder setDurability(short s) {
        this.b.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        this.a.setDisplayName(string);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.a.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.b.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.a;
            skullMeta.setOwner(string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        this.a.addEnchant(enchantment, n, true);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.b.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.b.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        this.a.setLore(Arrays.asList(stringArray));
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        this.a.setLore(list);
        this.b.setItemMeta(this.a);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ArrayList arrayList;
        block4: {
            boolean bl;
            block5: {
                arrayList = new ArrayList(this.a.getLore());
                int n = ConfigItemCreator.b;
                bl = arrayList.contains(string);
                if (n != 0) break block4;
                if (bl) break block5;
                return this;
            }
            bl = arrayList.remove(string);
        }
        this.a.setLore(arrayList);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemBuilder removeLoreLine(int n) {
        int n2;
        ArrayList arrayList;
        block5: {
            arrayList = new ArrayList(this.a.getLore());
            int n3 = ConfigItemCreator.b;
            n2 = n;
            if (n3 != 0) break block5;
            if (n2 < 0) return this;
            n2 = n;
        }
        if (n2 > arrayList.size()) {
            return this;
        }
        arrayList.remove(n);
        this.a.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ArrayList<String> arrayList;
        block2: {
            boolean bl;
            block3: {
                arrayList = new ArrayList<String>();
                int n = ConfigItemCreator.b;
                bl = this.a.hasLore();
                if (n != 0) break block2;
                if (!bl) break block3;
                arrayList = new ArrayList(this.a.getLore());
            }
            bl = arrayList.add(string);
        }
        this.a.setLore(arrayList);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.a.getLore());
        arrayList.set(n, string);
        this.a.setLore(arrayList);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemBuilder setColor(Color color) {
        ItemBuilder itemBuilder;
        block10: {
            block9: {
                FireworkEffectMeta fireworkEffectMeta;
                boolean bl;
                block7: {
                    int n;
                    block8: {
                        n = ConfigItemCreator.b;
                        bl = this.a instanceof LeatherArmorMeta;
                        if (n != 0) break block7;
                        if (!bl) break block8;
                        fireworkEffectMeta = (LeatherArmorMeta)this.a;
                        fireworkEffectMeta.setColor(color);
                        if (n == 0) break block9;
                    }
                    itemBuilder = this;
                    if (n != 0) break block10;
                    bl = itemBuilder.a instanceof FireworkEffectMeta;
                }
                if (bl) {
                    fireworkEffectMeta = (FireworkEffectMeta)this.a;
                    fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor(color).build());
                }
            }
            itemBuilder = this;
        }
        return itemBuilder;
    }

    public ItemBuilder setItemFlags(ItemFlag ... itemFlagArray) {
        this.a.addItemFlags(itemFlagArray);
        return this;
    }

    public ItemBuilder addAttribute(Attribute attribute, AttributeModifier attributeModifier) {
        this.a.addAttributeModifier(attribute, attributeModifier);
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.b.setAmount(n);
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        this.a.addItemFlags(new ItemFlag[]{itemFlag});
        return this;
    }

    public ItemBuilder setCustomModelData(Integer n) {
        if (MinecraftVersion.getVersionNumber() >= 1140) {
            this.a.setCustomModelData(n);
        }
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.a;
    }

    public ItemStack toItemStack() {
        this.b.setItemMeta(this.a);
        return this.b;
    }
}

