/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomDataImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = -1146319659338487221L;
    @Deprecated
    protected final RandomDataImpl b = new RandomDataImpl();
    protected final RandomGenerator a;

    @Deprecated
    protected AbstractIntegerDistribution() {
        this.a = null;
    }

    protected AbstractIntegerDistribution(RandomGenerator randomGenerator) {
        this.a = randomGenerator;
    }

    public double cumulativeProbability(int n, int n2) {
        try {
            if (n2 < n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)n, n2, true);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw AbstractIntegerDistribution.b(numberIsTooLargeException);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n);
    }

    public int inverseCumulativeProbability(double d) {
        boolean bl;
        double d2;
        double d3;
        int n;
        int n2;
        block31: {
            boolean bl2;
            block30: {
                block29: {
                    block28: {
                        block27: {
                            try {
                                try {
                                    if (!(d < 0.0) && !(d > 1.0)) break block27;
                                }
                                catch (OutOfRangeException outOfRangeException) {
                                    throw AbstractIntegerDistribution.b(outOfRangeException);
                                }
                                throw new OutOfRangeException(d, (Number)0, 1);
                            }
                            catch (OutOfRangeException outOfRangeException) {
                                throw AbstractIntegerDistribution.b(outOfRangeException);
                            }
                        }
                        n2 = this.getSupportLowerBound();
                        try {
                            if (d == 0.0) {
                                return n2;
                            }
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw AbstractIntegerDistribution.b(outOfRangeException);
                        }
                        try {
                            try {
                                if (n2 != Integer.MIN_VALUE) break block28;
                                if (!(this.checkedCumulativeProbability(n2) >= d)) break block29;
                            }
                            catch (OutOfRangeException outOfRangeException) {
                                throw AbstractIntegerDistribution.b(outOfRangeException);
                            }
                            return n2;
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw AbstractIntegerDistribution.b(outOfRangeException);
                        }
                    }
                    --n2;
                }
                n = this.getSupportUpperBound();
                try {
                    if (d == 1.0) {
                        return n;
                    }
                }
                catch (OutOfRangeException outOfRangeException) {
                    throw AbstractIntegerDistribution.b(outOfRangeException);
                }
                d3 = this.getNumericalMean();
                d2 = FastMath.sqrt(this.getNumericalVariance());
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (Double.isInfinite(d3) || Double.isNaN(d3)) break block30;
                                }
                                catch (OutOfRangeException outOfRangeException) {
                                    throw AbstractIntegerDistribution.b(outOfRangeException);
                                }
                                if (Double.isInfinite(d2)) break block30;
                            }
                            catch (OutOfRangeException outOfRangeException) {
                                throw AbstractIntegerDistribution.b(outOfRangeException);
                            }
                            if (Double.isNaN(d2)) break block30;
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw AbstractIntegerDistribution.b(outOfRangeException);
                        }
                        if (d2 == 0.0) break block30;
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        throw AbstractIntegerDistribution.b(outOfRangeException);
                    }
                    bl2 = true;
                    break block31;
                }
                catch (OutOfRangeException outOfRangeException) {
                    throw AbstractIntegerDistribution.b(outOfRangeException);
                }
            }
            bl2 = bl = false;
        }
        if (bl) {
            double d4 = FastMath.sqrt((1.0 - d) / d);
            double d5 = d3 - d4 * d2;
            if (d5 > (double)n2) {
                n2 = (int)FastMath.ceil(d5) - 1;
            }
            if ((d5 = d3 + (d4 = 1.0 / d4) * d2) < (double)n) {
                n = (int)FastMath.ceil(d5) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d, n2, n);
    }

    protected int solveInverseCumulativeProbability(double d, int n, int n2) {
        int n3;
        block7: {
            int n4 = AbstractRealDistribution.b();
            while (n + 1 < n2) {
                block11: {
                    int n5;
                    block10: {
                        double d2;
                        block9: {
                            block8: {
                                n5 = (n + n2) / 2;
                                try {
                                    try {
                                        n3 = n5;
                                        if (n4 != 0) break block7;
                                        if (n3 < n) break block8;
                                    }
                                    catch (NumberIsTooLargeException numberIsTooLargeException) {
                                        throw AbstractIntegerDistribution.b(numberIsTooLargeException);
                                    }
                                    if (n5 <= n2) break block9;
                                }
                                catch (NumberIsTooLargeException numberIsTooLargeException) {
                                    throw AbstractIntegerDistribution.b(numberIsTooLargeException);
                                }
                            }
                            n5 = n + (n2 - n) / 2;
                        }
                        if (!((d2 = this.checkedCumulativeProbability(n5)) >= d)) break block10;
                        n2 = n5;
                        if (n4 == 0) break block11;
                    }
                    n = n5;
                }
                if (n4 == 0) continue;
            }
            n3 = n2;
        }
        return n3;
    }

    public void reseedRandomGenerator(long l) {
        this.a.setSeed(l);
        this.b.reSeed(l);
    }

    public int sample() {
        return this.inverseCumulativeProbability(this.a.nextDouble());
    }

    public int[] sample(int n) {
        int[] nArray;
        block7: {
            int n2 = AbstractRealDistribution.a();
            try {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
                }
            }
            catch (NumberIsTooLargeException numberIsTooLargeException) {
                throw AbstractIntegerDistribution.b(numberIsTooLargeException);
            }
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    nArray = nArray2;
                    if (n2 != 0) {
                        nArray[i] = this.sample();
                        if (n2 != 0) continue;
                        break;
                    }
                    break block7;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw AbstractIntegerDistribution.b(numberIsTooLargeException);
                }
            }
            nArray = nArray2;
        }
        return nArray;
    }

    private double checkedCumulativeProbability(int n) {
        double d = Double.NaN;
        d = this.cumulativeProbability(n);
        try {
            if (Double.isNaN(d)) {
                throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, n);
            }
        }
        catch (MathInternalError mathInternalError) {
            throw AbstractIntegerDistribution.b(mathInternalError);
        }
        return d;
    }

    public double logProbability(int n) {
        return FastMath.log(this.probability(n));
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

