/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.MathIllegalNumberException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double i = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] h;
    private final double f;
    private final double j;
    private final double g;

    public ExponentialDistribution(double d) {
        this(d, 1.0E-9);
    }

    public ExponentialDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d) {
        this(randomGenerator, d, 1.0E-9);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.f = d;
        this.j = FastMath.log(d);
        this.g = d2;
    }

    public double getMean() {
        return this.f;
    }

    public double density(double d) {
        double d2;
        double d3 = this.logDensity(d);
        try {
            d2 = d3 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d3);
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return d2;
    }

    public double logDensity(double d) {
        try {
            if (d < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return -d / this.f - this.j;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                int n = AbstractRealDistribution.a();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (n != 0) break block3;
            }
            d2 = 1.0 - FastMath.exp(-d / this.f);
        }
        return d2;
    }

    public double inverseCumulativeProbability(double d) {
        double d2;
        block8: {
            block7: {
                int n;
                block6: {
                    n = AbstractRealDistribution.a();
                    try {
                        try {
                            if (!(d < 0.0) && !(d > 1.0)) break block6;
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw ExponentialDistribution.c(outOfRangeException);
                        }
                        throw new OutOfRangeException(d, (Number)0.0, 1.0);
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        throw ExponentialDistribution.c(outOfRangeException);
                    }
                }
                if (d != 1.0) break block7;
                d2 = Double.POSITIVE_INFINITY;
                if (n != 0) break block8;
            }
            d2 = -this.f * FastMath.log(1.0 - d);
        }
        return d2;
    }

    public double sample() {
        double d;
        double d2;
        double d3;
        int n;
        double d4;
        block10: {
            d4 = 0.0;
            n = AbstractRealDistribution.a();
            for (d3 = this.b.nextDouble(); d3 < 0.5; d3 *= 2.0) {
                d4 += h[0];
                try {
                    if (n != 0) {
                        if (n != 0) continue;
                        break;
                    }
                    break block10;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ExponentialDistribution.c(notStrictlyPositiveException);
                }
            }
            d3 += d3 - 1.0;
        }
        try {
            if (d3 <= h[0]) {
                return this.f * (d4 + d3);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        int n2 = 0;
        double d5 = d2 = this.b.nextDouble();
        block5: while (true) {
            ++n2;
            d2 = this.b.nextDouble();
            if (d2 < d5) {
                d = d5 = d2;
            }
            do {
                if (d3 > h[n2]) continue block5;
                d = this.f * (d4 + d5 * h[0]);
            } while (n == 0);
            break;
        }
        return d;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.g;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double d = this.getMean();
        return d * d;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    static {
        double d = FastMath.log(2.0);
        double d2 = 0.0;
        int n = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d2 < 1.0) {
            resizableDoubleArray.addElement(d2 += FastMath.pow(d, n) / (double)CombinatoricsUtils.factorial(n));
            ++n;
        }
        h = resizableDoubleArray.getElements();
    }

    private static MathIllegalNumberException c(MathIllegalNumberException mathIllegalNumberException) {
        return mathIllegalNumberException;
    }
}

