/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.SaddlePointExpansion;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class HypergeometricDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -436928820673516179L;
    private final int e;
    private final int c;
    private final int f;
    private double g = Double.NaN;
    private boolean d = false;

    public HypergeometricDistribution(int n, int n2, int n3) {
        this(new Well19937c(), n, n2, n3);
    }

    public HypergeometricDistribution(RandomGenerator randomGenerator, int n, int n2, int n3) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.POPULATION_SIZE, n);
        }
        try {
            if (n2 < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n2);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n3 < 0) {
                throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n3);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n2 > n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)n2, n, true);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        try {
            if (n3 > n) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE, (Number)n3, n, true);
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        this.e = n2;
        this.c = n;
        this.f = n3;
    }

    /*
     * Unable to fully structure code
     */
    public double cumulativeProbability(int var1_1) {
        block4: {
            block5: {
                var5_2 = this.getDomain(this.c, this.e, this.f);
                var2_3 = AbstractRealDistribution.a();
                if (var1_1 >= var5_2[0]) ** GOTO lbl7
                var3_4 = 0.0;
                try {
                    if (var2_3 != 0) break block4;
lbl7:
                    // 2 sources

                    if (var1_1 < var5_2[1]) break block5;
                }
                catch (NotPositiveException v0) {
                    throw HypergeometricDistribution.b(v0);
                }
                var3_4 = 1.0;
                if (var2_3 != 0) break block4;
            }
            var3_4 = this.innerCumulativeProbability(var5_2[0], var1_1, 1);
        }
        return var3_4;
    }

    private int[] getDomain(int n, int n2, int n3) {
        return new int[]{this.getLowerDomain(n, n2, n3), this.getUpperDomain(n2, n3)};
    }

    private int getLowerDomain(int n, int n2, int n3) {
        return FastMath.max(0, n2 - (n - n3));
    }

    public int getNumberOfSuccesses() {
        return this.e;
    }

    public int getPopulationSize() {
        return this.c;
    }

    public int getSampleSize() {
        return this.f;
    }

    private int getUpperDomain(int n, int n2) {
        return FastMath.min(n2, n);
    }

    public double probability(int n) {
        double d;
        double d2 = this.logProbability(n);
        try {
            d = d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        return d;
    }

    public double logProbability(int n) {
        double d;
        block5: {
            block4: {
                int[] nArray = this.getDomain(this.c, this.e, this.f);
                int n2 = AbstractRealDistribution.b();
                try {
                    if (n >= nArray[0] && n <= nArray[1]) break block4;
                }
                catch (NotPositiveException notPositiveException) {
                    throw HypergeometricDistribution.b(notPositiveException);
                }
                d = Double.NEGATIVE_INFINITY;
                if (n2 == 0) break block5;
            }
            double d2 = (double)this.f / (double)this.c;
            double d3 = (double)(this.c - this.f) / (double)this.c;
            double d4 = SaddlePointExpansion.logBinomialProbability(n, this.e, d2, d3);
            double d5 = SaddlePointExpansion.logBinomialProbability(this.f - n, this.c - this.e, d2, d3);
            double d6 = SaddlePointExpansion.logBinomialProbability(this.f, this.c, d2, d3);
            d = d4 + d5 - d6;
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public double upperCumulativeProbability(int var1_1) {
        block4: {
            block5: {
                var5_2 = this.getDomain(this.c, this.e, this.f);
                var2_3 = AbstractRealDistribution.b();
                if (var1_1 > var5_2[0]) ** GOTO lbl7
                var3_4 = 1.0;
                try {
                    if (var2_3 == 0) break block4;
lbl7:
                    // 2 sources

                    if (var1_1 <= var5_2[1]) break block5;
                }
                catch (NotPositiveException v0) {
                    throw HypergeometricDistribution.b(v0);
                }
                var3_4 = 0.0;
                if (var2_3 == 0) break block4;
            }
            var3_4 = this.innerCumulativeProbability(var5_2[1], var1_1, -1);
        }
        return var3_4;
    }

    private double innerCumulativeProbability(int n, int n2, int n3) {
        double d;
        block2: {
            double d2 = this.probability(n);
            int n4 = AbstractRealDistribution.b();
            while (n != n2) {
                d = d2 + this.probability(n += n3);
                if (n4 == 0) {
                    d2 = d;
                    if (n4 == 0) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public double getNumericalMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    public double getNumericalVariance() {
        try {
            if (!this.d) {
                this.g = this.calculateNumericalVariance();
                this.d = true;
            }
        }
        catch (NotPositiveException notPositiveException) {
            throw HypergeometricDistribution.b(notPositiveException);
        }
        return this.g;
    }

    protected double calculateNumericalVariance() {
        double d = this.getPopulationSize();
        double d2 = this.getNumberOfSuccesses();
        double d3 = this.getSampleSize();
        return d3 * d2 * (d - d3) * (d - d2) / (d * d * (d - 1.0));
    }

    public int getSupportLowerBound() {
        return FastMath.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    public int getSupportUpperBound() {
        return FastMath.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotPositiveException b(NotPositiveException notPositiveException) {
        return notPositiveException;
    }
}

