/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class UniformIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20120109L;
    private final int d;
    private final int c;

    public UniformIntegerDistribution(int n, int n2) {
        this(new Well19937c(), n, n2);
    }

    public UniformIntegerDistribution(RandomGenerator randomGenerator, int n, int n2) {
        super(randomGenerator);
        if (n > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n, n2, true);
        }
        this.d = n;
        this.c = n2;
    }

    public double probability(int n) {
        block4: {
            try {
                try {
                    if (n >= this.d && n <= this.c) break block4;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw UniformIntegerDistribution.b(numberIsTooLargeException);
                }
                return 0.0;
            }
            catch (NumberIsTooLargeException numberIsTooLargeException) {
                throw UniformIntegerDistribution.b(numberIsTooLargeException);
            }
        }
        return 1.0 / (double)(this.c - this.d + 1);
    }

    public double cumulativeProbability(int n) {
        try {
            if (n < this.d) {
                return 0.0;
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw UniformIntegerDistribution.b(numberIsTooLargeException);
        }
        try {
            if (n > this.c) {
                return 1.0;
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw UniformIntegerDistribution.b(numberIsTooLargeException);
        }
        return ((double)(n - this.d) + 1.0) / ((double)(this.c - this.d) + 1.0);
    }

    public double getNumericalMean() {
        return 0.5 * (double)(this.d + this.c);
    }

    public double getNumericalVariance() {
        double d = this.c - this.d + 1;
        return (d * d - 1.0) / 12.0;
    }

    public int getSupportLowerBound() {
        return this.d;
    }

    public int getSupportUpperBound() {
        return this.c;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        int n = this.c - this.d + 1;
        int n2 = AbstractRealDistribution.b();
        if (n <= 0) {
            do {
                int n3;
                if ((n3 = this.a.nextInt()) < this.d) continue;
                try {
                    if (n3 <= this.c) {
                        return n3;
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw UniformIntegerDistribution.b(numberIsTooLargeException);
                }
            } while (n2 == 0);
        }
        return this.d + this.a.nextInt(n);
    }

    private static NumberIsTooLargeException b(NumberIsTooLargeException numberIsTooLargeException) {
        return numberIsTooLargeException;
    }
}

