/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.exception.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.advancedplugins.items.impl.commons.effects.effects.AdvancedEffect;
import org.apache.commons.math3.exception.util.ArgUtils;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionContext
implements Serializable {
    private static final long serialVersionUID = -6024911025449780478L;
    private Throwable a;
    private List<Localizable> c;
    private List<Object[]> b;
    private Map<String, Object> d;
    private static final String[] e;

    public ExceptionContext(Throwable throwable) {
        this.a = throwable;
        this.c = new ArrayList<Localizable>();
        this.b = new ArrayList<Object[]>();
        this.d = new HashMap<String, Object>();
    }

    public Throwable getThrowable() {
        return this.a;
    }

    public void addMessage(Localizable localizable, Object ... objectArray) {
        this.c.add(localizable);
        this.b.add(ArgUtils.flatten(objectArray));
    }

    public void setValue(String string, Object object) {
        String[] stringArray = LocalizedFormats.b();
        this.d.put(string, object);
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            AdvancedEffect.b(e[0]);
        }
    }

    public Object getValue(String string) {
        return this.d.get(string);
    }

    public Set<String> getKeys() {
        return this.d.keySet();
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.buildMessage(locale, e[1]);
    }

    public String getMessage(Locale locale, String string) {
        return this.buildMessage(locale, string);
    }

    private String buildMessage(Locale locale, String string) {
        StringBuilder stringBuilder;
        block2: {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            int n2 = this.c.size();
            String[] stringArray = LocalizedFormats.b();
            for (int i = 0; i < n2; ++i) {
                Localizable localizable = this.c.get(i);
                Object[] objectArray = this.b.get(i);
                MessageFormat messageFormat = new MessageFormat(localizable.getLocalizedString(locale), locale);
                stringBuilder = stringBuilder2.append(messageFormat.format(objectArray));
                if (stringArray != null) {
                    if (++n >= n2) continue;
                    stringBuilder2.append(string);
                    if (stringArray != null) continue;
                }
                break block2;
            }
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.a);
        this.serializeMessages(objectOutputStream);
        this.serializeContext(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.a = (Throwable)objectInputStream.readObject();
        this.deSerializeMessages(objectInputStream);
        this.deSerializeContext(objectInputStream);
    }

    private void serializeMessages(ObjectOutputStream objectOutputStream) {
        int n = this.c.size();
        String[] stringArray = LocalizedFormats.b();
        objectOutputStream.writeInt(n);
        String[] stringArray2 = stringArray;
        int n2 = 0;
        block4: while (true) {
            int n3 = n2;
            block5: while (n3 < n) {
                Localizable localizable = this.c.get(n2);
                objectOutputStream.writeObject(localizable);
                Object[] objectArray = this.b.get(n2);
                int n4 = objectArray.length;
                objectOutputStream.writeInt(n4);
                for (int i = 0; i < n4; ++i) {
                    n3 = objectArray[i] instanceof Serializable;
                    if (stringArray2 == null) continue block5;
                    try {
                        try {
                            if (n3 != 0) {
                                objectOutputStream.writeObject(objectArray[i]);
                                if (stringArray2 != null) continue;
                            }
                        }
                        catch (IOException iOException) {
                            throw ExceptionContext.b(iOException);
                        }
                        objectOutputStream.writeObject(this.nonSerializableReplacement(objectArray[i]));
                        continue;
                    }
                    catch (IOException iOException) {
                        throw ExceptionContext.b(iOException);
                    }
                }
                ++n2;
                if (stringArray2 != null) continue block4;
            }
            break;
        }
    }

    private void deSerializeMessages(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        String[] stringArray = LocalizedFormats.b();
        this.c = new ArrayList<Localizable>(n);
        this.b = new ArrayList<Object[]>(n);
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Localizable localizable = (Localizable)objectInputStream.readObject();
                this.c.add(localizable);
                int n3 = objectInputStream.readInt();
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    try {
                        objectArray[i] = objectInputStream.readObject();
                        if (stringArray != null) {
                            if (stringArray != null) continue;
                            break;
                        }
                        break block5;
                    }
                    catch (IOException iOException) {
                        throw ExceptionContext.b(iOException);
                    }
                }
                this.b.add(objectArray);
                ++n2;
            }
            if (stringArray != null) continue;
        }
    }

    private void serializeContext(ObjectOutputStream objectOutputStream) {
        int n = this.d.size();
        String[] stringArray = LocalizedFormats.b();
        objectOutputStream.writeInt(n);
        for (Map.Entry<String, Object> entry : this.d.entrySet()) {
            block6: {
                objectOutputStream.writeObject(entry.getKey());
                Object object = entry.getValue();
                try {
                    block5: {
                        try {
                            if (!(object instanceof Serializable)) break block5;
                            objectOutputStream.writeObject(object);
                            if (stringArray != null) break block6;
                        }
                        catch (IOException iOException) {
                            throw ExceptionContext.b(iOException);
                        }
                    }
                    objectOutputStream.writeObject(this.nonSerializableReplacement(object));
                }
                catch (IOException iOException) {
                    throw ExceptionContext.b(iOException);
                }
            }
            if (stringArray != null) continue;
        }
    }

    private void deSerializeContext(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        this.d = new HashMap<String, Object>();
        String[] stringArray = LocalizedFormats.b();
        for (int i = 0; i < n; ++i) {
            String string = (String)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.d.put(string, object);
            if (stringArray != null) continue;
        }
    }

    private String nonSerializableReplacement(Object object) {
        return e[2] + object.getClass().getName() + "]";
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[3];
        int n = 0;
        String string = "|\u000e\u007f1g\u0002%a!D\u000eI?`:\u007f?\"D i=+q._ug<+l$Y<d5be$Oo%";
        int n2 = "|\u000e\u007f1g\u0002%a!D\u000eI?`:\u007f?\"D i=+q._ug<+l$Y<d5be$Oo%".length();
        int n3 = 5;
        int n4 = -1;
        while (true) {
            char[] cArray;
            block14: {
                int n5;
                char[] cArray2;
                int n6;
                int n7;
                block13: {
                    int n8 = ++n4;
                    Object var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                    int n9 = cArray3.length;
                    n7 = 0;
                    n6 = 26;
                    cArray2 = cArray3;
                    n5 = n9;
                    if (n9 <= 1) break block13;
                    cArray = cArray2;
                    n5 = n5;
                    if (n5 <= n7) break block14;
                }
                do {
                    int n10 = n6;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n11 = n6;
                    int n12 = n7;
                    while (true) {
                        int n13;
                        switch (n7 % 7) {
                            case 0: {
                                n13 = 5;
                                break;
                            }
                            case 1: {
                                n13 = 91;
                                break;
                            }
                            case 2: {
                                n13 = 49;
                                break;
                            }
                            case 3: {
                                n13 = 79;
                                break;
                            }
                            case 4: {
                                n13 = 31;
                                break;
                            }
                            case 5: {
                                n13 = 67;
                                break;
                            }
                            default: {
                                n13 = 17;
                            }
                        }
                        cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                        ++n7;
                        n6 = n10;
                        if (n10 != 0) break;
                        n10 = n6;
                        cArray2 = cArray2;
                        n12 = n6;
                        cArray4 = cArray2;
                        n11 = n6;
                    }
                    cArray = cArray2;
                    n5 = n5;
                } while (n5 > n7);
            }
            stringArray[n++] = new String(cArray).intern();
            if ((n4 += n3) >= n2) {
                e = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }
}

