/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.Section;
import me.extremall.advancedkits.libs.boostedyaml.engine.ExtendedConstructor;
import me.extremall.advancedkits.libs.boostedyaml.engine.ExtendedRepresenter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.StreamDataWriter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.composer.Composer;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter.Emitter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.parser.Parser;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.parser.ParserImpl;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.StreamReader;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer.Serializer;
import me.extremall.advancedkits.libs.boostedyaml.settings.dumper.DumperSettings;
import me.extremall.advancedkits.libs.boostedyaml.settings.general.GeneralSettings;
import me.extremall.advancedkits.libs.boostedyaml.settings.loader.LoaderSettings;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.UpdaterSettings;
import me.extremall.advancedkits.libs.boostedyaml.updater.Updater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlDocument
extends Section {
    private final File file;
    private final YamlDocument defaults;
    private GeneralSettings generalSettings;
    private LoaderSettings loaderSettings;
    private DumperSettings dumperSettings;
    private UpdaterSettings updaterSettings;

    private YamlDocument(@NotNull InputStream inputStream, @Nullable InputStream inputStream2, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        super(generalSettings.getDefaultMap());
        this.generalSettings = generalSettings;
        this.loaderSettings = loaderSettings;
        this.dumperSettings = dumperSettings;
        this.updaterSettings = updaterSettings;
        this.file = null;
        this.defaults = inputStream2 == null ? null : new YamlDocument(inputStream2, null, generalSettings, loaderSettings, dumperSettings, updaterSettings);
        this.reload(inputStream);
    }

    private YamlDocument(@NotNull File file, @Nullable InputStream inputStream, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        super(generalSettings.getDefaultMap());
        this.generalSettings = generalSettings;
        this.loaderSettings = loaderSettings;
        this.dumperSettings = dumperSettings;
        this.updaterSettings = updaterSettings;
        this.file = file;
        this.defaults = inputStream == null ? null : new YamlDocument(inputStream, null, generalSettings, loaderSettings, dumperSettings, updaterSettings);
        this.reload();
    }

    public boolean reload() {
        if (this.file == null) {
            return false;
        }
        YamlDocument yamlDocument = this;
        yamlDocument.reload(yamlDocument.file);
        return true;
    }

    private void reload(@NotNull File object) {
        this.clear();
        if (Objects.requireNonNull(object, "File cannot be null!").exists()) {
            this.reload(new BufferedInputStream(new FileInputStream((File)object)));
            return;
        }
        if (this.loaderSettings.isCreateFileIfAbsent()) {
            if (((File)object).getParentFile() != null) {
                ((File)object).getParentFile().mkdirs();
            }
            ((File)object).createNewFile();
        }
        if (this.defaults == null) {
            YamlDocument yamlDocument = this;
            yamlDocument.initEmpty(yamlDocument);
            return;
        }
        String string = this.defaults.dump();
        object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object, false), StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            ((Writer)object).write(string);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            if (throwable != null) {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
            } else {
                ((BufferedWriter)object).close();
            }
        }
        this.reload(new BufferedInputStream(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))));
    }

    public void reload(@NotNull InputStream inputStream) {
        this.reload(inputStream, this.loaderSettings);
    }

    public void reload(@NotNull InputStream object, @NotNull LoaderSettings loaderSettings) {
        this.clear();
        Object object2 = Objects.requireNonNull(loaderSettings, "Loader settings cannot be null!").buildEngineSettings(this.generalSettings);
        ExtendedConstructor extendedConstructor = new ExtendedConstructor((LoadSettings)object2, this.generalSettings.getSerializer());
        object = new ParserImpl((LoadSettings)object2, new StreamReader((LoadSettings)object2, new YamlUnicodeReader(Objects.requireNonNull(object, "Input stream cannot be null!"))));
        object = new Composer((LoadSettings)object2, (Parser)object);
        if (((Composer)object).hasNext()) {
            object2 = ((Composer)object).next();
            if (((Composer)object).hasNext()) {
                throw new InvalidObjectException("Multiple documents are not supported!");
            }
            if (!(object2 instanceof MappingNode)) {
                throw new IllegalArgumentException(String.format("Top level object is not a map! Parsed node: %s", object2.toString()));
            }
            extendedConstructor.constructSingleDocument(Optional.of(object2));
            YamlDocument yamlDocument = this;
            yamlDocument.init(yamlDocument, null, (MappingNode)object2, extendedConstructor);
            extendedConstructor.clear();
        } else {
            YamlDocument yamlDocument = this;
            yamlDocument.initEmpty(yamlDocument);
        }
        if (this.file != null && loaderSettings.isCreateFileIfAbsent() && !this.file.exists()) {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
            this.save();
        }
        if (this.defaults != null && loaderSettings.isAutoUpdate()) {
            YamlDocument yamlDocument = this;
            Updater.update(yamlDocument, yamlDocument.defaults, this.updaterSettings, this.generalSettings);
        }
    }

    public boolean update() {
        YamlDocument yamlDocument = this;
        return yamlDocument.update(yamlDocument.updaterSettings);
    }

    public boolean update(@NotNull UpdaterSettings updaterSettings) {
        if (this.defaults == null) {
            return false;
        }
        YamlDocument yamlDocument = this;
        Updater.update(yamlDocument, yamlDocument.defaults, Objects.requireNonNull(updaterSettings, "Updater settings cannot be null!"), this.generalSettings);
        return true;
    }

    public void update(@NotNull InputStream inputStream) {
        this.update(inputStream, this.updaterSettings);
    }

    public void update(@NotNull InputStream inputStream, @NotNull UpdaterSettings updaterSettings) {
        Updater.update(this, YamlDocument.create(Objects.requireNonNull(inputStream, "Defaults cannot be null!"), this.generalSettings, this.loaderSettings, this.dumperSettings, UpdaterSettings.DEFAULT), Objects.requireNonNull(updaterSettings, "Updater settings cannot be null!"), this.generalSettings);
    }

    public boolean save() {
        if (this.file == null) {
            return false;
        }
        YamlDocument yamlDocument = this;
        yamlDocument.save(yamlDocument.file);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(@NotNull File object) {
        block9: {
            object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object, false), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                ((Writer)object).write(this.dump());
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    try {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                ((BufferedWriter)object).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((BufferedWriter)object).close();
    }

    public void save(@NotNull OutputStream outputStream, Charset charset) {
        outputStream.write(this.dump().getBytes(charset));
    }

    public void save(@NotNull OutputStreamWriter outputStreamWriter) {
        outputStreamWriter.write(this.dump());
    }

    public String dump() {
        YamlDocument yamlDocument = this;
        return yamlDocument.dump(yamlDocument.dumperSettings);
    }

    public String dump(DumperSettings object) {
        object = ((DumperSettings)object).buildEngineSettings();
        SerializedStream serializedStream = new SerializedStream();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter(this.generalSettings, (DumpSettings)object);
        object = new Serializer((DumpSettings)object, new Emitter((DumpSettings)object, serializedStream));
        ((Serializer)object).emitStreamStart();
        ((Serializer)object).serializeDocument(extendedRepresenter.represent(this));
        ((Serializer)object).emitStreamEnd();
        return serializedStream.toString();
    }

    public void setLoaderSettings(@NotNull LoaderSettings loaderSettings) {
        this.loaderSettings = loaderSettings;
    }

    public void setDumperSettings(@NotNull DumperSettings dumperSettings) {
        this.dumperSettings = dumperSettings;
    }

    public void setGeneralSettings(@NotNull GeneralSettings generalSettings) {
        if (generalSettings.getKeyFormat() != this.generalSettings.getKeyFormat()) {
            throw new IllegalArgumentException("Cannot change key format! Recreate the file if needed to do so.");
        }
        this.generalSettings = generalSettings;
    }

    public void setUpdaterSettings(@NotNull UpdaterSettings updaterSettings) {
        this.updaterSettings = updaterSettings;
    }

    @Override
    @Nullable
    public YamlDocument getDefaults() {
        return this.defaults;
    }

    @NotNull
    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    @NotNull
    public DumperSettings getDumperSettings() {
        return this.dumperSettings;
    }

    @NotNull
    public UpdaterSettings getUpdaterSettings() {
        return this.updaterSettings;
    }

    @NotNull
    public LoaderSettings getLoaderSettings() {
        return this.loaderSettings;
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public static YamlDocument create(@NotNull File file, @NotNull InputStream inputStream, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        return new YamlDocument(file, inputStream, generalSettings, loaderSettings, dumperSettings, updaterSettings);
    }

    public static YamlDocument create(@NotNull File file, @NotNull InputStream inputStream) {
        return YamlDocument.create(file, inputStream, GeneralSettings.DEFAULT, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT);
    }

    public static YamlDocument create(@NotNull InputStream inputStream, @NotNull InputStream inputStream2, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        return new YamlDocument(inputStream, inputStream2, generalSettings, loaderSettings, dumperSettings, updaterSettings);
    }

    public static YamlDocument create(@NotNull InputStream inputStream, @NotNull InputStream inputStream2) {
        return YamlDocument.create(inputStream, inputStream2, GeneralSettings.DEFAULT, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT);
    }

    public static YamlDocument create(@NotNull File file, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        return new YamlDocument(file, null, generalSettings, loaderSettings, dumperSettings, updaterSettings);
    }

    public static YamlDocument create(@NotNull File file) {
        return YamlDocument.create(file, GeneralSettings.DEFAULT, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT);
    }

    public static YamlDocument create(@NotNull InputStream inputStream, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull DumperSettings dumperSettings, @NotNull UpdaterSettings updaterSettings) {
        return new YamlDocument(inputStream, null, generalSettings, loaderSettings, dumperSettings, updaterSettings);
    }

    public static YamlDocument create(@NotNull InputStream inputStream) {
        return YamlDocument.create(inputStream, GeneralSettings.DEFAULT, LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT);
    }

    static class SerializedStream
    extends StringWriter
    implements StreamDataWriter {
        private SerializedStream() {
        }
    }
}

