/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.external.com.google.gdata.util.common.base;

import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.external.com.google.gdata.util.common.base.Escaper;

public abstract class UnicodeEscaper
implements Escaper {
    private static final int DEST_PAD = 32;
    private static final ThreadLocal<char[]> DEST_TL = new ThreadLocal<char[]>(){

        @Override
        protected final char[] initialValue() {
            return new char[1024];
        }
    };

    protected abstract char[] escape(int var1);

    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        int n4;
        while (n2 < n3 && (n4 = UnicodeEscaper.codePointAt(charSequence, n2, n3)) >= 0 && this.escape(n4) == null) {
            n2 += Character.isSupplementaryCodePoint(n4) ? 2 : 1;
        }
        return n2;
    }

    @Override
    public String escape(String string) {
        int n2 = string.length();
        int n3 = this.nextEscapeIndex(string, 0, n2);
        if (n3 == n2) {
            return string;
        }
        return this.escapeSlow(string, n3);
    }

    protected final String escapeSlow(String string, int n2) {
        int n3;
        int n4 = string.length();
        char[] cArray = DEST_TL.get();
        int n5 = 0;
        int n6 = 0;
        while (n2 < n4) {
            n3 = UnicodeEscaper.codePointAt(string, n2, n4);
            if (n3 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] cArray2 = this.escape(n3);
            if (cArray2 != null) {
                int n7 = n2 - n6;
                int n8 = n5 + n7 + cArray2.length;
                if (cArray.length < n8) {
                    n8 = n8 + (n4 - n2) + 32;
                    cArray = UnicodeEscaper.growBuffer(cArray, n5, n8);
                }
                if (n7 > 0) {
                    string.getChars(n6, n2, cArray, n5);
                    n5 += n7;
                }
                if (cArray2.length > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, cArray2.length);
                    n5 += cArray2.length;
                }
            }
            n6 = n2 + (Character.isSupplementaryCodePoint(n3) ? 2 : 1);
            n2 = this.nextEscapeIndex(string, n6, n4);
        }
        n3 = n4 - n6;
        if (n3 > 0) {
            int n9 = n5 + n3;
            if (cArray.length < n9) {
                cArray = UnicodeEscaper.growBuffer(cArray, n5, n9);
            }
            string.getChars(n6, n4, cArray, n5);
            n5 = n9;
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public Appendable escape(final Appendable appendable) {
        assert (appendable != null);
        return new Appendable(){
            int pendingHighSurrogate = -1;
            final char[] decodedChars = new char[2];

            @Override
            public Appendable append(CharSequence charSequence) {
                return this.append(charSequence, 0, charSequence.length());
            }

            @Override
            public Appendable append(CharSequence charSequence, int n2, int n3) {
                int n4 = n2;
                if (n2 < n3) {
                    char[] cArray;
                    int n5 = n2;
                    if (this.pendingHighSurrogate != -1) {
                        ++n4;
                        char c2 = charSequence.charAt(n2);
                        n2 = c2;
                        if (!Character.isLowSurrogate(c2)) {
                            throw new IllegalArgumentException("Expected low surrogate character but got " + (char)n2);
                        }
                        cArray = UnicodeEscaper.this.escape(Character.toCodePoint((char)this.pendingHighSurrogate, (char)n2));
                        if (cArray != null) {
                            this.outputChars(cArray, cArray.length);
                            ++n5;
                        } else {
                            appendable.append((char)this.pendingHighSurrogate);
                        }
                        this.pendingHighSurrogate = -1;
                    }
                    while (true) {
                        if ((n4 = UnicodeEscaper.this.nextEscapeIndex(charSequence, n4, n3)) > n5) {
                            appendable.append(charSequence, n5, n4);
                        }
                        if (n4 == n3) break;
                        n2 = UnicodeEscaper.codePointAt(charSequence, n4, n3);
                        if (n2 < 0) {
                            this.pendingHighSurrogate = -n2;
                            break;
                        }
                        cArray = UnicodeEscaper.this.escape(n2);
                        if (cArray != null) {
                            this.outputChars(cArray, cArray.length);
                        } else {
                            n5 = Character.toChars(n2, this.decodedChars, 0);
                            1 v1 = this;
                            v1.outputChars(v1.decodedChars, n5);
                        }
                        n5 = n4 += Character.isSupplementaryCodePoint(n2) ? 2 : 1;
                    }
                }
                return this;
            }

            @Override
            public Appendable append(char c2) {
                if (this.pendingHighSurrogate != -1) {
                    if (!Character.isLowSurrogate(c2)) {
                        throw new IllegalArgumentException("Expected low surrogate character but got '" + c2 + "' with value " + c2);
                    }
                    char[] cArray = UnicodeEscaper.this.escape(Character.toCodePoint((char)this.pendingHighSurrogate, c2));
                    if (cArray != null) {
                        this.outputChars(cArray, cArray.length);
                    } else {
                        appendable.append((char)this.pendingHighSurrogate);
                        appendable.append(c2);
                    }
                    this.pendingHighSurrogate = -1;
                } else if (Character.isHighSurrogate(c2)) {
                    this.pendingHighSurrogate = c2;
                } else {
                    if (Character.isLowSurrogate(c2)) {
                        throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2);
                    }
                    char[] cArray = UnicodeEscaper.this.escape(c2);
                    if (cArray != null) {
                        this.outputChars(cArray, cArray.length);
                    } else {
                        appendable.append(c2);
                    }
                }
                return this;
            }

            private void outputChars(char[] cArray, int n2) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    appendable.append(cArray[i2]);
                }
            }
        };
    }

    protected static final int codePointAt(CharSequence charSequence, int n2, int n3) {
        if (n2 < n3) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) < '\ud800' || c2 > '\udfff') {
                return c2;
            }
            if (c2 <= '\udbff') {
                if (n2 == n3) {
                    return -c2;
                }
                char c3 = charSequence.charAt(n2);
                if (Character.isLowSurrogate(c3)) {
                    return Character.toCodePoint(c2, c3);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c3 + "' with value " + c3 + " at index " + n2);
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2 + " at index " + (n2 - 1));
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static final char[] growBuffer(char[] cArray, int n2, int n3) {
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }
}

