/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.SettingKey;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.EmitterException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.JsonScalarResolver;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer.AnchorGenerator;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer.NumberAnchorGenerator;

public final class DumpSettingsBuilder {
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private NonPrintableStyle nonPrintableStyle;
    private Optional<Tag> explicitRootTag;
    private AnchorGenerator anchorGenerator;
    private Optional<SpecVersion> yamlDirective;
    private Map<String, String> tagDirective;
    private ScalarResolver scalarResolver;
    private FlowStyle defaultFlowStyle;
    private ScalarStyle defaultScalarStyle;
    private boolean canonical = false;
    private boolean multiLineFlow;
    private boolean useUnicodeEncoding = true;
    private int indent = 2;
    private int indicatorIndent = 0;
    private int width = 80;
    private String bestLineBreak = "\n";
    private boolean splitLines = true;
    private int maxSimpleKeyLength = 128;
    private boolean indentWithIndicator = false;
    private boolean dumpComments = false;
    Map<SettingKey, Object> customProperties = new HashMap<SettingKey, Object>();

    DumpSettingsBuilder() {
        this.explicitRootTag = Optional.empty();
        this.tagDirective = new HashMap<String, String>();
        this.scalarResolver = new JsonScalarResolver();
        this.anchorGenerator = new NumberAnchorGenerator(0);
        this.yamlDirective = Optional.empty();
        this.defaultFlowStyle = FlowStyle.AUTO;
        this.defaultScalarStyle = ScalarStyle.PLAIN;
    }

    public final DumpSettingsBuilder setDefaultFlowStyle(FlowStyle flowStyle) {
        this.defaultFlowStyle = flowStyle;
        return this;
    }

    public final DumpSettingsBuilder setDefaultScalarStyle(ScalarStyle scalarStyle) {
        this.defaultScalarStyle = scalarStyle;
        return this;
    }

    public final DumpSettingsBuilder setExplicitStart(boolean bl2) {
        this.explicitStart = bl2;
        return this;
    }

    public final DumpSettingsBuilder setAnchorGenerator(AnchorGenerator anchorGenerator) {
        Objects.requireNonNull(anchorGenerator, "anchorGenerator cannot be null");
        this.anchorGenerator = anchorGenerator;
        return this;
    }

    public final DumpSettingsBuilder setScalarResolver(ScalarResolver scalarResolver) {
        Objects.requireNonNull(scalarResolver, "scalarResolver cannot be null");
        this.scalarResolver = scalarResolver;
        return this;
    }

    public final DumpSettingsBuilder setExplicitRootTag(Optional<Tag> optional) {
        Objects.requireNonNull(optional, "explicitRootTag cannot be null");
        this.explicitRootTag = optional;
        return this;
    }

    public final DumpSettingsBuilder setExplicitEnd(boolean bl2) {
        this.explicitEnd = bl2;
        return this;
    }

    public final DumpSettingsBuilder setYamlDirective(Optional<SpecVersion> optional) {
        Objects.requireNonNull(optional, "yamlDirective cannot be null");
        this.yamlDirective = optional;
        return this;
    }

    public final DumpSettingsBuilder setTagDirective(Map<String, String> map) {
        Objects.requireNonNull(map, "tagDirective cannot be null");
        this.tagDirective = map;
        return this;
    }

    public final DumpSettingsBuilder setCanonical(boolean bl2) {
        this.canonical = bl2;
        return this;
    }

    public final DumpSettingsBuilder setMultiLineFlow(boolean bl2) {
        this.multiLineFlow = bl2;
        return this;
    }

    public final DumpSettingsBuilder setUseUnicodeEncoding(boolean bl2) {
        this.useUnicodeEncoding = bl2;
        return this;
    }

    public final DumpSettingsBuilder setIndent(int n2) {
        if (n2 <= 0) {
            throw new EmitterException("Indent must be at least 1");
        }
        if (n2 > 10) {
            throw new EmitterException("Indent must be at most 10");
        }
        this.indent = n2;
        return this;
    }

    public final DumpSettingsBuilder setIndicatorIndent(int n2) {
        if (n2 < 0) {
            throw new EmitterException("Indicator indent must be non-negative");
        }
        if (n2 > 9) {
            throw new EmitterException("Indicator indent must be at most Emitter.MAX_INDENT-1: 9");
        }
        this.indicatorIndent = n2;
        return this;
    }

    public final DumpSettingsBuilder setWidth(int n2) {
        this.width = n2;
        return this;
    }

    public final DumpSettingsBuilder setBestLineBreak(String string) {
        Objects.requireNonNull(string, "bestLineBreak cannot be null");
        this.bestLineBreak = string;
        return this;
    }

    public final DumpSettingsBuilder setSplitLines(boolean bl2) {
        this.splitLines = bl2;
        return this;
    }

    public final DumpSettingsBuilder setMaxSimpleKeyLength(int n2) {
        if (n2 > 1024) {
            throw new YamlEngineException("The simple key must not span more than 1024 stream characters. See https://yaml.org/spec/1.2/spec.html#id2798057");
        }
        this.maxSimpleKeyLength = n2;
        return this;
    }

    public final DumpSettingsBuilder setNonPrintableStyle(NonPrintableStyle nonPrintableStyle) {
        this.nonPrintableStyle = nonPrintableStyle;
        return this;
    }

    public final DumpSettingsBuilder setCustomProperty(SettingKey settingKey, Object object) {
        this.customProperties.put(settingKey, object);
        return this;
    }

    public final DumpSettingsBuilder setIndentWithIndicator(boolean bl2) {
        this.indentWithIndicator = bl2;
        return this;
    }

    public final DumpSettingsBuilder setDumpComments(boolean bl2) {
        this.dumpComments = bl2;
        return this;
    }

    public final DumpSettings build() {
        return new DumpSettings(this.explicitStart, this.explicitEnd, this.explicitRootTag, this.anchorGenerator, this.yamlDirective, this.tagDirective, this.scalarResolver, this.defaultFlowStyle, this.defaultScalarStyle, this.nonPrintableStyle, this.canonical, this.multiLineFlow, this.useUnicodeEncoding, this.indent, this.indicatorIndent, this.width, this.bestLineBreak, this.splitLines, this.maxSimpleKeyLength, this.customProperties, this.indentWithIndicator, this.dumpComments);
    }
}

