/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.composer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentEventsCollector;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.Anchor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.Event;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.ComposerException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.parser.Parser;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;

public class Composer
implements Iterator<Node> {
    protected final Parser parser;
    private final ScalarResolver scalarResolver;
    private final Map<Anchor, Node> anchors;
    private final Set<Node> recursiveNodes;
    private int nonScalarAliasesCount = 0;
    private final LoadSettings settings;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;

    public Composer(Parser parser, LoadSettings loadSettings) {
        this(loadSettings, parser);
    }

    public Composer(LoadSettings loadSettings, Parser parser) {
        this.parser = parser;
        this.scalarResolver = loadSettings.getScalarResolver();
        this.settings = loadSettings;
        this.anchors = new HashMap<Anchor, Node>();
        this.recursiveNodes = new HashSet<Node>();
        this.blockCommentsCollector = new CommentEventsCollector(parser, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(parser, CommentType.IN_LINE);
    }

    @Override
    public boolean hasNext() {
        if (this.parser.checkEvent(Event.ID.StreamStart)) {
            this.parser.next();
        }
        return !this.parser.checkEvent(Event.ID.StreamEnd);
    }

    public Optional<Node> getSingleNode() {
        this.parser.next();
        Optional<Mark> optional = Optional.empty();
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            optional = Optional.of(this.next());
        }
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.next();
            optional = optional.flatMap(Node::getStartMark);
            throw new ComposerException("expected a single document in the stream", optional, "but found another document", event.getStartMark());
        }
        this.parser.next();
        return optional;
    }

    @Override
    public Node next() {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event.ID.StreamEnd)) {
            List<CommentLine> list = this.blockCommentsCollector.consume();
            Object object = list.get(0).getStartMark();
            List<NodeTuple> list2 = Collections.emptyList();
            object = new MappingNode(Tag.COMMENT, false, list2, FlowStyle.BLOCK, (Optional<Mark>)object, Optional.empty());
            ((Node)object).setBlockComments(list);
            return object;
        }
        this.parser.next();
        Node node = this.composeNode(Optional.empty());
        this.blockCommentsCollector.collectEvents();
        if (!this.blockCommentsCollector.isEmpty()) {
            node.setEndComments(this.blockCommentsCollector.consume());
        }
        this.parser.next();
        this.anchors.clear();
        this.recursiveNodes.clear();
        this.nonScalarAliasesCount = 0;
        return node;
    }

    private Node composeNode(Optional<Node> optional) {
        Object object;
        this.blockCommentsCollector.collectEvents();
        optional.ifPresent(this.recursiveNodes::add);
        if (this.parser.checkEvent(Event.ID.Alias)) {
            object = (AliasEvent)this.parser.next();
            Anchor anchor = ((AliasEvent)object).getAlias();
            if (!this.anchors.containsKey(anchor)) {
                throw new ComposerException("found undefined alias " + anchor, ((Event)object).getStartMark());
            }
            object = this.anchors.get(anchor);
            if (((Node)object).getNodeType() != NodeType.SCALAR) {
                ++this.nonScalarAliasesCount;
                if (this.nonScalarAliasesCount > this.settings.getMaxAliasesForCollections()) {
                    throw new YamlEngineException("Number of aliases for non-scalar nodes exceeds the specified max=" + this.settings.getMaxAliasesForCollections());
                }
            }
            if (this.recursiveNodes.remove(object)) {
                ((Node)object).setRecursive(true);
            }
            this.blockCommentsCollector.consume();
            this.inlineCommentsCollector.collectEvents().consume();
        } else {
            object = (NodeEvent)this.parser.peekEvent();
            Optional<Anchor> optional2 = ((NodeEvent)object).getAnchor();
            object = this.parser.checkEvent(Event.ID.Scalar) ? this.composeScalarNode(optional2, this.blockCommentsCollector.consume()) : (this.parser.checkEvent(Event.ID.SequenceStart) ? this.composeSequenceNode(optional2) : this.composeMappingNode(optional2));
        }
        optional.ifPresent(this.recursiveNodes::remove);
        return object;
    }

    private void registerAnchor(Anchor anchor, Node node) {
        this.anchors.put(anchor, node);
        node.setAnchor(Optional.of(anchor));
    }

    protected Node composeScalarNode(Optional<Anchor> optional, List<CommentLine> list) {
        Object object = (ScalarEvent)this.parser.next();
        Object object2 = ((ScalarEvent)object).getTag();
        boolean bl2 = false;
        if (!((Optional)object2).isPresent() || ((Optional)object2).get().equals("!")) {
            object2 = this.scalarResolver.resolve(((ScalarEvent)object).getValue(), ((ScalarEvent)object).getImplicit().canOmitTagInPlainScalar());
            bl2 = true;
        } else {
            object2 = new Tag((String)((Optional)object2).get());
        }
        object = new ScalarNode((Tag)object2, bl2, ((ScalarEvent)object).getValue(), ((ScalarEvent)object).getScalarStyle(), ((Event)object).getStartMark(), ((Event)object).getEndMark());
        optional.ifPresent(arg_0 -> this.lambda$composeScalarNode$0((Node)object, arg_0));
        ((Node)object).setBlockComments(list);
        ((Node)object).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        return object;
    }

    protected Node composeSequenceNode(Optional<Anchor> object) {
        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)this.parser.next();
        Object object2 = sequenceStartEvent.getTag();
        boolean bl2 = false;
        if (!((Optional)object2).isPresent() || ((Optional)object2).get().equals("!")) {
            object2 = Tag.SEQ;
            bl2 = true;
        } else {
            object2 = new Tag((String)((Optional)object2).get());
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        object2 = new SequenceNode((Tag)object2, bl2, arrayList, sequenceStartEvent.getFlowStyle(), sequenceStartEvent.getStartMark(), Optional.empty());
        if (sequenceStartEvent.isFlow()) {
            ((Node)object2).setBlockComments(this.blockCommentsCollector.consume());
        }
        ((Optional)object).ifPresent(arg_0 -> this.lambda$composeSequenceNode$1((SequenceNode)object2, arg_0));
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.SequenceEnd)) break;
            arrayList.add(this.composeNode(Optional.of(object2)));
        }
        if (sequenceStartEvent.isFlow()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        object = this.parser.next();
        ((CollectionNode)object2).setEndMark(((Event)object).getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.consume());
        }
        return object2;
    }

    protected Node composeMappingNode(Optional<Anchor> object) {
        MappingStartEvent mappingStartEvent = (MappingStartEvent)this.parser.next();
        Object object2 = mappingStartEvent.getTag();
        boolean bl2 = false;
        if (!((Optional)object2).isPresent() || ((Optional)object2).get().equals("!")) {
            object2 = Tag.MAP;
            bl2 = true;
        } else {
            object2 = new Tag((String)((Optional)object2).get());
        }
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>();
        object2 = new MappingNode((Tag)object2, bl2, arrayList, mappingStartEvent.getFlowStyle(), mappingStartEvent.getStartMark(), Optional.empty());
        if (mappingStartEvent.isFlow()) {
            ((Node)object2).setBlockComments(this.blockCommentsCollector.consume());
        }
        ((Optional)object).ifPresent(arg_0 -> this.lambda$composeMappingNode$2((MappingNode)object2, arg_0));
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.MappingEnd)) break;
            this.composeMappingChildren(arrayList, (MappingNode)object2);
        }
        if (mappingStartEvent.isFlow()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        object = this.parser.next();
        ((CollectionNode)object2).setEndMark(((Event)object).getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            ((Node)object2).setInLineComments(this.inlineCommentsCollector.consume());
        }
        return object2;
    }

    protected void composeMappingChildren(List<NodeTuple> list, MappingNode node) {
        Node node2 = this.composeKeyNode((MappingNode)node);
        node = this.composeValueNode((MappingNode)node);
        list.add(new NodeTuple(node2, node));
    }

    protected Node composeKeyNode(MappingNode mappingNode) {
        return this.composeNode(Optional.of(mappingNode));
    }

    protected Node composeValueNode(MappingNode mappingNode) {
        return this.composeNode(Optional.of(mappingNode));
    }

    private /* synthetic */ void lambda$composeMappingNode$2(MappingNode mappingNode, Anchor anchor) {
        this.registerAnchor(anchor, mappingNode);
    }

    private /* synthetic */ void lambda$composeSequenceNode$1(SequenceNode sequenceNode, Anchor anchor) {
        this.registerAnchor(anchor, sequenceNode);
    }

    private /* synthetic */ void lambda$composeScalarNode$0(Node node, Anchor anchor) {
        this.registerAnchor(anchor, node);
    }
}

