/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.Anchor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.CharConstants;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.Event;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.ImplicitTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;

public final class ScalarEvent
extends NodeEvent {
    private final Optional<String> tag;
    private final ScalarStyle style;
    private final String value;
    private final ImplicitTuple implicit;

    public ScalarEvent(Optional<Anchor> optional, Optional<String> optional2, ImplicitTuple implicitTuple, String string, ScalarStyle scalarStyle, Optional<Mark> optional3, Optional<Mark> optional4) {
        super(optional, optional3, optional4);
        Objects.requireNonNull(optional2);
        this.tag = optional2;
        this.implicit = implicitTuple;
        Objects.requireNonNull(string);
        this.value = string;
        Objects.requireNonNull(scalarStyle);
        this.style = scalarStyle;
    }

    public ScalarEvent(Optional<Anchor> optional, Optional<String> optional2, ImplicitTuple implicitTuple, String string, ScalarStyle scalarStyle) {
        this(optional, optional2, implicitTuple, string, scalarStyle, Optional.empty(), Optional.empty());
    }

    public final Optional<String> getTag() {
        return this.tag;
    }

    public final ScalarStyle getScalarStyle() {
        return this.style;
    }

    public final String getValue() {
        return this.value;
    }

    public final ImplicitTuple getImplicit() {
        return this.implicit;
    }

    @Override
    public final Event.ID getEventId() {
        return Event.ID.Scalar;
    }

    public final boolean isPlain() {
        return this.style == ScalarStyle.PLAIN;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("=VAL");
        this.getAnchor().ifPresent(anchor -> stringBuilder.append(" &" + anchor));
        if (this.implicit.bothFalse()) {
            this.getTag().ifPresent(string -> stringBuilder.append(" <" + string + ">"));
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.getScalarStyle().toString());
        stringBuilder.append(this.escapedValue());
        return stringBuilder.toString();
    }

    public final String escapedValue() {
        return this.value.codePoints().filter(n2 -> n2 < 65535).mapToObj(n2 -> CharConstants.escapeChar(String.valueOf(Character.toChars(n2)))).collect(Collectors.joining(""));
    }
}

