/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ResolverTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;

public class JsonScalarResolver
implements ScalarResolver {
    public static final Pattern BOOL = Pattern.compile("^(?:true|false)$");
    public static final Pattern FLOAT = Pattern.compile("^(-?(0?\\.[0-9]+|[1-9][0-9]*(\\.[0-9]*)?)(e[-+]?[0-9]+)?)|-?\\.(?:inf)|\\.(?:nan)$");
    public static final Pattern INT = Pattern.compile("^(?:-?(?:0|[1-9][0-9]*))$");
    public static final Pattern NULL = Pattern.compile("^(?:null)$");
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern ENV_FORMAT = Pattern.compile("^\\$\\{\\s*(?:(\\w+)(?:(:?[-?])(\\w+)?)?)\\s*\\}$");
    protected Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    public void addImplicitResolver(Tag tag, Pattern pattern, String object) {
        if (object == null) {
            object = this.yamlImplicitResolvers.computeIfAbsent(null, c2 -> new ArrayList());
            object.add(new ResolverTuple(tag, pattern));
            return;
        }
        object = ((String)object).toCharArray();
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            List<ResolverTuple> list;
            Character c3 = Character.valueOf((char)object[i2]);
            if (c3.charValue() == '\u0000') {
                c3 = null;
            }
            if ((list = this.yamlImplicitResolvers.get(c3)) == null) {
                list = new ArrayList<ResolverTuple>();
                this.yamlImplicitResolvers.put(c3, list);
            }
            list.add(new ResolverTuple(tag, pattern));
        }
    }

    protected void addImplicitResolvers() {
        this.addImplicitResolver(Tag.NULL, EMPTY, null);
        this.addImplicitResolver(Tag.BOOL, BOOL, "tf");
        this.addImplicitResolver(Tag.INT, INT, "-0123456789");
        this.addImplicitResolver(Tag.FLOAT, FLOAT, "-0123456789.");
        this.addImplicitResolver(Tag.NULL, NULL, "n\u0000");
        this.addImplicitResolver(Tag.ENV_TAG, ENV_FORMAT, "$");
    }

    public JsonScalarResolver() {
        this.addImplicitResolvers();
    }

    @Override
    public Tag resolve(String string, Boolean list) {
        Tag tag;
        if (!((Boolean)((Object)list)).booleanValue()) {
            return Tag.STR;
        }
        list = string.length() == 0 ? this.yamlImplicitResolvers.get(Character.valueOf('\u0000')) : this.yamlImplicitResolvers.get(Character.valueOf(string.charAt(0)));
        if (list != null) {
            for (ResolverTuple resolverTuple : list) {
                tag = resolverTuple.getTag();
                Pattern object = resolverTuple.getRegexp();
                if (!object.matcher(string).matches()) continue;
                return tag;
            }
        }
        if (this.yamlImplicitResolvers.containsKey(null)) {
            for (ResolverTuple resolverTuple : this.yamlImplicitResolvers.get(null)) {
                tag = resolverTuple.getTag();
                Pattern pattern = resolverTuple.getRegexp();
                if (!pattern.matcher(string).matches()) continue;
                return tag;
            }
        }
        return Tag.STR;
    }
}

