/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.Anchor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ArrayStack;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.CharConstants;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.UriEncoder;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.ScannerException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.Scanner;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.SimpleKey;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.StreamReader;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.AliasToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.AnchorToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.BlockEndToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.BlockEntryToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.BlockMappingStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.BlockSequenceStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.CommentToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.DirectiveToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.DocumentEndToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.DocumentStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.FlowEntryToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.FlowMappingEndToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.FlowMappingStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.FlowSequenceEndToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.FlowSequenceStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.KeyToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.ScalarToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.StreamEndToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.StreamStartToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.TagToken;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.TagTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.Token;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.tokens.ValueToken;

public final class ScannerImpl
implements Scanner {
    private static final String DIRECTIVE_PREFIX = "while scanning a directive";
    private static final String EXPECTED_ALPHA_ERROR_PREFIX = "expected alphabetic or numeric character, but found ";
    private static final String SCANNING_SCALAR = "while scanning a block scalar";
    private static final String SCANNING_PREFIX = "while scanning a ";
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private final StreamReader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private final List<Token> tokens;
    private Token lastToken;
    private int tokensTaken = 0;
    private int indent = -1;
    private final ArrayStack<Integer> indents;
    private boolean allowSimpleKey = true;
    private final Map<Integer, SimpleKey> possibleSimpleKeys;
    private final LoadSettings settings;

    public ScannerImpl(StreamReader streamReader, LoadSettings loadSettings) {
        this(loadSettings, streamReader);
    }

    public ScannerImpl(LoadSettings loadSettings, StreamReader streamReader) {
        this.reader = streamReader;
        this.settings = loadSettings;
        this.tokens = new ArrayList<Token>(100);
        this.indents = new ArrayStack(10);
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        this.fetchStreamStart();
    }

    public ScannerImpl(StreamReader streamReader) {
        this(LoadSettings.builder().build(), streamReader);
    }

    @Override
    public final boolean checkToken(Token.ID ... iDArray) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (iDArray.length == 0) {
                return true;
            }
            Object object = this.tokens.get(0);
            object = object.getTokenId();
            for (int i2 = 0; i2 < iDArray.length; ++i2) {
                if (object != iDArray[i2]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.get(0);
    }

    @Override
    public final boolean hasNext() {
        return this.checkToken(new Token.ID[0]);
    }

    @Override
    public final Token next() {
        ++this.tokensTaken;
        if (this.tokens.isEmpty()) {
            throw new NoSuchElementException("No more Tokens found.");
        }
        return this.tokens.remove(0);
    }

    private void addToken(Token token) {
        this.lastToken = token;
        this.tokens.add(token);
    }

    private void addToken(int n2, Token token) {
        if (n2 == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add(n2, token);
    }

    private void addAllTokens(List<Token> list) {
        List<Token> list2 = list;
        this.lastToken = list2.get(list2.size() - 1);
        this.tokens.addAll(list);
    }

    private boolean isBlockContext() {
        return this.flowLevel == 0;
    }

    private boolean isFlowContext() {
        return !this.isBlockContext();
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        ScannerImpl scannerImpl = this;
        scannerImpl.unwindIndent(scannerImpl.reader.getColumn());
        int n2 = this.reader.peek();
        switch (n2) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (!this.isBlockContext()) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (!this.isBlockContext()) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchSingle();
                return;
            }
            case 34: {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String string = CharConstants.escapeChar(String.valueOf(Character.toChars(n2)));
        if (n2 == 9) {
            string = string + "(TAB)";
        }
        String string2 = String.format("found character '%s' that cannot start any token. (Do not use %s for indentation)", string, string);
        throw new ScannerException("while scanning for the next token", Optional.empty(), string2, this.reader.getMark());
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey simpleKey = iterator.next();
                if (simpleKey.getLine() == this.reader.getLine() && this.reader.getIndex() - simpleKey.getIndex() <= 1024) continue;
                if (simpleKey.isRequired()) {
                    throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean bl2;
        boolean bl3 = bl2 = this.isBlockContext() && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && bl2) {
            throw new YamlEngineException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            int n2 = this.tokensTaken + this.tokens.size();
            SimpleKey simpleKey = new SimpleKey(n2, bl2, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, simpleKey);
        }
    }

    private void removePossibleSimpleKey() {
        SimpleKey simpleKey = this.possibleSimpleKeys.remove(this.flowLevel);
        if (simpleKey != null && simpleKey.isRequired()) {
            throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
        }
    }

    private void unwindIndent(int n2) {
        if (this.isFlowContext()) {
            return;
        }
        while (this.indent > n2) {
            Optional<Mark> optional = this.reader.getMark();
            this.indent = this.indents.pop();
            Optional<Mark> optional2 = optional;
            this.addToken(new BlockEndToken(optional2, optional2));
        }
    }

    private boolean addIndent(int n2) {
        if (this.indent < n2) {
            this.indents.push(this.indent);
            this.indent = n2;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        Object object = this.reader.getMark();
        Optional<Mark> optional = object;
        object = new StreamStartToken(optional, optional);
        this.addToken((Token)object);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        Object object = this.reader.getMark();
        Optional<Mark> optional = object;
        object = new StreamEndToken(optional, optional);
        this.addToken((Token)object);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        List<Token> list = this.scanDirective();
        this.addAllTokens(list);
    }

    private void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private void fetchDocumentIndicator(boolean bl2) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward(3);
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl2 ? new DocumentStartToken(optional, optional2) : new DocumentEndToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean bl2) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward(1);
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl2 ? new FlowMappingStartToken(optional, optional2) : new FlowSequenceStartToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean bl2) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl2 ? new FlowMappingEndToken(optional, optional2) : new FlowSequenceEndToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Object object = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional = this.reader.getMark();
        object = new FlowEntryToken((Optional<Mark>)object, optional);
        this.addToken((Token)object);
    }

    private void fetchBlockEntry() {
        Object object;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("", Optional.empty(), "sequence entries are not allowed here", this.reader.getMark());
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                object = this.reader.getMark();
                Optional<Mark> optional = object;
                this.addToken(new BlockSequenceStartToken(optional, optional));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        object = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional = this.reader.getMark();
        object = new BlockEntryToken((Optional<Mark>)object, optional);
        this.addToken((Token)object);
    }

    private void fetchKey() {
        Object object;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("mapping keys are not allowed here", this.reader.getMark());
            }
            ScannerImpl scannerImpl = this;
            if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                object = this.reader.getMark();
                Optional<Mark> optional = object;
                this.addToken(new BlockMappingStartToken(optional, optional));
            }
        }
        this.allowSimpleKey = this.isBlockContext();
        this.removePossibleSimpleKey();
        object = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional = this.reader.getMark();
        object = new KeyToken((Optional<Mark>)object, optional);
        this.addToken((Token)object);
    }

    private void fetchValue() {
        Object object = this.possibleSimpleKeys.remove(this.flowLevel);
        if (object != null) {
            this.addToken(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new KeyToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            if (this.isBlockContext() && this.addIndent(((SimpleKey)object).getColumn())) {
                this.addToken(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.isBlockContext() && !this.allowSimpleKey) {
                throw new ScannerException("mapping values are not allowed here", this.reader.getMark());
            }
            if (this.isBlockContext()) {
                ScannerImpl scannerImpl = this;
                if (scannerImpl.addIndent(scannerImpl.reader.getColumn())) {
                    object = this.reader.getMark();
                    Optional<Mark> optional = object;
                    this.addToken(new BlockMappingStartToken(optional, optional));
                }
            }
            this.allowSimpleKey = this.isBlockContext();
            this.removePossibleSimpleKey();
        }
        object = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional = this.reader.getMark();
        object = new ValueToken((Optional<Mark>)object, optional);
        this.addToken((Token)object);
    }

    private void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(false);
        this.addToken(token);
    }

    private void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(true);
        this.addToken(token);
    }

    private void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken(token);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar(ScalarStyle.LITERAL);
    }

    private void fetchFolded() {
        this.fetchBlockScalar(ScalarStyle.FOLDED);
    }

    private void fetchBlockScalar(ScalarStyle object) {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        object = this.scanBlockScalar((ScalarStyle)((Object)object));
        this.addAllTokens((List<Token>)object);
    }

    private void fetchSingle() {
        this.fetchFlowScalar(ScalarStyle.SINGLE_QUOTED);
    }

    private void fetchDouble() {
        this.fetchFlowScalar(ScalarStyle.DOUBLE_QUOTED);
    }

    private void fetchFlowScalar(ScalarStyle object) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        object = this.scanFlowScalar((ScalarStyle)((Object)object));
        this.addToken((Token)object);
    }

    private void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.addToken(token);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        if (this.reader.getColumn() == 0) {
            return "---".equals(this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkDocumentEnd() {
        if (this.reader.getColumn() == 0) {
            return "...".equals(this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkBlockEntry() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkKey() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.isFlowContext()) {
            return true;
        }
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int n2 = this.reader.peek();
        boolean bl2 = CharConstants.NULL_BL_T_LINEBR.hasNo(n2, "-?:,[]{}#&*!|>'\"%@`");
        if (bl2) {
            return true;
        }
        if (this.isBlockContext()) {
            return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && "-?:".indexOf(n2) != -1;
        }
        return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1), ",]") && "-?".indexOf(n2) != -1;
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean bl2 = false;
        int n2 = -1;
        while (!bl2) {
            Optional<String> optional;
            Optional<Mark> optional2 = this.reader.getMark();
            int n3 = this.reader.getColumn();
            boolean bl3 = false;
            int n4 = 0;
            while (this.reader.peek(n4) == 32) {
                ++n4;
            }
            if (n4 > 0) {
                this.reader.forward(n4);
            }
            if (this.reader.peek() == 35) {
                Object object;
                bl3 = true;
                if (n3 != 0 && (this.lastToken == null || this.lastToken.getTokenId() != Token.ID.BlockEntry)) {
                    object = CommentType.IN_LINE;
                    n2 = this.reader.getColumn();
                } else if (n2 == this.reader.getColumn()) {
                    object = CommentType.IN_LINE;
                } else {
                    n2 = -1;
                    object = CommentType.BLOCK;
                }
                object = this.scanComment((CommentType)((Object)object));
                if (this.settings.getParseComments()) {
                    this.addToken((Token)object);
                }
            }
            if ((optional = this.scanLineBreak()).isPresent()) {
                if (this.settings.getParseComments() && !bl3 && n3 == 0) {
                    this.addToken(new CommentToken(CommentType.BLANK_LINE, optional.get(), optional2, this.reader.getMark()));
                }
                if (!this.isBlockContext()) continue;
                this.allowSimpleKey = true;
                continue;
            }
            bl2 = true;
        }
    }

    private CommentToken scanComment(CommentType commentType) {
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        int n2 = 0;
        while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n2))) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        Optional<Mark> optional2 = this.reader.getMark();
        return new CommentToken(commentType, string, optional, optional2);
    }

    private List<Token> scanDirective() {
        Optional<Mark> optional;
        Optional<List<Object>> optional2;
        Object object = this.reader.getMark();
        this.reader.forward();
        String string = this.scanDirectiveName((Optional<Mark>)object);
        if ("YAML".equals(string)) {
            optional2 = Optional.of(this.scanYamlDirectiveValue((Optional<Mark>)object));
            optional = this.reader.getMark();
        } else if ("TAG".equals(string)) {
            optional2 = Optional.of(this.scanTagDirectiveValue((Optional<Mark>)object));
            optional = this.reader.getMark();
        } else {
            optional = this.reader.getMark();
            int n2 = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n2))) {
                ++n2;
            }
            if (n2 > 0) {
                this.reader.forward(n2);
            }
            optional2 = Optional.empty();
        }
        CommentToken commentToken = this.scanDirectiveIgnoredLine((Optional<Mark>)object);
        object = new DirectiveToken(string, optional2, (Optional<Mark>)object, optional);
        return this.makeTokenList(new Token[]{object, commentToken});
    }

    private String scanDirectiveName(Optional<Mark> optional) {
        int n2 = 0;
        int n3 = this.reader.peek(0);
        while (CharConstants.ALPHA.has(n3)) {
            n3 = this.reader.peek(++n2);
        }
        if (n2 == 0) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, EXPECTED_ALPHA_ERROR_PREFIX + string + "(" + n3 + ")", this.reader.getMark());
        }
        String string = this.reader.prefixForward(n2);
        n3 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n3)) {
            string = String.valueOf(Character.toChars(n3));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, EXPECTED_ALPHA_ERROR_PREFIX + string + "(" + n3 + ")", this.reader.getMark());
        }
        return string;
    }

    private List<Integer> scanYamlDirectiveValue(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Integer n2 = this.scanYamlDirectiveNumber(optional);
        int n3 = this.reader.peek();
        if (n3 != 46) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit or '.', but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        this.reader.forward();
        Integer n4 = this.scanYamlDirectiveNumber(optional);
        n3 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n3)) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit or ' ', but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(n2);
        arrayList.add(n4);
        return arrayList;
    }

    private Integer scanYamlDirectiveNumber(Optional<Mark> optional) {
        int n2 = this.reader.peek();
        if (!Character.isDigit(n2)) {
            String string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit, but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        int n3 = 0;
        while (Character.isDigit(this.reader.peek(n3))) {
            ++n3;
        }
        return Integer.parseInt(this.reader.prefixForward(n3));
    }

    private List<String> scanTagDirectiveValue(Optional<Mark> object) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String string = this.scanTagDirectiveHandle((Optional<Mark>)object);
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        object = this.scanTagDirectivePrefix((Optional<Mark>)object);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add((String)object);
        return arrayList;
    }

    private String scanTagDirectiveHandle(Optional<Mark> optional) {
        String string = this.scanTagHandle("directive", optional);
        int n2 = this.reader.peek();
        if (n2 != 32) {
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected ' ', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return string;
    }

    private String scanTagDirectivePrefix(Optional<Mark> optional) {
        String string = this.scanTagUri("directive", CharConstants.URI_CHARS_FOR_TAG_PREFIX, optional);
        int n2 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n2)) {
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected ' ', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return string;
    }

    private CommentToken scanDirectiveIgnoredLine(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Object object = null;
        if (this.reader.peek() == 35) {
            CommentToken commentToken = this.scanComment(CommentType.IN_LINE);
            if (this.settings.getParseComments()) {
                object = commentToken;
            }
        }
        int n2 = this.reader.peek();
        if (!this.scanLineBreak().isPresent() && n2 != 0) {
            object = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a comment or a line break, but found " + (String)object + "(" + n2 + ")", this.reader.getMark());
        }
        return object;
    }

    private Token scanAnchor(boolean bl2) {
        Optional<Mark> optional = this.reader.getMark();
        int n2 = this.reader.peek();
        String string = n2 == 42 ? "alias" : "anchor";
        this.reader.forward();
        int n3 = 0;
        int n4 = this.reader.peek(0);
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(n4, ",[]{}/.*&")) {
            n4 = this.reader.peek(++n3);
        }
        if (n3 == 0) {
            String string2 = String.valueOf(Character.toChars(n4));
            throw new ScannerException("while scanning an " + string, optional, "unexpected character found " + string2 + "(" + n4 + ")", this.reader.getMark());
        }
        String string3 = this.reader.prefixForward(n3);
        n4 = this.reader.peek();
        if (CharConstants.NULL_BL_T_LINEBR.hasNo(n4, "?:,]}%@`")) {
            String string4 = String.valueOf(Character.toChars(n4));
            throw new ScannerException("while scanning an " + string, optional, "unexpected character found " + string4 + "(" + n4 + ")", this.reader.getMark());
        }
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl2 ? new AnchorToken(new Anchor(string3), optional, optional2) : new AliasToken(new Anchor(string3), optional, optional2);
        return token;
    }

    private Token scanTag() {
        Object object;
        Optional<Mark> optional = this.reader.getMark();
        int n2 = this.reader.peek(1);
        Object object2 = null;
        if (n2 == 60) {
            this.reader.forward(2);
            object = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_PREFIX, optional);
            n2 = this.reader.peek();
            if (n2 != 62) {
                object2 = String.valueOf(Character.toChars(n2));
                throw new ScannerException("while scanning a tag", optional, "expected '>', but found '" + (String)object2 + "' (" + n2 + ")", this.reader.getMark());
            }
            this.reader.forward();
        } else if (CharConstants.NULL_BL_T_LINEBR.has(n2)) {
            object = "!";
            this.reader.forward();
        } else {
            int n3 = 1;
            boolean bl2 = false;
            while (CharConstants.NULL_BL_LINEBR.hasNo(n2)) {
                if (n2 == 33) {
                    bl2 = true;
                    break;
                }
                n2 = this.reader.peek(++n3);
            }
            if (bl2) {
                object2 = this.scanTagHandle("tag", optional);
            } else {
                object2 = "!";
                this.reader.forward();
            }
            object = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_SUFFIX, optional);
        }
        n2 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n2)) {
            object2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a tag", optional, "expected ' ', but found '" + (String)object2 + "' (" + n2 + ")", this.reader.getMark());
        }
        object2 = new TagTuple(Optional.ofNullable(object2), (String)object);
        object = this.reader.getMark();
        return new TagToken((TagTuple)object2, optional, (Optional<Mark>)object);
    }

    private List<Token> scanBlockScalar(ScalarStyle scalarStyle) {
        int n2;
        Object object;
        String string;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        Chomping chomping = this.scanBlockScalarIndicators(optional);
        CommentToken commentToken = this.scanBlockScalarIgnoredLine(optional);
        int n3 = this.indent + 1;
        if (n3 <= 0) {
            n3 = 1;
        }
        if (chomping.increment.isPresent()) {
            n3 = n3 + (Integer)chomping.increment.get() - 1;
            object2 = this.scanBlockScalarBreaks(n3);
            string = (String)object2[0];
            object = (Optional)object2[1];
        } else {
            object2 = this.scanBlockScalarIndentation();
            string = (String)object2[0];
            n2 = (Integer)object2[1];
            object = (Object[])object2[2];
            n3 = Math.max(n3, n2);
        }
        object2 = Optional.empty();
        if (this.reader.getColumn() < n3 && this.indent != this.reader.getColumn()) {
            throw new ScannerException(SCANNING_SCALAR, optional, " the leading empty lines contain more spaces (" + n3 + ") than the first non-empty line.", this.reader.getMark());
        }
        while (this.reader.getColumn() == n3 && this.reader.peek() != 0) {
            stringBuilder.append(string);
            n2 = " \t".indexOf(this.reader.peek()) == -1 ? 1 : 0;
            int n4 = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n4))) {
                ++n4;
            }
            stringBuilder.append(this.reader.prefixForward(n4));
            object2 = this.scanLineBreak();
            object = this.scanBlockScalarBreaks(n3);
            string = (String)object[0];
            object = (Optional)object[1];
            if (this.reader.getColumn() != n3 || this.reader.peek() == 0) break;
            if (scalarStyle == ScalarStyle.FOLDED && "\n".equals(((Optional)object2).orElse("")) && n2 != 0 && " \t".indexOf(this.reader.peek()) == -1) {
                if (string.length() != 0) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(((Optional)object2).orElse(""));
        }
        if (chomping.value == Chomping.Indicator.CLIP || chomping.value == Chomping.Indicator.KEEP) {
            stringBuilder.append(((Optional)object2).orElse(""));
        }
        if (chomping.value == Chomping.Indicator.KEEP) {
            stringBuilder.append(string);
        }
        ScalarToken scalarToken = new ScalarToken(stringBuilder.toString(), false, scalarStyle, optional, (Optional<Mark>)object);
        return this.makeTokenList(commentToken, scalarToken);
    }

    private Chomping scanBlockScalarIndicators(Optional<Mark> optional) {
        int n2 = Integer.MIN_VALUE;
        Optional<Integer> optional2 = Optional.empty();
        int n3 = this.reader.peek();
        if (n3 == 45 || n3 == 43) {
            n2 = n3;
            this.reader.forward();
            n3 = this.reader.peek();
            if (Character.isDigit(n3)) {
                int n4 = Integer.parseInt(String.valueOf(Character.toChars(n3)));
                if (n4 == 0) {
                    throw new ScannerException(SCANNING_SCALAR, optional, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
                }
                optional2 = Optional.of(n4);
                this.reader.forward();
            }
        } else if (Character.isDigit(n3)) {
            int n5 = Integer.parseInt(String.valueOf(Character.toChars(n3)));
            if (n5 == 0) {
                throw new ScannerException(SCANNING_SCALAR, optional, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
            }
            optional2 = Optional.of(n5);
            this.reader.forward();
            n3 = this.reader.peek();
            if (n3 == 45 || n3 == 43) {
                n2 = n3;
                this.reader.forward();
            }
        }
        if (CharConstants.NULL_BL_LINEBR.hasNo(n3 = this.reader.peek())) {
            optional2 = String.valueOf(Character.toChars(n3));
            throw new ScannerException(SCANNING_SCALAR, optional, "expected chomping or indentation indicators, but found " + optional2 + "(" + n3 + ")", this.reader.getMark());
        }
        return new Chomping(n2, optional2);
    }

    private CommentToken scanBlockScalarIgnoredLine(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Object object = null;
        if (this.reader.peek() == 35) {
            object = this.scanComment(CommentType.IN_LINE);
        }
        int n2 = this.reader.peek();
        if (!this.scanLineBreak().isPresent() && n2 != 0) {
            object = String.valueOf(Character.toChars(n2));
            throw new ScannerException(SCANNING_SCALAR, optional, "expected a comment or a line break, but found " + (String)object + "(" + n2 + ")", this.reader.getMark());
        }
        return object;
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Optional<Mark> optional = this.reader.getMark();
        while (CharConstants.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                stringBuilder.append(this.scanLineBreak().orElse(""));
                optional = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= n2) continue;
            n2 = this.reader.getColumn();
        }
        return new Object[]{stringBuilder.toString(), n2, optional};
    }

    private Object[] scanBlockScalarBreaks(int n2) {
        Optional<String> optional;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional2 = this.reader.getMark();
        for (n3 = this.reader.getColumn(); n3 < n2 && this.reader.peek() == 32; ++n3) {
            this.reader.forward();
        }
        while ((optional = this.scanLineBreak()).isPresent()) {
            stringBuilder.append(optional.get());
            optional2 = this.reader.getMark();
            for (n3 = this.reader.getColumn(); n3 < n2 && this.reader.peek() == 32; ++n3) {
                this.reader.forward();
            }
        }
        return new Object[]{stringBuilder.toString(), optional2};
    }

    private Token scanFlowScalar(ScalarStyle scalarStyle) {
        boolean bl2 = scalarStyle == ScalarStyle.DOUBLE_QUOTED;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional = this.reader.getMark();
        int n2 = this.reader.peek();
        this.reader.forward();
        stringBuilder.append(this.scanFlowScalarNonSpaces(bl2, optional));
        while (this.reader.peek() != n2) {
            stringBuilder.append(this.scanFlowScalarSpaces(optional));
            stringBuilder.append(this.scanFlowScalarNonSpaces(bl2, optional));
        }
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        return new ScalarToken(stringBuilder.toString(), false, scalarStyle, optional, optional2);
    }

    private String scanFlowScalarNonSpaces(boolean bl2, Optional<Mark> optional) {
        StringBuilder stringBuilder;
        block8: {
            String string;
            int n2;
            stringBuilder = new StringBuilder();
            while (true) {
                n2 = 0;
                while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(n2), "'\"\\")) {
                    ++n2;
                }
                if (n2 != 0) {
                    stringBuilder.append(this.reader.prefixForward(n2));
                }
                n2 = this.reader.peek();
                if (!bl2 && n2 == 39 && this.reader.peek(1) == 39) {
                    stringBuilder.append("'");
                    this.reader.forward(2);
                    continue;
                }
                if (bl2 && n2 == 39 || !bl2 && "\"\\".indexOf(n2) != -1) {
                    stringBuilder.appendCodePoint(n2);
                    this.reader.forward();
                    continue;
                }
                if (!bl2 || n2 != 92) break block8;
                this.reader.forward();
                n2 = this.reader.peek();
                if (!Character.isSupplementaryCodePoint(n2) && CharConstants.ESCAPE_REPLACEMENTS.containsKey(Character.valueOf((char)n2))) {
                    stringBuilder.append(CharConstants.ESCAPE_REPLACEMENTS.get(Character.valueOf((char)n2)));
                    this.reader.forward();
                    continue;
                }
                if (!Character.isSupplementaryCodePoint(n2) && CharConstants.ESCAPE_CODES.containsKey(Character.valueOf((char)n2))) {
                    n2 = CharConstants.ESCAPE_CODES.get(Character.valueOf((char)n2));
                    this.reader.forward();
                    string = this.reader.prefix(n2);
                    if (NOT_HEXA.matcher(string).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", optional, "expected escape sequence of " + n2 + " hexadecimal numbers, but found: " + string, this.reader.getMark());
                    }
                    int n3 = Integer.parseInt(string, 16);
                    string = new String(Character.toChars(n3));
                    stringBuilder.append(string);
                    this.reader.forward(n2);
                    continue;
                }
                if (!this.scanLineBreak().isPresent()) break;
                stringBuilder.append(this.scanFlowScalarBreaks(optional));
            }
            string = String.valueOf(Character.toChars(n2));
            throw new ScannerException("while scanning a double-quoted scalar", optional, "found unknown escape character " + string + "(" + n2 + ")", this.reader.getMark());
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarSpaces(Optional<Mark> object) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (" \t".indexOf(this.reader.peek(n2)) != -1) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        int n3 = this.reader.peek();
        if (n3 == 0) {
            throw new ScannerException("while scanning a quoted scalar", (Optional<Mark>)object, "found unexpected end of stream", this.reader.getMark());
        }
        Optional<String> optional = this.scanLineBreak();
        if (optional.isPresent()) {
            object = this.scanFlowScalarBreaks((Optional<Mark>)object);
            if (!"\n".equals(optional.get())) {
                stringBuilder.append(optional.get());
            } else if (((String)object).length() == 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append((String)object);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarBreaks(Optional<Mark> optional) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            Optional<String> optional2;
            if (("---".equals(optional2 = this.reader.prefix(3)) || "...".equals(optional2)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", optional, "found unexpected document separator", this.reader.getMark());
            }
            while (" \t".indexOf(this.reader.peek()) != -1) {
                this.reader.forward();
            }
            optional2 = this.scanLineBreak();
            if (!optional2.isPresent()) break;
            stringBuilder.append((String)optional2.get());
        }
        return stringBuilder.toString();
    }

    private Token scanPlain() {
        Optional<Mark> optional;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional2 = optional = this.reader.getMark();
        int n2 = this.indent + 1;
        String string = "";
        do {
            int n3;
            int n4 = 0;
            if (this.reader.peek() == 35) break;
            while (!(CharConstants.NULL_BL_T_LINEBR.has(n3 = this.reader.peek(n4)) || n3 == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(n4 + 1), this.isFlowContext() ? ",[]{}" : "") || this.isFlowContext() && ",[]{}".indexOf(n3) != -1)) {
                ++n4;
            }
            if (n4 == 0) break;
            this.allowSimpleKey = false;
            stringBuilder.append(string);
            stringBuilder.append(this.reader.prefixForward(n4));
            optional2 = this.reader.getMark();
            string = this.scanPlainSpaces();
        } while (string.length() != 0 && this.reader.peek() != 35 && (!this.isBlockContext() || this.reader.getColumn() >= n2));
        return new ScalarToken(stringBuilder.toString(), true, optional, optional2);
    }

    private boolean atEndOfPlain() {
        int n2;
        int n3 = 0;
        int n4 = this.reader.getColumn();
        while ((n2 = this.reader.peek(n3)) != 0 && CharConstants.NULL_BL_T_LINEBR.has(n2)) {
            if (!(CharConstants.LINEBR.has(n2) || n2 == 13 && this.reader.peek(++n3 + 1) == 10 || n2 == 65279)) {
                ++n4;
                continue;
            }
            n4 = 0;
        }
        if (this.reader.peek(n3) == 35 || this.reader.peek(n3 + 1) == 0 || this.isBlockContext() && n4 < this.indent) {
            return true;
        }
        if (this.isBlockContext()) {
            n4 = 1;
            while ((n2 = this.reader.peek(n3 + n4)) != 0 && !CharConstants.NULL_BL_T_LINEBR.has(n2)) {
                if (n2 == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(n3 + n4 + 1))) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    private String scanPlainSpaces() {
        int n2 = 0;
        while (this.reader.peek(n2) == 32 || this.reader.peek(n2) == 9) {
            ++n2;
        }
        Object object = this.reader.prefixForward(n2);
        Optional<String> optional = this.scanLineBreak();
        if (optional.isPresent()) {
            StringBuilder stringBuilder;
            block8: {
                this.allowSimpleKey = true;
                object = this.reader.prefix(3);
                if ("---".equals(object) || "...".equals(object) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                    return "";
                }
                if (this.settings.getParseComments() && this.atEndOfPlain()) {
                    return "";
                }
                stringBuilder = new StringBuilder();
                while (true) {
                    if (this.reader.peek() == 32) {
                        this.reader.forward();
                        continue;
                    }
                    object = this.scanLineBreak();
                    if (!((Optional)object).isPresent()) break block8;
                    stringBuilder.append((String)((Optional)object).get());
                    object = this.reader.prefix(3);
                    if ("---".equals(object) || "...".equals(object) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(optional.orElse(""))) {
                return optional.orElse("") + stringBuilder;
            }
            if (stringBuilder.length() == 0) {
                return " ";
            }
            return stringBuilder.toString();
        }
        return object;
    }

    private String scanTagHandle(String string, Optional<Mark> optional) {
        int n2 = this.reader.peek();
        if (n2 != 33) {
            String string2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected '!', but found " + string2 + "(" + n2 + ")", this.reader.getMark());
        }
        int n3 = 1;
        n2 = this.reader.peek(1);
        if (n2 != 32) {
            while (CharConstants.ALPHA.has(n2)) {
                n2 = this.reader.peek(++n3);
            }
            if (n2 != 33) {
                this.reader.forward(n3);
                String string3 = String.valueOf(Character.toChars(n2));
                throw new ScannerException(SCANNING_PREFIX + string, optional, "expected '!', but found " + string3 + "(" + n2 + ")", this.reader.getMark());
            }
            ++n3;
        }
        return this.reader.prefixForward(n3);
    }

    private String scanTagUri(String string, CharConstants object, Optional<Mark> optional) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = this.reader.peek(0);
        while (((CharConstants)object).has(n3)) {
            if (n3 == 37) {
                stringBuilder.append(this.reader.prefixForward(n2));
                n2 = 0;
                stringBuilder.append(this.scanUriEscapes(string, optional));
            } else {
                ++n2;
            }
            n3 = this.reader.peek(n2);
        }
        if (n2 != 0) {
            stringBuilder.append(this.reader.prefixForward(n2));
        }
        if (stringBuilder.length() == 0) {
            object = String.valueOf(Character.toChars(n3));
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI, but found " + (String)object + "(" + n3 + ")", this.reader.getMark());
        }
        return stringBuilder.toString();
    }

    private String scanUriEscapes(String string, Optional<Mark> optional) {
        int n2 = 1;
        while (this.reader.peek(n2 * 3) == 37) {
            ++n2;
        }
        Object object = this.reader.getMark();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        while (this.reader.peek() == 37) {
            int n3;
            this.reader.forward();
            try {
                n3 = Integer.parseInt(this.reader.prefix(2), 16);
                byteBuffer.put((byte)n3);
            }
            catch (NumberFormatException numberFormatException) {
                int n4 = this.reader.peek();
                object = String.valueOf(Character.toChars(n4));
                n3 = this.reader.peek(1);
                String string2 = String.valueOf(Character.toChars(n3));
                throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI escape sequence of 2 hexadecimal numbers, but found " + (String)object + "(" + n4 + ") and " + string2 + "(" + n3 + ")", this.reader.getMark());
            }
            this.reader.forward(2);
        }
        byteBuffer.flip();
        try {
            return UriEncoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI in UTF-8: " + characterCodingException.getMessage(), (Optional<Mark>)object);
        }
    }

    private Optional<String> scanLineBreak() {
        int n2 = this.reader.peek();
        if (n2 == 13 || n2 == 10 || n2 == 133) {
            if (n2 == 13 && 10 == this.reader.peek(1)) {
                this.reader.forward(2);
            } else {
                this.reader.forward();
            }
            return Optional.of("\n");
        }
        if (n2 == 8232 || n2 == 8233) {
            this.reader.forward();
            return Optional.of(String.valueOf(Character.toChars(n2)));
        }
        return Optional.empty();
    }

    private List<Token> makeTokenList(Token ... tokenArray) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i2 = 0; i2 < tokenArray.length; ++i2) {
            if (tokenArray[i2] == null || !this.settings.getParseComments() && tokenArray[i2] instanceof CommentToken) continue;
            arrayList.add(tokenArray[i2]);
        }
        return arrayList;
    }

    static class Chomping {
        private final Indicator value;
        private final Optional<Integer> increment;

        public Chomping(Indicator indicator, Optional<Integer> optional) {
            this.value = indicator;
            this.increment = optional;
        }

        public Chomping(int n2, Optional<Integer> optional) {
            this(Chomping.parse(n2), optional);
        }

        private static Indicator parse(int n2) {
            if (n2 == 43) {
                return Indicator.KEEP;
            }
            if (n2 == 45) {
                return Indicator.STRIP;
            }
            if (n2 == Integer.MIN_VALUE) {
                return Indicator.CLIP;
            }
            throw new IllegalArgumentException("Unexpected block chomping indicator: " + n2);
        }

        static enum Indicator {
            STRIP,
            CLIP,
            KEEP;

        }
    }
}

